/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.api.machine;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.utils.TaskHandler;
import com.gtocore.common.machine.multiblock.part.ae.MEDualOutputPartMachine;
import com.gtocore.common.machine.multiblock.part.ae.MEOutputBusPartMachine;
import com.gtocore.common.machine.multiblock.part.ae.MEOutputHatchPartMachine;
import com.gtolib.api.machine.feature.ISpaceWorkspaceMachine;
import com.gtolib.api.machine.feature.IWorkInSpaceMachine;
import com.gtolib.api.machine.feature.multiblock.IEnhancedMultiblockMachine;
import com.gtolib.api.machine.feature.multiblock.IExtendedRecipeCapabilityHolder;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorkableMultiblockMachine.class})
public abstract class WorkableMultiblockMachineMixin
extends MultiblockControllerMachine
implements IExtendedRecipeCapabilityHolder,
IWorkInSpaceMachine {
    @Shadow(remap=false)
    @Final
    protected List<ISubscription> traitSubscriptions;
    @Unique
    private Map<RecipeCapability<?>, List<IRecipeHandler<?>>> gtolib$input;
    @Unique
    private boolean gtolib$isItemOutput;
    @Unique
    private boolean gtolib$isFluidOutput;
    @Unique
    private boolean gtolib$isDualOutput;
    @Unique
    private ISpaceWorkspaceMachine gto$workspaceProvider;

    public ISpaceWorkspaceMachine getWorkspaceProvider() {
        return this.gto$workspaceProvider;
    }

    public void setWorkspaceProvider(ISpaceWorkspaceMachine iSpaceWorkspaceMachine) {
        this.gto$workspaceProvider = iSpaceWorkspaceMachine;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void gtolib$init(MetaMachineBlockEntity holder, Object[] args, CallbackInfo ci) {
        this.gtolib$input = Map.of();
    }

    protected WorkableMultiblockMachineMixin(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public boolean canVoidRecipeOutputs(RecipeCapability<?> capability) {
        if (this.gtolib$isDualOutput || this.getVoidingMode().canVoid(capability)) {
            return true;
        }
        if (capability == ItemRecipeCapability.CAP) {
            return this.gtolib$isItemOutput;
        }
        return this.gtolib$isFluidOutput;
    }

    @Inject(method={"onStructureFormedAfter"}, at={@At(value="HEAD")}, remap=false)
    private void onStructureFormedAfter(CallbackInfo ci) {
        this.arrangeFlat();
    }

    @Inject(method={"onStructureFormed"}, at={@At(value="TAIL")}, remap=false)
    private void onPartScan(CallbackInfo ci) {
        for (IMultiPart part : this.parts) {
            WorkableMultiblockMachineMixin workableMultiblockMachineMixin = this;
            if (workableMultiblockMachineMixin instanceof IEnhancedMultiblockMachine) {
                IEnhancedMultiblockMachine enhancedRecipeLogicMachine = (IEnhancedMultiblockMachine)workableMultiblockMachineMixin;
                enhancedRecipeLogicMachine.onPartScan(part);
            }
            if (this.gtolib$isItemOutput && this.gtolib$isFluidOutput) {
                this.gtolib$isDualOutput = true;
                continue;
            }
            if (part instanceof MEDualOutputPartMachine) {
                this.gtolib$isItemOutput = true;
                this.gtolib$isFluidOutput = true;
                this.gtolib$isDualOutput = true;
                continue;
            }
            if (part instanceof MEOutputBusPartMachine) {
                this.gtolib$isItemOutput = true;
                continue;
            }
            if (!(part instanceof MEOutputHatchPartMachine)) continue;
            this.gtolib$isFluidOutput = true;
        }
    }

    @Inject(method={"onStructureInvalid"}, at={@At(value="TAIL")}, remap=false)
    private void onStructureInvalid(CallbackInfo ci) {
        this.gtolib$isItemOutput = false;
        this.gtolib$isFluidOutput = false;
        this.gtolib$isDualOutput = false;
    }

    public boolean isDualMEOutput(@NotNull GTRecipe recipe) {
        if (this.gtolib$isDualOutput) {
            return true;
        }
        if (this.gtolib$isItemOutput || recipe.outputs.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList()).isEmpty()) {
            return this.gtolib$isFluidOutput || recipe.outputs.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty();
        }
        return false;
    }

    public void addHandlerList(RecipeHandlerList handler) {
        WorkableMultiblockMachineMixin entry;
        if (handler == RecipeHandlerList.NO_DATA) {
            return;
        }
        IO io = handler.getHandlerIO();
        this.getCapabilitiesProxy().computeIfAbsent(io, i -> new ArrayList()).add(handler);
        Map inner = this.getCapabilitiesFlat().computeIfAbsent(io, i -> new Reference2ObjectOpenHashMap(handler.handlerMap.size()));
        ObjectIterator it = handler.handlerMap.reference2ObjectEntrySet().fastIterator();
        while (it.hasNext()) {
            entry = (Reference2ObjectMap.Entry)it.next();
            List entryList = (List)entry.getValue();
            inner.computeIfAbsent((RecipeCapability)entry.getKey(), c -> new ArrayList(entryList.size())).addAll(entryList);
        }
        entry = this;
        if (entry instanceof IEnhancedMultiblockMachine) {
            IEnhancedMultiblockMachine enhancedRecipeLogicMachine = (IEnhancedMultiblockMachine)entry;
            if (handler.hasCapability((RecipeCapability)ItemRecipeCapability.CAP) || handler.hasCapability((RecipeCapability)FluidRecipeCapability.CAP)) {
                this.traitSubscriptions.add(handler.subscribe(() -> enhancedRecipeLogicMachine.onContentChanges(handler)));
                Level level = this.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    TaskHandler.enqueueServerTask((ServerLevel)serverLevel, () -> enhancedRecipeLogicMachine.onContentChanges(handler), (int)0);
                }
            }
        }
    }

    public void gtolib$setInputFlat(Map<RecipeCapability<?>, List<IRecipeHandler<?>>> input) {
        this.gtolib$input = input;
    }

    @NotNull
    public Map<RecipeCapability<?>, List<IRecipeHandler<?>>> gtolib$getInputFlat() {
        return this.gtolib$input;
    }
}

