/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.api.machine;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.WorkableTieredMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtocore.common.machine.multiblock.part.ProgrammableHatchPartMachine;
import com.gtolib.api.capability.IWirelessChargerInteraction;
import com.gtolib.api.machine.feature.IPowerAmplifierMachine;
import com.gtolib.api.machine.feature.IUpgradeMachine;
import com.gtolib.api.machine.impl.WirelessChargerMachine;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.hepdd.gtmthings.api.machine.IProgrammableMachine;
import com.hepdd.gtmthings.data.CustomItems;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SimpleTieredMachine.class})
public abstract class SimpleTieredMachineMixin
extends WorkableTieredMachine
implements IUpgradeMachine,
IPowerAmplifierMachine,
IWirelessChargerInteraction,
IProgrammableMachine {
    @Unique
    private double gtolib$speed;
    @Unique
    private double gtolib$energy;
    @Unique
    private double gtolib$powerAmplifier;
    @Unique
    private boolean gtolib$hasPowerAmplifier;
    @Unique
    private WirelessChargerMachine gtolib$netMachineCache;
    @Unique
    private TickableSubscription gtolib$tickSubs;
    @Unique
    private boolean gtolib$isProgrammable;

    protected SimpleTieredMachineMixin(MetaMachineBlockEntity holder, int tier, Int2IntFunction tankScalingFunction, Object ... args) {
        super(holder, tier, tankScalingFunction, args);
    }

    @Inject(method={"createCircuitItemHandler"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void createCircuitItemHandler(Object[] args, CallbackInfoReturnable<NotifiableItemStackHandler> cir) {
        cir.setReturnValue((Object)new ProgrammableHatchPartMachine.ProgrammableCircuitHandler((MetaMachine)this));
    }

    @NotNull
    protected NotifiableItemStackHandler createImportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler((MetaMachine)this, this.getRecipeType().getMaxInputs((RecipeCapability)ItemRecipeCapability.CAP), IO.IN).setFilter(i -> !i.m_41782_() || !i.m_150930_((Item)CustomItems.VIRTUAL_ITEM_PROVIDER.get()));
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void init(CallbackInfo ci) {
        this.gtolib$speed = 1.0;
        this.gtolib$energy = 1.0;
        this.gtolib$powerAmplifier = 1.0;
    }

    @Inject(method={"onLoad"}, at={@At(value="TAIL")}, remap=false)
    private void onLoad(CallbackInfo ci) {
        if (!this.isRemote()) {
            this.gtolib$tickSubs = this.subscribeServerTick(this.gtolib$tickSubs, () -> this.charge(this.gtolib$tickSubs), 20);
        }
    }

    @Inject(method={"onUnload"}, at={@At(value="TAIL")}, remap=false)
    private void onUnload(CallbackInfo ci) {
        if (this.gtolib$tickSubs != null) {
            this.gtolib$tickSubs.unsubscribe();
            this.gtolib$tickSubs = null;
        }
        this.removeNetMachineCache();
    }

    public void saveCustomPersistedData(@NotNull CompoundTag tag, boolean forDrop) {
        super.saveCustomPersistedData(tag, forDrop);
        tag.m_128347_("speed", this.gtolib$speed);
        tag.m_128347_("energy", this.gtolib$energy);
    }

    public void loadCustomPersistedData(@NotNull CompoundTag tag) {
        double energy;
        super.loadCustomPersistedData(tag);
        double speed = tag.m_128459_("speed");
        if (speed != 0.0) {
            this.gtolib$speed = speed;
        }
        if ((energy = tag.m_128459_("energy")) != 0.0) {
            this.gtolib$energy = energy;
        }
    }

    public void gtolib$setSpeed(double speed) {
        this.gtolib$speed = speed;
    }

    public void gtolib$setEnergy(double energy) {
        this.gtolib$energy = energy;
    }

    public double gtolib$getSpeed() {
        return this.gtolib$speed;
    }

    public double gtolib$getEnergy() {
        return this.gtolib$energy;
    }

    public double gtolib$getPowerAmplifier() {
        return this.gtolib$powerAmplifier;
    }

    public void gtolib$setPowerAmplifier(double powerAmplifier) {
        this.gtolib$powerAmplifier = powerAmplifier;
    }

    public boolean gtolib$noPowerAmplifier() {
        return !this.gtolib$hasPowerAmplifier;
    }

    public void gtolib$setHasPowerAmplifier(boolean hasPowerAmplifier) {
        this.gtolib$hasPowerAmplifier = hasPowerAmplifier;
    }

    public boolean gtolib$canUpgraded() {
        return true;
    }

    public void attachTooltips(TooltipsPanel tooltipsPanel) {
        tooltipsPanel.attachTooltips(new IFancyTooltip[]{this});
        this.getTraits().stream().filter(IFancyTooltip.class::isInstance).map(IFancyTooltip.class::cast).forEach(xva$0 -> tooltipsPanel.attachTooltips(new IFancyTooltip[]{xva$0}));
        RecipeLogic recipeLogic = this.getRecipeLogic();
        if (recipeLogic instanceof IEnhancedRecipeLogic) {
            IEnhancedRecipeLogic enhancedRecipeLogic = (IEnhancedRecipeLogic)recipeLogic;
            tooltipsPanel.attachTooltips(new IFancyTooltip[]{new IFancyTooltip.Basic(() -> GuiTextures.INDICATOR_NO_STEAM.get(true), () -> List.of(enhancedRecipeLogic.gtolib$getIdleReason()), () -> this.getRecipeLogic().isIdle() && enhancedRecipeLogic.gtolib$getIdleReason() != null, () -> null)});
        }
    }

    @Nullable
    public UUID getUUID() {
        return this.getOwnerUUID();
    }

    public void setNetMachineCache(WirelessChargerMachine netMachineCache) {
        this.gtolib$netMachineCache = netMachineCache;
    }

    public WirelessChargerMachine getNetMachineCache() {
        return this.gtolib$netMachineCache;
    }

    public boolean isProgrammable() {
        return this.gtolib$isProgrammable;
    }

    public void setProgrammable(boolean programmable) {
        this.gtolib$isProgrammable = programmable;
    }
}

