/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.eae;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.parts.IPartItem;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.core.definitions.AEItems;
import appeng.parts.automation.AbstractLevelEmitterPart;
import com.glodblock.github.extendedae.common.parts.PartThresholdLevelEmitter;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PartThresholdLevelEmitter.class}, remap=false)
public abstract class PartThresholdLevelEmitterMixin
extends AbstractLevelEmitterPart {
    protected PartThresholdLevelEmitterMixin(IPartItem<?> partItem) {
        super(partItem);
    }

    @Shadow
    @Nullable
    protected abstract AEKey getConfiguredKey();

    @Shadow
    public abstract long getUpperValue();

    @Overwrite
    private void updateReportingValue(IGrid grid) {
        KeyCounter stacks = grid.getStorageService().getCachedInventory();
        AEKey myStack = this.getConfiguredKey();
        if (myStack == null) {
            this.lastReportedValue = 0L;
            for (Reference2LongMap.Entry st : stacks) {
                this.lastReportedValue += st.getLongValue();
                if (this.lastReportedValue <= this.getUpperValue()) continue;
                break;
            }
        } else if (this.isUpgradedWith((ItemLike)AEItems.FUZZY_CARD)) {
            this.lastReportedValue = 0L;
            FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
            for (Object2LongMap.Entry st : stacks.findFuzzy(myStack, fzMode)) {
                this.lastReportedValue += st.getLongValue();
                if (this.lastReportedValue <= this.getUpperValue()) continue;
                break;
            }
        } else {
            this.lastReportedValue = stacks.get(myStack);
        }
        this.updateState();
    }
}

