/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.botania;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.recipe.RunicAltarRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.RunicAltarBlockEntity;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.material.RuneItem;
import vazkii.botania.xplat.XplatAbstractions;

@Mixin(value={RunicAltarBlockEntity.class})
public abstract class RunicAltarBlockEntityMixin
extends SimpleInventoryBlockEntity
implements ManaReceiver,
Wandable {
    @Shadow(remap=false)
    private static final int SET_KEEP_TICKS_EVENT = 0;
    @Shadow(remap=false)
    private static final int SET_COOLDOWN_EVENT = 1;
    @Shadow(remap=false)
    private static final int CRAFT_EFFECT_EVENT = 2;
    @Shadow(remap=false)
    private RunicAltarRecipe currentRecipe;
    @Shadow(remap=false)
    public int manaToGet = 0;
    @Shadow(remap=false)
    private int mana = 0;
    @Shadow(remap=false)
    private List<ItemStack> lastRecipe = null;
    @Shadow(remap=false)
    private int recipeKeepTicks = 0;

    public RunicAltarBlockEntityMixin(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.RUNE_ALTAR, pos, state);
    }

    @Overwrite(remap=false)
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (this.f_58857_.f_46443_) {
            return true;
        }
        RunicAltarRecipe recipe = null;
        if (this.currentRecipe != null) {
            recipe = this.currentRecipe;
        } else {
            Optional maybeRecipe = this.f_58857_.m_7465_().m_44015_(BotaniaRecipeTypes.RUNE_TYPE, this.getItemHandler(), this.f_58857_);
            if (maybeRecipe.isPresent()) {
                recipe = (RunicAltarRecipe)maybeRecipe.get();
            }
        }
        if (recipe != null && this.manaToGet > 0 && this.mana >= this.manaToGet) {
            List items = this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 1, 1)));
            ItemEntity livingrock = null;
            for (ItemEntity item : items) {
                if (!item.m_6084_() || item.m_32055_().m_41619_() || !item.m_32055_().m_150930_(BotaniaBlocks.livingrock.m_5456_())) continue;
                livingrock = item;
                break;
            }
            if (livingrock != null) {
                int mana = recipe.getManaUsage();
                this.receiveMana(-mana);
                ItemStack output = recipe.m_5874_(this.getItemHandler(), this.m_58904_().m_9598_());
                ItemEntity outputItem = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, output);
                XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)outputItem).runicAltarSpawned = true;
                if (player != null) {
                    player.m_280300_((Recipe)recipe, List.of(output));
                    output.m_41678_(this.f_58857_, player, output.m_41613_());
                }
                this.f_58857_.m_7967_((Entity)outputItem);
                this.currentRecipe = null;
                this.f_58857_.m_142346_(null, GameEvent.f_223702_, this.m_58899_());
                this.f_58857_.m_7696_(this.m_58899_(), BotaniaBlocks.runeAltar, 1, 60);
                this.f_58857_.m_7696_(this.m_58899_(), BotaniaBlocks.runeAltar, 2, 0);
                this.saveLastRecipe();
                for (int i = 0; i < this.inventorySize(); ++i) {
                    ItemStack stack = this.getItemHandler().m_8020_(i);
                    if (stack.m_41619_()) continue;
                    if (!(recipe.m_6423_().m_135827_().equals("gtocore") || !(stack.m_41720_() instanceof RuneItem) || player != null && player.m_150110_().f_35937_)) {
                        ItemEntity outputRune = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.5, (double)this.m_58899_().m_123343_() + 0.5, stack.m_41777_());
                        XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)outputRune).runicAltarSpawned = true;
                        this.f_58857_.m_7967_((Entity)outputRune);
                    }
                    this.getItemHandler().m_6836_(i, ItemStack.f_41583_);
                }
                EntityHelper.shrinkItem((ItemEntity)livingrock);
            }
        }
        return true;
    }

    @Shadow(remap=false)
    private void saveLastRecipe() {
        ItemStack stack;
        if (this.lastRecipe == null) {
            this.lastRecipe = new ArrayList<ItemStack>();
        } else {
            this.lastRecipe.clear();
        }
        for (int i = 0; i < this.inventorySize() && !(stack = this.getItemHandler().m_8020_(i)).m_41619_(); ++i) {
            this.lastRecipe.add(stack.m_41777_());
        }
        this.recipeKeepTicks = 400;
        this.f_58857_.m_7696_(this.m_58899_(), BotaniaBlocks.runeAltar, 0, 400);
    }
}

