/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.ae2.storage;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.me.storage.NetworkStorage;
import com.gtocore.common.machine.multiblock.part.ae.StorageAccessPartMachine;
import com.gtolib.utils.holder.IntObjectHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetworkStorage.class})
public abstract class NetworkStorageMixin {
    @Unique
    private List<IntObjectHolder<MEStorage>> gtolib$inventory;
    @Mutable
    @Shadow(remap=false)
    @Final
    private NavigableMap<Integer, List<MEStorage>> priorityInventory;
    @Shadow(remap=false)
    private boolean mountsInUse;
    @Unique
    private boolean gtocore$inUse;

    @Shadow(remap=false)
    protected abstract boolean isQueuedForRemoval(MEStorage var1);

    @Shadow(remap=false)
    protected abstract void flushQueuedOperations();

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void gtolib$init(CallbackInfo ci) {
        this.gtolib$inventory = new ArrayList<IntObjectHolder<MEStorage>>();
        this.priorityInventory = null;
    }

    @Inject(method={"mount"}, at={@At(value="INVOKE", target="Ljava/util/NavigableMap;values()Ljava/util/Collection;")}, remap=false, cancellable=true)
    private void gtolib$mount(int priority, MEStorage inventory, CallbackInfo ci) {
        ci.cancel();
        if (inventory instanceof StorageAccessPartMachine) {
            StorageAccessPartMachine m1 = (StorageAccessPartMachine)inventory;
            for (IntObjectHolder<MEStorage> inv : this.gtolib$inventory) {
                Object object = inv.obj;
                if (!(object instanceof StorageAccessPartMachine)) continue;
                StorageAccessPartMachine m2 = (StorageAccessPartMachine)((Object)object);
                if (((Object)((Object)m1)).getClass() != ((Object)((Object)m2)).getClass() || !m1.uuid.equals(m2.uuid)) continue;
                return;
            }
        } else {
            Object owner = inventory.getStorageOwner();
            for (IntObjectHolder<MEStorage> inv : this.gtolib$inventory) {
                if (((MEStorage)inv.obj).getStorageOwner() != owner) continue;
                return;
            }
        }
        this.gtolib$inventory.add((IntObjectHolder<MEStorage>)new IntObjectHolder(priority, (Object)inventory));
        this.gtolib$inventory.sort(IntObjectHolder.PRIORITY_SORTER);
    }

    @Inject(method={"unmount"}, at={@At(value="INVOKE", target="Ljava/util/NavigableMap;entrySet()Ljava/util/Set;")}, remap=false, cancellable=true)
    private void gtolib$unmount(MEStorage inventory, CallbackInfo ci) {
        Iterator<IntObjectHolder<MEStorage>> ii = this.gtolib$inventory.iterator();
        while (ii.hasNext()) {
            if (ii.next().obj != inventory) continue;
            ii.remove();
        }
        ci.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    public long insert(AEKey what, long amount, Actionable type, IActionSource src) {
        if (this.mountsInUse) {
            return 0L;
        }
        long remaining = amount;
        this.mountsInUse = true;
        try {
            Iterator<IntObjectHolder<MEStorage>> ii = this.gtolib$inventory.iterator();
            while (ii.hasNext() && remaining > 0L) {
                MEStorage inv = (MEStorage)ii.next().obj;
                if (this.isQueuedForRemoval(inv)) continue;
                remaining -= inv.insert(what, remaining, type, src);
            }
        }
        finally {
            this.mountsInUse = false;
        }
        this.flushQueuedOperations();
        return amount - remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.mountsInUse) {
            return 0L;
        }
        long extracted = 0L;
        this.mountsInUse = true;
        try {
            for (int i = this.gtolib$inventory.size() - 1; i >= 0 && extracted < amount; --i) {
                MEStorage inv = (MEStorage)this.gtolib$inventory.get((int)i).obj;
                if (this.isQueuedForRemoval(inv)) continue;
                extracted += inv.extract(what, amount - extracted, mode, source);
            }
        }
        finally {
            this.mountsInUse = false;
        }
        this.flushQueuedOperations();
        return extracted;
    }

    @Overwrite(remap=false)
    public void getAvailableStacks(KeyCounter out) {
        if (this.gtocore$inUse) {
            return;
        }
        this.gtocore$inUse = true;
        try {
            this.gtolib$inventory.forEach(entry -> ((MEStorage)entry.obj).getAvailableStacks(out));
        }
        finally {
            this.gtocore$inUse = false;
        }
    }
}

