/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.ae2.stacks;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyMap;
import appeng.api.stacks.KeyCounter;
import com.gtolib.IUnique;
import com.gtolib.api.ae2.stacks.IKeyCounter;
import com.gtolib.utils.ExpandedO2LMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={KeyCounter.class})
public class KeyCounterMixin
implements Iterable<Reference2LongMap.Entry<AEKey>>,
IKeyCounter {
    @Unique
    private AEKeyMap<AEKey> gtolib$map;
    @Unique
    private Int2ObjectOpenHashMap<ExpandedO2LMap<AEKey>> gtolib$fuzzyMap;
    @Unique
    private boolean gtolib$fuzzyUpdate;

    @Override
    public void forEach(Consumer<? super Reference2LongMap.Entry<AEKey>> consumer) {
        if (this.gtolib$map == null) {
            return;
        }
        this.gtolib$map.reference2LongEntrySet().fastForEach(consumer);
    }

    @Overwrite(remap=false)
    public Collection<Object2LongMap.Entry<AEKey>> findFuzzy(AEKey key, FuzzyMode fuzzy) {
        long value;
        if (this.gtolib$map == null) {
            return Collections.emptyList();
        }
        Object object = key.getPrimaryKey();
        if (object instanceof IUnique) {
            ExpandedO2LMap map;
            IUnique unique = (IUnique)object;
            if (this.gtolib$fuzzyUpdate || this.gtolib$fuzzyMap == null) {
                this.gtolib$fuzzyUpdate = false;
                if (this.gtolib$fuzzyMap == null) {
                    this.gtolib$fuzzyMap = new Int2ObjectOpenHashMap();
                } else {
                    this.gtolib$fuzzyMap.values().forEach(Object2LongOpenHashMap::clear);
                }
                this.gtolib$map.reference2LongEntrySet().fastForEach(e -> {
                    AEKey k = (AEKey)e.getKey();
                    Object patt0$temp = k.getPrimaryKey();
                    if (patt0$temp instanceof IUnique) {
                        IUnique u = (IUnique)patt0$temp;
                        ((ExpandedO2LMap)this.gtolib$fuzzyMap.computeIfAbsent(u.getUid(), _k -> new ExpandedO2LMap())).addTo((Object)k, e.getLongValue());
                    }
                });
            }
            if ((map = (ExpandedO2LMap)this.gtolib$fuzzyMap.get(unique.getUid())) != null) {
                return map.object2LongEntrySet();
            }
        }
        if ((value = this.gtolib$map.getOrDefault((Object)key, Long.MIN_VALUE)) > Long.MIN_VALUE) {
            return Collections.singleton(new IKeyCounter.Entry(value, key));
        }
        return Collections.emptyList();
    }

    @Overwrite(remap=false)
    public void removeZeros() {
        if (this.gtolib$map == null) {
            return;
        }
        Iterator it = this.gtolib$map.iterator();
        while (it.hasNext()) {
            if (((Reference2LongMap.Entry)it.next()).getLongValue() != 0L) continue;
            it.remove();
        }
        this.gtolib$fuzzyUpdate = true;
    }

    @Overwrite(remap=false)
    public void removeEmptySubmaps() {
    }

    @Overwrite(remap=false)
    public void addAll(KeyCounter other) {
        Reference2LongOpenHashMap l = IKeyCounter.of((KeyCounter)other).gtolib$getMap();
        if (l == null) {
            return;
        }
        int size = l.size();
        if (size < 1) {
            return;
        }
        if (this.gtolib$map == null) {
            this.gtolib$map = new AEKeyMap(l.size());
            l.reference2LongEntrySet().fastForEach(entry -> this.gtolib$map.addTo((Object)((AEKey)entry.getKey()), entry.getLongValue()));
        } else {
            this.gtolib$map.ensureCapacity(size);
            l.reference2LongEntrySet().fastForEach(entry -> this.gtolib$map.addTo((Object)((AEKey)entry.getKey()), entry.getLongValue()));
        }
        this.gtolib$fuzzyUpdate = true;
    }

    @Overwrite(remap=false)
    public void removeAll(KeyCounter other) {
        Reference2LongOpenHashMap l = IKeyCounter.of((KeyCounter)other).gtolib$getMap();
        if (l == null) {
            return;
        }
        int size = l.size();
        if (size < 1) {
            return;
        }
        if (this.gtolib$map == null) {
            this.gtolib$map = new AEKeyMap(size);
        } else {
            this.gtolib$map.ensureCapacity(size);
        }
        l.reference2LongEntrySet().fastForEach(entry -> this.gtolib$map.addTo((Object)((AEKey)entry.getKey()), -entry.getLongValue()));
        this.gtolib$fuzzyUpdate = true;
    }

    @Overwrite(remap=false)
    public void add(AEKey key, long amount) {
        if (this.gtolib$map == null) {
            this.gtolib$map = new AEKeyMap();
        }
        this.gtolib$map.addTo((Object)key, amount);
        this.gtolib$fuzzyUpdate = true;
    }

    @Overwrite(remap=false)
    public void remove(AEKey key, long amount) {
        if (this.gtolib$map == null) {
            this.gtolib$map = new AEKeyMap();
        }
        this.gtolib$map.addTo((Object)key, -amount);
        this.gtolib$fuzzyUpdate = true;
    }

    @Overwrite(remap=false)
    public long remove(AEKey key) {
        if (this.gtolib$map == null) {
            return 0L;
        }
        this.gtolib$fuzzyUpdate = true;
        return this.gtolib$map.removeLong((Object)key);
    }

    @Overwrite(remap=false)
    public void set(AEKey key, long amount) {
        if (this.gtolib$map == null) {
            this.gtolib$map = new AEKeyMap();
        }
        this.gtolib$map.put((Object)key, amount);
        this.gtolib$fuzzyUpdate = true;
    }

    @Overwrite(remap=false)
    public long get(AEKey key) {
        if (this.gtolib$map == null) {
            return 0L;
        }
        return this.gtolib$map.getLong((Object)key);
    }

    @Overwrite(remap=false)
    public void reset() {
        if (this.gtolib$map == null) {
            return;
        }
        this.gtolib$map.reset();
        this.gtolib$fuzzyUpdate = true;
    }

    @Overwrite(remap=false)
    public void clear() {
        if (this.gtolib$map == null) {
            return;
        }
        this.gtolib$map.clear();
        this.gtolib$fuzzyUpdate = true;
    }

    @Overwrite(remap=false)
    public boolean isEmpty() {
        if (this.gtolib$map == null) {
            return true;
        }
        return this.gtolib$map.isEmpty();
    }

    @Overwrite(remap=false)
    public int size() {
        if (this.gtolib$map == null) {
            return 0;
        }
        return this.gtolib$map.size();
    }

    @Override
    @Overwrite(remap=false)
    public Iterator<Reference2LongMap.Entry<AEKey>> iterator() {
        if (this.gtolib$map == null) {
            return Collections.emptyIterator();
        }
        return this.gtolib$map.iterator();
    }

    @Overwrite(remap=false)
    @Nullable
    public AEKey getFirstKey() {
        Object2LongMap.Entry<AEKey> e = this.getFirstEntry();
        return e != null ? (AEKey)e.getKey() : null;
    }

    @Overwrite(remap=false)
    @Nullable
    public <T extends AEKey> T getFirstKey(Class<T> keyClass) {
        Object2LongMap.Entry<AEKey> e = this.getFirstEntry(keyClass);
        return (T)(e != null ? (AEKey)keyClass.cast(e.getKey()) : null);
    }

    @Overwrite(remap=false)
    @Nullable
    public Object2LongMap.Entry<AEKey> getFirstEntry() {
        if (this.gtolib$map == null) {
            return null;
        }
        Iterator iterator = this.gtolib$map.iterator();
        if (iterator.hasNext()) {
            Reference2LongMap.Entry e = (Reference2LongMap.Entry)iterator.next();
            return new IKeyCounter.Entry(e.getLongValue(), (AEKey)e.getKey());
        }
        return null;
    }

    @Overwrite(remap=false)
    @Nullable
    public <T extends AEKey> Object2LongMap.Entry<AEKey> getFirstEntry(Class<T> keyClass) {
        if (this.gtolib$map == null) {
            return null;
        }
        for (Reference2LongMap.Entry e : this.gtolib$map) {
            if (!keyClass.isInstance(e.getKey())) continue;
            return new IKeyCounter.Entry(e.getLongValue(), (AEKey)e.getKey());
        }
        return null;
    }

    @Overwrite(remap=false)
    public Set<AEKey> keySet() {
        if (this.gtolib$map == null) {
            return Collections.emptySet();
        }
        return this.gtolib$map.keySet();
    }

    public Reference2LongOpenHashMap<AEKey> gtolib$getMap() {
        return this.gtolib$map;
    }

    public boolean gtolib$contains(AEKey key) {
        if (this.gtolib$map == null) {
            return false;
        }
        return this.gtolib$map.containsKey((Object)key);
    }

    public void gtolib$ensureCapacity(int capacity) {
        if (this.gtolib$map == null) {
            this.gtolib$map = new AEKeyMap();
        }
        this.gtolib$map.ensureCapacity(capacity);
    }

    public void gtolib$addAll(int size, Consumer<AEKeyMap<AEKey>> consumer) {
        if (size < 1) {
            return;
        }
        if (this.gtolib$map == null) {
            this.gtolib$map = new AEKeyMap(size);
        }
        this.gtolib$map.ensureCapacity(size);
        consumer.accept(this.gtolib$map);
        this.gtolib$fuzzyUpdate = true;
    }
}

