/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.adastra;

import com.gtocore.client.hud.AdAstraHUD;
import com.gtocore.common.item.armor.SpaceArmorComponentItem;
import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.adastra.api.systems.PlanetData;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.client.screens.player.OverlayScreen;
import earth.terrarium.adastra.client.utils.ClientData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={OverlayScreen.class})
public abstract class AdAstraOverlayScreenMixin {
    @Inject(method={"render"}, at={@At(value="TAIL")}, remap=false)
    private static void hookRender(GuiGraphics graphics, float partialTick, CallbackInfo ci) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_5833_()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91066_.f_92063_) {
            return;
        }
        Font font = minecraft.f_91062_;
        PoseStack poseStack = graphics.m_280168_();
        ItemStack chestplate = player.m_150109_().m_36052_(2);
        Item item = chestplate.m_41720_();
        if (item instanceof SpaceArmorComponentItem) {
            SpaceArmorComponentItem spaceSuit = (SpaceArmorComponentItem)item;
            long amount = SpaceArmorComponentItem.getOxygenAmount((Entity)player);
            long capacity = spaceSuit.getFluidContainer(chestplate).getTankCapacity(0);
            double ratio = (double)amount / (double)capacity;
            int barHeight = (int)(ratio * 52.0);
            int x = AdAstraConfigClient.oxygenBarX;
            int y = AdAstraConfigClient.oxygenBarY;
            if (AdAstraHUD.gto$INSTANCE.isGto$containerScreenEnv()) {
                x += AdAstraHUD.gto$INSTANCE.getGto$pendingMovedX();
                y += AdAstraHUD.gto$INSTANCE.getGto$pendingMovedY();
            }
            float scale = AdAstraConfigClient.oxygenBarScale;
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, scale);
            graphics.m_280163_(OverlayScreen.OXYGEN_TANK_EMPTY, x, y, 0.0f, 0.0f, 62, 52, 62, 52);
            graphics.m_280163_(OverlayScreen.OXYGEN_TANK, x, y + 52 - barHeight, 0.0f, (float)(52 - barHeight), 62, barHeight, 62, 52);
            String text = String.format("%.1f%%", ratio * 100.0);
            int textWidth = font.m_92895_(text);
            int color = ratio <= 0.0 ? 14423100 : 0xFFFFFF;
            PlanetData localData = ClientData.getLocalData();
            if (localData != null && localData.oxygen()) {
                color = 0x55FF55;
            }
            graphics.m_280488_(font, text, (int)((float)x + (float)(62 - textWidth) / 2.0f), y + 52 + 3, color);
            poseStack.m_85849_();
        }
    }

    @Redirect(method={"render"}, at=@At(value="FIELD", target="Lnet/minecraft/client/Options;renderDebug:Z", opcode=180))
    private static boolean redirectRenderDebugField(Options options) {
        if (AdAstraHUD.gto$INSTANCE.isGto$containerScreenEnv()) {
            return false;
        }
        return options.f_92063_;
    }

    @Redirect(method={"render"}, at=@At(value="FIELD", target="Learth/terrarium/adastra/client/config/AdAstraConfigClient;oxygenBarX:I", opcode=178, remap=false), remap=false)
    private static int redirectOxygenBarX() {
        if (AdAstraHUD.gto$INSTANCE.isGto$containerScreenEnv()) {
            return AdAstraConfigClient.oxygenBarX + AdAstraHUD.gto$INSTANCE.getGto$pendingMovedX();
        }
        return AdAstraConfigClient.oxygenBarX;
    }

    @Redirect(method={"render"}, at=@At(value="FIELD", target="Learth/terrarium/adastra/client/config/AdAstraConfigClient;oxygenBarY:I", opcode=178, remap=false), remap=false)
    private static int redirectOxygenBarY() {
        if (AdAstraHUD.gto$INSTANCE.isGto$containerScreenEnv()) {
            return AdAstraConfigClient.oxygenBarY + AdAstraHUD.gto$INSTANCE.getGto$pendingMovedY();
        }
        return AdAstraConfigClient.oxygenBarY;
    }
}

