/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.jade.provider;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gtocore.common.saved.WirelessSavedData;
import com.gtocore.integration.ae.wireless.WirelessGrid;
import com.gtocore.integration.ae.wireless.WirelessMachine;
import com.gtolib.GTOCore;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public final class WirelessGridProvider
extends CapabilityBlockProvider<WirelessMachine> {
    public WirelessGridProvider() {
        super(GTOCore.id((String)"wireless_grid_provider"));
    }

    @Nullable
    protected WirelessMachine getCapability(Level level, BlockPos pos, BlockEntity blockEntity, @Nullable Direction side) {
        MetaMachine machine = MetaMachine.getMachine((BlockEntity)blockEntity);
        if (machine instanceof WirelessMachine) {
            WirelessMachine wm = (WirelessMachine)machine;
            return wm;
        }
        return null;
    }

    protected void write(CompoundTag data, WirelessMachine capability) {
        if (capability != null) {
            String id = capability.getWirelessMachinePersisted0().getGridConnectedName();
            data.m_128359_("grid", id);
            String nick = id;
            try {
                WirelessGrid grid = WirelessSavedData.Companion.findGridByName(id);
                if (grid != null) {
                    grid.getNickname();
                    if (!grid.getNickname().isBlank()) {
                        nick = grid.getNickname();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            data.m_128359_("grid_nick", nick);
        }
    }

    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        String nick = capData.m_128461_("grid_nick");
        if (nick.isBlank()) {
            nick = capData.m_128461_("grid");
        }
        if (nick.isBlank()) {
            return;
        }
        tooltip.add((Component)Component.m_237110_((String)"gtocore.integration.ae.WirelessMachine.currentlyConnectedTo", (Object[])new Object[]{nick}));
    }
}

