/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.SimpleGeneratorMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtolib.api.machine.feature.multiblock.IParallelMachine;
import com.gtolib.api.machine.impl.part.ParallelHatchPartMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public final class ParallelProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        long parallel = blockAccessor.getServerData().m_128454_("parallel");
        if (parallel > 1L) {
            long batchParallel = blockAccessor.getServerData().m_128454_("batch_parallel");
            MutableComponent parallels = Component.m_237113_((String)FormattingUtil.formatNumbers((long)parallel)).m_130940_(ChatFormatting.DARK_PURPLE);
            Object key = "gtceu.multiblock.parallel";
            if (blockAccessor.getServerData().m_128471_("exact")) {
                key = (String)key + ".exact";
            }
            iTooltip.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{parallels}).m_7220_((Component)(batchParallel > 1L ? Component.m_237110_((String)"gtceu.multiblock.batch_parallel_multiplier", (Object[])new Object[]{Component.m_237113_((String)"\u00d7%s".formatted(batchParallel)).m_130940_(ChatFormatting.DARK_BLUE)}) : Component.m_237119_())));
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof MetaMachineBlockEntity) {
            MultiblockMachineDefinition multiblockMachineDefinition;
            MetaMachineBlockEntity blockEntity2 = (MetaMachineBlockEntity)blockEntity;
            MetaMachine machine = blockEntity2.getMetaMachine();
            if (machine instanceof ParallelHatchPartMachine) {
                ParallelHatchPartMachine parallelHatchPartMachine = (ParallelHatchPartMachine)machine;
                compoundTag.m_128356_("parallel", parallelHatchPartMachine.getCurrentParallelLong());
                return;
            }
            if (machine instanceof SimpleGeneratorMachine) {
                return;
            }
            MachineDefinition machineDefinition = machine.getDefinition();
            if (machineDefinition instanceof MultiblockMachineDefinition && (multiblockMachineDefinition = (MultiblockMachineDefinition)machineDefinition).isGenerator()) {
                return;
            }
            long[] parallels = ParallelProvider.getRecipeParallel(machine);
            long parallel = parallels[0];
            long batchParallel = parallels[1];
            if (parallel > 0L) {
                compoundTag.m_128379_("exact", true);
            }
            long originParallel = 1L;
            if (machine instanceof IWorkableMultiController) {
                IWorkableMultiController controller = (IWorkableMultiController)machine;
                if (controller instanceof IParallelMachine) {
                    IParallelMachine parallelHatch = (IParallelMachine)controller;
                    originParallel = parallelHatch.getParallel();
                } else {
                    IParallelHatch parallelHatch = controller.getParallelHatch();
                    if (parallelHatch != null) {
                        originParallel = ((ParallelHatchPartMachine)parallelHatch).getCurrentParallelLong();
                    }
                }
            }
            if (originParallel < 1L) {
                originParallel = 1L;
            }
            if (parallel > 1L) {
                compoundTag.m_128356_("parallel", parallel);
            } else if (originParallel > 1L) {
                compoundTag.m_128356_("parallel", originParallel);
            }
            if (batchParallel > 1L) {
                compoundTag.m_128356_("batch_parallel", batchParallel);
            } else if (parallel / originParallel > 1L) {
                compoundTag.m_128356_("batch_parallel", parallel / originParallel);
            }
        }
    }

    private static long[] getRecipeParallel(MetaMachine machine) {
        GTRecipe gTRecipe;
        IRecipeLogicMachine rlm;
        long[] parallel = new long[]{0L, 0L};
        if (machine instanceof IRecipeLogicMachine && (rlm = (IRecipeLogicMachine)machine).getRecipeLogic().isActive() && (gTRecipe = rlm.getRecipeLogic().getLastRecipe()) instanceof Recipe) {
            Recipe recipe = (Recipe)gTRecipe;
            parallel[0] = RecipeHelper.getParallel((GTRecipe)recipe);
            parallel[1] = recipe.batchParallels;
        }
        return parallel;
    }

    public ResourceLocation getUid() {
        return GTCEu.id((String)"parallel_info");
    }
}

