/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.emi;

import com.gtocore.common.machine.multiblock.part.ae.MEPatternBufferPartMachine;
import com.gtocore.common.machine.multiblock.part.ae.MEPatternBufferPartMachineKt;
import com.gtocore.integration.emi.GTEMIRecipe;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIContainer;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.world.inventory.Slot;

final class GTEmiRecipeHandler
implements StandardRecipeHandler<ModularUIContainer> {
    static final List<CanCraftOverride> canCraftOverrides = new ArrayList<CanCraftOverride>();

    GTEmiRecipeHandler() {
    }

    static void registerCanCraftOverride(BiPredicate<EmiRecipe, EmiCraftContext<ModularUIContainer>> canCraft, BiPredicate<EmiRecipe, EmiCraftContext<ModularUIContainer>> craft) {
        canCraftOverrides.add(new CanCraftOverride(canCraft, craft));
    }

    public List<Slot> getInputSources(ModularUIContainer handler) {
        return handler.getModularUI().getSlotMap().values().stream().filter(e -> e.getIngredientIO() == IngredientIO.INPUT || e.isPlayerContainer || e.isPlayerHotBar).map(SlotWidget::getHandler).toList();
    }

    public List<Slot> getCraftingSlots(ModularUIContainer handler) {
        return handler.getModularUI().getSlotMap().values().stream().filter(e -> e.getIngredientIO() == IngredientIO.INPUT).map(SlotWidget::getHandler).toList();
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe instanceof GTEMIRecipe;
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<ModularUIContainer> context) {
        for (CanCraftOverride override : canCraftOverrides) {
            if (!override.canCraft.test(recipe, context)) continue;
            return true;
        }
        return super.canCraft(recipe, context);
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<ModularUIContainer> context) {
        for (CanCraftOverride override : canCraftOverrides) {
            if (!override.canCraft.test(recipe, context)) continue;
            return override.craft.test(recipe, context);
        }
        return super.craft(recipe, context);
    }

    static {
        GTEmiRecipeHandler.registerCanCraftOverride((recipe, context) -> ((ModularUIContainer)context.getScreenHandler()).getModularUI().holder instanceof MEPatternBufferPartMachine, (recipe, context) -> {
            MEPatternBufferPartMachine patternBuffer;
            IUIHolder patt0$temp = ((ModularUIContainer)context.getScreenHandler()).getModularUI().holder;
            if (patt0$temp instanceof MEPatternBufferPartMachine && (patternBuffer = (MEPatternBufferPartMachine)patt0$temp) instanceof MEPatternBufferPartMachineKt && recipe.getId() != null) {
                int currentSlot = patternBuffer.getConfiguratorField().get();
                MEPatternBufferPartMachineKt.Companion.getSET_ID_CHANNEL().send(buf -> {
                    buf.m_130064_(patternBuffer.getPos());
                    buf.m_130130_(currentSlot);
                    buf.m_130085_(recipe.getId());
                }, new Object[0]);
                return true;
            }
            return false;
        });
    }

    public record CanCraftOverride(BiPredicate<EmiRecipe, EmiCraftContext<ModularUIContainer>> canCraft, BiPredicate<EmiRecipe, EmiCraftContext<ModularUIContainer>> craft) {
    }
}

