/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.emi;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.integration.modules.emi.AbstractRecipeHandler;
import appeng.integration.modules.emi.EmiStackHelper;
import appeng.integration.modules.jeirei.EncodingHelper;
import appeng.integration.modules.jeirei.TransferHelper;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.items.PatternEncodingTermMenu;
import com.gtocore.integration.emi.GTEMIRecipe;
import com.gtocore.integration.emi.GTEmiEncodingHelper;
import com.gtocore.integration.emi.multipage.MultiblockInfoEmiRecipe;
import com.gtolib.api.ae2.IPatterEncodingTermMenu;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.utils.ClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.recipe.EmiCookingRecipe;
import dev.emi.emi.recipe.EmiStonecuttingRecipe;
import dev.emi.emi.screen.RecipeScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Recipe;
import vazkii.botania.client.integration.emi.BotaniaEmiRecipe;

final class GTAe2PatternTerminalHandler<T extends PatternEncodingTermMenu>
implements EmiRecipeHandler<T> {
    GTAe2PatternTerminalHandler() {
    }

    private List<Slot> getInputSources(T handler) {
        return ((PatternEncodingTermMenu)handler).f_38839_;
    }

    public EmiPlayerInventory getInventory(AbstractContainerScreen<T> screen) {
        return new EmiPlayerInventory(this.getInputSources((PatternEncodingTermMenu)screen.m_6262_()).stream().map(Slot::m_7993_).map(EmiStack::of).toList());
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe instanceof GTEMIRecipe || recipe instanceof MultiblockInfoEmiRecipe || recipe instanceof EmiCookingRecipe || GTAe2PatternTerminalHandler.isCrafting(recipe) || recipe instanceof BotaniaEmiRecipe;
    }

    private Set<AEKey> getCraftableKeys(T menu) {
        return menu.getClientRepo() != null ? menu.getClientRepo().getAllEntries().stream().filter(GridInventoryEntry::isCraftable).map(GridInventoryEntry::getWhat).collect(Collectors.toSet()) : Set.of();
    }

    public List<ClientTooltipComponent> getTooltip(EmiRecipe recipe, EmiCraftContext<T> context) {
        Set<AEKey> craftableKeys = this.getCraftableKeys((PatternEncodingTermMenu)context.getScreenHandler());
        boolean anyCraftable = recipe.getInputs().stream().anyMatch(ing -> GTAe2PatternTerminalHandler.isCraftable(craftableKeys, ing));
        List gatheredTooltip = anyCraftable ? TransferHelper.createEncodingTooltip((boolean)true) : new ArrayList();
        gatheredTooltip.addAll(GTAe2PatternTerminalHandler.getCatalystTooltip(recipe));
        return gatheredTooltip.stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).toList();
    }

    public void render(EmiRecipe recipe, EmiCraftContext<T> context, List<Widget> widgets, GuiGraphics draw) {
        for (Widget widget2 : widgets) {
            SlotWidget slot;
            if (!(widget2 instanceof SlotWidget) || !AbstractRecipeHandler.isInputSlot((SlotWidget)(slot = (SlotWidget)widget2)) || !GTAe2PatternTerminalHandler.isCraftable(this.getCraftableKeys((PatternEncodingTermMenu)context.getScreenHandler()), slot.getStack())) continue;
            GTAe2PatternTerminalHandler.renderSlotOverlay(draw, slot);
        }
    }

    private static void renderSlotOverlay(GuiGraphics guiGraphics, SlotWidget slot) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 400.0f);
        Bounds bounds = AbstractRecipeHandler.getInnerBounds((SlotWidget)slot);
        guiGraphics.m_280509_(bounds.x(), bounds.y(), bounds.right(), bounds.bottom(), 0x400000FF);
        poseStack.m_85849_();
    }

    private static List<Component> getCatalystTooltip(EmiRecipe emiRecipe) {
        if (emiRecipe instanceof MultiblockInfoEmiRecipe) {
            MultiblockInfoEmiRecipe recipe = (MultiblockInfoEmiRecipe)emiRecipe;
            if (recipe.definition.getSubPatternFactory() != null) {
                return List.of(Component.m_237115_((String)"gtocore.ae.appeng.me2in1.emi.multiblock.sub").m_130940_(ChatFormatting.GREEN), Component.m_237115_((String)"gtocore.ae.appeng.me2in1.emi.multiblock.sub.all").m_130940_(ChatFormatting.DARK_GREEN));
            }
            return Collections.emptyList();
        }
        return List.of(Component.m_237115_((String)"gtocore.ae.appeng.me2in1.emi.catalyst").m_130940_(ChatFormatting.AQUA), Component.m_237115_((String)"gtocore.ae.appeng.me2in1.emi.catalyst.fill").m_130940_(ChatFormatting.GREEN), Component.m_237115_((String)"gtocore.ae.appeng.me2in1.emi.catalyst.virtual").m_130940_(ChatFormatting.DARK_GREEN));
    }

    private static boolean isCraftable(Set<AEKey> craftableKeys, EmiIngredient ingredient) {
        return ingredient.getEmiStacks().stream().anyMatch(emiIngredient -> {
            GenericStack stack = EmiStackHelper.toGenericStack((EmiStack)emiIngredient);
            return stack != null && craftableKeys.contains(stack.what());
        });
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
        return true;
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        PatternEncodingTermMenu menu = (PatternEncodingTermMenu)context.getScreenHandler();
        ((IPatterEncodingTermMenu)menu).gtolib$addUUID(ClientUtil.getUUID());
        if (GTAe2PatternTerminalHandler.isCrafting(recipe)) {
            EncodingHelper.encodeCraftingRecipe((PatternEncodingTermMenu)menu, (Recipe)recipe.getBackingRecipe(), GTEmiEncodingHelper.ofInputs(recipe), i -> true);
        } else {
            GTEMIRecipe gtemiRecipe;
            if (recipe instanceof GTEMIRecipe && RecipeBuilder.RECIPE_MAP.containsKey((gtemiRecipe = (GTEMIRecipe)recipe).getId())) {
                ((IPatterEncodingTermMenu)menu).gtolib$addRecipe(gtemiRecipe.getId().toString());
            } else {
                ((IPatterEncodingTermMenu)menu).gtolib$addRecipe("");
            }
            EncodingHelper.encodeProcessingRecipe((PatternEncodingTermMenu)menu, GTEmiEncodingHelper.ofInputs(recipe), GTAe2PatternTerminalHandler.ofOutputs(recipe));
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof RecipeScreen) {
            RecipeScreen e = (RecipeScreen)screen;
            e.m_7379_();
        }
        return true;
    }

    private static boolean isCrafting(EmiRecipe recipe) {
        return recipe instanceof EmiStonecuttingRecipe;
    }

    private static List<GenericStack> ofOutputs(EmiRecipe emiRecipe) {
        return emiRecipe.getOutputs().stream().flatMap(slot -> GTEmiEncodingHelper.intoGenericStack((EmiIngredient)slot).stream().limit(1L)).toList();
    }
}

