/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.ae.wireless;

import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.feature.IGridConnectedMachine;
import com.gregtechceu.gtceu.utils.TaskHandler;
import com.gtocore.common.saved.STATUS;
import com.gtocore.common.saved.WirelessSavedData;
import com.gtocore.integration.ae.wireless.WirelessGrid;
import com.gtocore.integration.ae.wireless.WirelessMachinePersisted;
import com.gtocore.integration.ae.wireless.WirelessMachineRunTime;
import com.gtocore.integration.ae.wireless.WirelessMachineUIKt;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.capability.ISync;
import com.gtolib.api.player.IEnhancedPlayer;
import com.hepdd.gtmthings.api.capability.IBindable;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@DataGeneratorScanned
public interface WirelessMachine
extends IGridConnectedMachine,
ISync,
IBindable {
    @RegisterLanguage(cn="\u7f51\u7edc\u8282\u70b9\u9009\u62e9", en="Grid Node Selector")
    public static final String gridNodeSelector = "gtocore.integration.ae.WirelessMachine.gridNodeSelector";
    @RegisterLanguage(cn="\u7f51\u7edc\u8282\u70b9\u5217\u8868", en="Grid Node List")
    public static final String gridNodeList = "gtocore.integration.ae.WirelessMachine.gridNodeList";
    @RegisterLanguage(cn="\u7ed1\u5b9a\u5230\u73a9\u5bb6 : %s", en="Bind to player: %s")
    public static final String player = "gtocore.integration.ae.WirelessMachine.player";
    @RegisterLanguage(cn="\u5f53\u524d\u8fde\u63a5\u5230 : %s", en="Currently connected: %s")
    public static final String currentlyConnectedTo = "gtocore.integration.ae.WirelessMachine.currentlyConnectedTo";
    @RegisterLanguage(cn="\u521b\u5efa\u7f51\u7edc", en="Create Grid")
    public static final String createGrid = "gtocore.integration.ae.WirelessMachine.createGrid";
    @RegisterLanguage(cn="\u5168\u7403\u53ef\u7528\u65e0\u7ebf\u7f51\u7edc : %s / %s", en="Global available wireless grids: %s / %s")
    public static final String globalWirelessGrid = "gtocore.integration.ae.WirelessMachine.globalWirelessGrid";
    @RegisterLanguage(cn="\u5220\u9664", en="Remove")
    public static final String removeGrid = "gtocore.integration.ae.WirelessMachine.removeGrid";
    @RegisterLanguage(cn="\u4f60\u7684\u65e0\u7ebf\u7f51\u7edc : ", en="Your wireless grids: ")
    public static final String yourWirelessGrid = "gtocore.integration.ae.WirelessMachine.yourWirelessGrid";
    @RegisterLanguage(cn="\u67e5\u627e\u673a\u5668\uff0c\u673a\u5668\u5c06\u4f1a\u9ad8\u4eae", en="Find Machine, machine will be highlighted")
    public static final String findMachine = "gtocore.integration.ae.WirelessMachine.findMachine";
    @RegisterLanguage(cn="\u6b64\u673a\u5668\u88ab\u7981\u6b62\u8fde\u63a5ME\u65e0\u7ebf\u7f51\u7edc", en="This machine is banned from connecting to ME wireless network")
    public static final String banned = "gtocore.integration.ae.WirelessMachine.banned";
    @RegisterLanguage(cn="\u65ad\u5f00\u65e0\u7ebf\u7f51\u7edc", en="Leave Wireless Grid")
    public static final String leave = "gtocore.integration.ae.WirelessMachine.leave";
    @RegisterLanguage(cn="\u4fee\u6539\u7f51\u7edc\u6635\u79f0", en="Rename Grid")
    public static final String renameGrid = "gtocore.integration.ae.WirelessMachine.renameGrid";

    public WirelessMachinePersisted getWirelessMachinePersisted0();

    public void setWirelessMachinePersisted0(WirelessMachinePersisted var1);

    public WirelessMachineRunTime getWirelessMachineRunTime0();

    public void setWirelessMachineRunTime0(WirelessMachineRunTime var1);

    default public UUID getRequesterUUID() {
        UUID owner = this.self().getOwnerUUID();
        return owner != null ? owner : this.getUUID();
    }

    default public void addedToGrid(String gridName) {
    }

    default public void removedFromGrid(String gridName) {
    }

    default public boolean allowThisMachineConnectToWirelessGrid() {
        return true;
    }

    default public void onWirelessMachineLoad() {
        if (this.self().isRemote()) {
            return;
        }
        this.getWirelessMachineRunTime0().setInitTickableSubscription(TaskHandler.enqueueServerTick((ServerLevel)((ServerLevel)this.getLevel()), () -> {
            if (this.getMainNode().getNode() != null) {
                if (!this.getWirelessMachinePersisted0().isBeSet() && this.getWirelessMachineRunTime0().isShouldAutoConnect()) {
                    for (WirelessGrid grid : WirelessSavedData.Companion.accessibleGridsFor(this.self().getOwnerUUID() != null ? this.self().getOwnerUUID() : this.getUUID())) {
                        if (!grid.isDefault()) continue;
                        this.joinGrid(grid.getName());
                        break;
                    }
                    this.getWirelessMachinePersisted0().setBeSet(true);
                } else if (!this.getWirelessMachinePersisted0().getGridConnectedName().isEmpty()) {
                    this.linkGrid(this.getWirelessMachinePersisted0().getGridConnectedName());
                }
                this.getWirelessMachineRunTime0().getInitTickableSubscription().unsubscribe();
            }
        }, (int)20, (int)40));
    }

    default public void onWirelessMachineUnLoad() {
        if (this.self().isRemote()) {
            return;
        }
        this.getWirelessMachineRunTime0().getInitTickableSubscription().unsubscribe();
        this.unLinkGrid();
    }

    default public void onWirelessMachineClientTick() {
    }

    default public void onWirelessMachinePlaced(LivingEntity player, ItemStack stack) {
        if (player != null) {
            this.self().setOwnerUUID(player.m_20148_());
            if (player instanceof Player && IEnhancedPlayer.of((Player)((Player)player)).getPlayerData().shiftState) {
                this.getWirelessMachineRunTime0().setShouldAutoConnect(true);
            }
        }
        this.self().requestSync();
    }

    default public UUID getUUID() {
        UUID owner = this.self().getOwnerUUID();
        return owner != null ? owner : UUID.randomUUID();
    }

    default public void refreshCachesOnServer() {
        if (this.self().isRemote()) {
            return;
        }
        this.getWirelessMachineRunTime0().getGridCache().setAndSyncToClient(WirelessSavedData.Companion.getINSTANCE().getGridPool());
        this.getWirelessMachineRunTime0().getGridAccessibleCache().setAndSyncToClient(WirelessSavedData.Companion.accessibleGridsFor(this.getRequesterUUID()));
    }

    default public WirelessMachineRunTime createWirelessMachineRunTime() {
        return new WirelessMachineRunTime(this);
    }

    default public WirelessMachinePersisted createWirelessMachinePersisted() {
        return new WirelessMachinePersisted(this);
    }

    default public void linkGrid(String gridName) {
        if (!this.allowThisMachineConnectToWirelessGrid()) {
            return;
        }
        if (this.self().isRemote()) {
            return;
        }
        STATUS status = WirelessSavedData.Companion.joinToGrid(gridName, this, this.getRequesterUUID());
        switch (status) {
            case SUCCESS: 
            case ALREADY_JOINT: {
                this.getWirelessMachineRunTime0().setGridConnected(WirelessSavedData.Companion.findGridByName(gridName));
                break;
            }
            case NOT_FOUND_GRID: {
                this.getWirelessMachineRunTime0().setGridConnected(null);
                this.getWirelessMachinePersisted0().setGridConnectedName("");
                break;
            }
            case NOT_PERMISSION: {
                this.getWirelessMachineRunTime0().setGridConnected(null);
            }
        }
    }

    default public void joinGrid(String gridName) {
        if (!this.allowThisMachineConnectToWirelessGrid()) {
            return;
        }
        if (this.self().isRemote()) {
            return;
        }
        this.getWirelessMachinePersisted0().setGridConnectedName(gridName);
        this.linkGrid(gridName);
        this.refreshCachesOnServer();
    }

    default public void unLinkGrid() {
        if (this.self().isRemote()) {
            return;
        }
        WirelessSavedData.Companion.leaveGrid(this);
    }

    default public void leaveGrid() {
        if (this.self().isRemote()) {
            return;
        }
        this.unLinkGrid();
        this.getWirelessMachinePersisted0().setGridConnectedName("");
        this.refreshCachesOnServer();
    }

    default public IFancyUIProvider getSetupFancyUIProvider() {
        return WirelessMachineUIKt.getSetupFancyUIProvider(this);
    }

    public MetaMachine self();
}

