/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.eio_travel.implementations;

import appeng.blockentity.AEBaseBlockEntity;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.common.machine.multiblock.part.ae.MEPatternPartMachineKt;
import com.gtocore.eio_travel.AbstractTravelTarget;
import com.gtolib.GTOCore;
import com.gtolib.utils.ServerUtils;
import com.lowdragmc.lowdraglib.LDLib;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class PatternTravelTarget
extends AbstractTravelTarget {
    public static final ResourceLocation SERIALIZED_NAME = GTOCore.id((String)"pattern_node");
    @Nullable
    private final PatternProviderLogicHost patternProviderLogicHost;
    @Nullable
    private final MEPatternPartMachineKt<?> patternBufferHost;
    private final boolean isClient;
    @Nullable
    private final ResourceKey<Level> dimension;
    int hashCache = 0;

    public PatternTravelTarget(PatternProviderLogicHost host) {
        super(host.getBlockEntity().m_58899_(), PatternTravelTarget.getPlayerCustomName(host), PatternTravelTarget.getAdjacentMachineIcon(), host.isVisibleInTerminal());
        this.patternProviderLogicHost = host;
        this.patternBufferHost = null;
        this.isClient = !(host.getBlockEntity().m_58904_() instanceof ServerLevel);
        this.dimension = Optional.ofNullable(host.getBlockEntity().m_58904_()).map(Level::m_46472_).orElse(null);
    }

    public PatternTravelTarget(MEPatternPartMachineKt<?> host) {
        super(host.getHolder().m_58899_(), PatternTravelTarget.getPlayerCustomName(host), PatternTravelTarget.getAdjacentMachineIcon(), host.getShowInTravelNetwork());
        this.patternBufferHost = host;
        this.patternProviderLogicHost = null;
        this.isClient = !(host.getHolder().m_58904_() instanceof ServerLevel);
        this.dimension = Optional.ofNullable(host.getHolder().m_58904_()).map(Level::m_46472_).orElse(null);
    }

    private PatternTravelTarget(BlockPos pos, String name, Item icon, boolean visible) {
        super(pos, name, icon, visible);
        this.patternProviderLogicHost = null;
        this.patternBufferHost = null;
        this.isClient = true;
        this.dimension = GTUtil.getClientLevel().m_46472_();
    }

    private static String getPlayerCustomName(Object host) {
        if (host instanceof PatternProviderLogicHost) {
            AEBaseBlockEntity aeBe;
            Component customNameComponent;
            PatternProviderLogicHost logicHost = (PatternProviderLogicHost)host;
            BlockEntity be = logicHost.getBlockEntity();
            if (be instanceof AEBaseBlockEntity && (customNameComponent = (aeBe = (AEBaseBlockEntity)be).m_7770_()) != null) {
                return customNameComponent.getString();
            }
        } else if (host instanceof MEPatternPartMachineKt) {
            MEPatternPartMachineKt partHost = (MEPatternPartMachineKt)host;
            return partHost.getCustomName();
        }
        return "";
    }

    private static Item getAdjacentMachineIcon() {
        return Items.f_41852_;
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PatternTravelTarget that = (PatternTravelTarget)o;
        return this.hashCode() == that.hashCode() && Objects.equals(this.patternProviderLogicHost, that.patternProviderLogicHost) && Objects.equals(this.patternBufferHost, that.patternBufferHost);
    }

    @Override
    public int hashCode() {
        if (this.hashCache != 0) {
            return this.hashCache;
        }
        this.hashCache = Objects.hash(this.getPos().hashCode(), this.patternProviderLogicHost, this.patternBufferHost);
        return this.hashCache;
    }

    @Override
    public String getName() {
        if (this.isClient || this.dimension != null && !Objects.requireNonNull(ServerUtils.getServer().m_129880_(this.dimension)).m_46749_(this.getPos())) {
            return super.getName();
        }
        return this.patternBufferHost != null ? PatternTravelTarget.getPlayerCustomName(this.patternBufferHost) : PatternTravelTarget.getPlayerCustomName(this.patternProviderLogicHost);
    }

    @Override
    public ResourceLocation getSerializationName() {
        return SERIALIZED_NAME;
    }

    @Override
    public BlockPos getPos() {
        if (this.isClient) {
            return super.getPos();
        }
        return this.patternBufferHost != null ? this.patternBufferHost.getHolder().m_58899_() : this.patternProviderLogicHost.getBlockEntity().m_58899_();
    }

    @Override
    public Item getIcon() {
        if (this.isClient || this.dimension != null && !Objects.requireNonNull(ServerUtils.getServer().m_129880_(this.dimension)).m_46749_(this.getPos())) {
            return super.getIcon();
        }
        return PatternTravelTarget.getAdjacentMachineIcon();
    }

    @Override
    public boolean getVisibility() {
        if (this.isClient || this.dimension != null && !Objects.requireNonNull(ServerUtils.getServer().m_129880_(this.dimension)).m_46749_(this.getPos())) {
            return super.getVisibility();
        }
        return this.patternBufferHost != null ? this.patternBufferHost.getShowInTravelNetwork() : this.patternProviderLogicHost.isVisibleInTerminal();
    }

    @Nullable
    public static PatternTravelTarget loadClientTarget(CompoundTag tag) {
        if (!LDLib.isRemote()) {
            return null;
        }
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BlockPos"));
        String name = tag.m_128461_("AnchorName");
        String iconName = tag.m_128461_("AnchorIcon");
        Item icon = iconName.equals("") ? Items.f_41852_ : (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)iconName));
        boolean visible = tag.m_128471_("AnchorVisibility");
        return new PatternTravelTarget(pos, name, icon, visible);
    }
}

