/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.eio_travel.client;

import com.gtocore.eio_travel.api.TravelHandler;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TravelParticleHandler {
    private static int tick = 0;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent e) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (e.phase == TickEvent.Phase.END && player != null && ++tick % 3 == 0 && player.m_20096_() && player.m_6144_() && TravelHandler.canItemTeleport((Player)player)) {
            TravelHandler.teleportPosition(player.m_9236_(), (Player)player).ifPresent(TravelParticleHandler::addTravelParticle);
        }
    }

    private static void addTravelParticle(Vec3 pos) {
        int time = tick / 3 % 20;
        float x = Mth.m_14031_((float)((float)((double)time * Math.PI) / 10.0f));
        float z = Mth.m_14089_((float)((float)((double)time * Math.PI) / 10.0f));
        @Nullable Particle particle = Minecraft.m_91087_().f_91060_.m_109804_((ParticleOptions)ParticleTypes.f_123767_, false, true, pos.m_7096_() + (double)x, pos.m_7098_() + 0.4, pos.m_7094_() + (double)z, 0.0, 0.0, 0.0);
        if (particle != null) {
            particle.m_107257_(30);
            Triple<Float, Float, Float> color = TravelParticleHandler.getTravelParticleColor();
            particle.f_107226_ = 0.0f;
            particle.m_107253_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue());
        }
    }

    private static Triple<Float, Float, Float> getTravelParticleColor() {
        if (Calendar.getInstance().get(2) == 5) {
            int halfTick = tick / 3 % 10;
            return switch (halfTick) {
                case 0 -> Triple.of((Object)Float.valueOf(0.89411765f), (Object)Float.valueOf(0.011764706f), (Object)Float.valueOf(0.011764706f));
                case 1 -> Triple.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.54901963f), (Object)Float.valueOf(0.0f));
                case 2 -> Triple.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.92941177f), (Object)Float.valueOf(0.0f));
                case 3 -> Triple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.5019608f), (Object)Float.valueOf(0.14901961f));
                case 4 -> Triple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.3019608f), (Object)Float.valueOf(1.0f));
                case 5 -> Triple.of((Object)Float.valueOf(0.45882353f), (Object)Float.valueOf(0.02745098f), (Object)Float.valueOf(0.5294118f));
                default -> Triple.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
            };
        }
        return Triple.of((Object)Float.valueOf(0.45882353f), (Object)Float.valueOf(0.02745098f), (Object)Float.valueOf(0.5294118f));
    }
}

