/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.eio_travel.api;

import com.gtocore.eio_travel.ITravelTarget;
import com.gtocore.eio_travel.api.TravelEntry;
import com.gtocore.eio_travel.client.TravelRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TravelRegistry {
    private static final Map<ResourceLocation, TravelEntry<?>> REGISTRY = new HashMap();

    public static <T extends ITravelTarget> void addTravelEntry(ResourceLocation serializationName, Function<CompoundTag, T> constructor, Supplier<Lazy<TravelRenderer<T>>> renderer) {
        REGISTRY.put(serializationName, new TravelEntry<T>(serializationName, constructor, renderer));
    }

    public static <T extends ITravelTarget> void addTravelEntry(TravelEntry<?> travelEntry) {
        REGISTRY.put(travelEntry.serializationName(), travelEntry);
    }

    public static <T extends ITravelTarget> TravelRenderer<T> getRenderer(T entry) {
        return (TravelRenderer)REGISTRY.get(entry.getSerializationName()).renderer().get().get();
    }

    public static Optional<ITravelTarget> deserialize(CompoundTag nbt) {
        return Optional.ofNullable(REGISTRY.get(ResourceLocation.m_135820_((String)nbt.m_128461_("name")))).map(entry -> (ITravelTarget)entry.constructor().apply(nbt.m_128469_("data")));
    }

    public static boolean isRegistered(ITravelTarget target) {
        return REGISTRY.containsKey(target.getSerializationName());
    }

    public static CompoundTag serialize(ITravelTarget travelData) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("name", travelData.getSerializationName().toString());
        nbt.m_128365_("data", (Tag)travelData.save());
        return nbt;
    }
}

