/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.eio_travel.api;

import appeng.helpers.patternprovider.PatternProviderLogicHost;
import com.gtocore.api.travel.TravelMode;
import com.gtocore.common.machine.multiblock.part.ae.MEPatternPartMachineKt;
import com.gtocore.config.GTOConfig;
import com.gtocore.eio_travel.ITravelTarget;
import com.gtocore.eio_travel.api.TravelHandler;
import com.gtocore.eio_travel.api.TravelSavedData;
import com.gtocore.eio_travel.implementations.PatternTravelTarget;
import com.gtocore.eio_travel.network.TravelNetworks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ITravelHandlerHook {
    public static final String MODE_TAG = "TravelMode";
    public static final String FILTER_BLOCK_TAG = "FilterBlock";

    public static TravelMode getTravelMode(Player player) {
        CompoundTag tag;
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        Object object = mainHand.m_41782_() ? mainHand.m_41783_() : (tag = offHand.m_41782_() ? offHand.m_41783_() : null);
        if (tag != null && tag.m_128441_(MODE_TAG)) {
            return TravelMode.fromString(tag.m_128461_(MODE_TAG));
        }
        return TravelMode.ALL;
    }

    public static Stream<ITravelTarget> filterTargets(Player player, Stream<ITravelTarget> targets) {
        TravelMode mode = ITravelHandlerHook.getTravelMode(player);
        return switch (mode) {
            case TravelMode.ONE_PER_CHUNK -> ITravelHandlerHook.filterOnePerChunk(targets);
            case TravelMode.FILTER_BY_BLOCK -> ITravelHandlerHook.filterByBlock(player, targets);
            default -> targets;
        };
    }

    public static Stream<ITravelTarget> filterOnePerChunk(Stream<ITravelTarget> targets) {
        HashMap chunkMap = new HashMap();
        targets.forEach(target -> {
            BlockPos pos = target.getPos();
            ChunkPos chunkPos = new ChunkPos(pos);
            chunkMap.merge(chunkPos, target, (existing, newTarget) -> {
                double distExisting = Math.abs(existing.getPos().m_123342_() - pos.m_123342_());
                double distNew = Math.abs(newTarget.getPos().m_123342_() - pos.m_123342_());
                return distNew < distExisting ? newTarget : existing;
            });
        });
        return chunkMap.values().stream();
    }

    public static Stream<ITravelTarget> filterByBlock(Player player, Stream<ITravelTarget> targets) {
        ItemStack stack = player.m_21205_().m_41619_() ? player.m_21206_() : player.m_21205_();
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(FILTER_BLOCK_TAG) || tag.m_128461_(FILTER_BLOCK_TAG).isEmpty()) {
            return targets;
        }
        String filterBlock = tag.m_128461_(FILTER_BLOCK_TAG);
        Level level = player.m_9236_();
        List<ITravelTarget> targetList = targets.toList();
        HashSet<String> existingBlockTypes = new HashSet<String>();
        for (ITravelTarget target2 : targetList) {
            BlockPos pos = target2.getPos();
            BlockState blockState = level.m_8055_(pos);
            String blockId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_())).toString();
            existingBlockTypes.add(blockId);
        }
        if (!existingBlockTypes.contains(filterBlock)) {
            return Stream.empty();
        }
        return targetList.stream().filter(target -> {
            BlockPos pos = target.getPos();
            BlockState blockState = level.m_8055_(pos);
            String blockId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_())).toString();
            return blockId.equals(filterBlock);
        });
    }

    public static Optional<Double> gto$isTeleportPositionAndSurroundingClear(BlockGetter level, BlockPos target) {
        Optional<Double> result = TravelHandler.isTeleportPositionClear(level, target);
        if (result.isPresent()) {
            return result;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = target.m_121945_(dir).m_7495_();
            result = TravelHandler.isTeleportPositionClear(level, offsetPos);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public static void removeAndReadd(@NotNull Level level, PatternProviderLogicHost host) {
        ITravelTarget anchorTravelTarget;
        ITravelTarget iTravelTarget;
        Optional<ITravelTarget> travelTarget = TravelSavedData.getTravelData(level).getTravelTarget(host.getBlockEntity().m_58899_());
        if (travelTarget.isPresent() && (iTravelTarget = travelTarget.get()) instanceof ITravelTarget) {
            anchorTravelTarget = iTravelTarget;
            TravelSavedData.getTravelData(level).removeTravelTargetAt(level, anchorTravelTarget.getPos());
        }
        if (!GTOConfig.INSTANCE.travelConfig.staffOfTravellingPatternNodes) {
            return;
        }
        anchorTravelTarget = new PatternTravelTarget(host);
        TravelSavedData.getTravelData(level).addTravelTarget(level, anchorTravelTarget);
        ITravelHandlerHook.requireResync(level);
    }

    public static void removeAndReadd(@NotNull Level level, MEPatternPartMachineKt<?> host) {
        ITravelTarget anchorTravelTarget;
        ITravelTarget iTravelTarget;
        Optional<ITravelTarget> travelTarget = TravelSavedData.getTravelData(level).getTravelTarget(host.getHolder().m_58899_());
        if (travelTarget.isPresent() && (iTravelTarget = travelTarget.get()) instanceof ITravelTarget) {
            anchorTravelTarget = iTravelTarget;
            TravelSavedData.getTravelData(level).removeTravelTargetAt(level, anchorTravelTarget.getPos());
        }
        if (!GTOConfig.INSTANCE.travelConfig.staffOfTravellingPatternNodes) {
            return;
        }
        anchorTravelTarget = new PatternTravelTarget(host);
        TravelSavedData.getTravelData(level).addTravelTarget(level, anchorTravelTarget);
        ITravelHandlerHook.requireResync(level);
    }

    public static void requireResync(@NotNull Level level) {
        EventHandler.syncTask = () -> {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                TravelNetworks.syncTravelData(TravelSavedData.getTravelData(level).m_7176_(new CompoundTag()), serverLevel);
            }
            EventHandler.syncTask = null;
        };
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class EventHandler {
        @Nullable
        public static Runnable syncTask = null;

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END && syncTask != null) {
                syncTask.run();
            }
        }
    }
}

