/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.eio_travel;

import com.gtocore.config.GTOConfig;
import com.gtocore.eio_travel.ITravelTarget;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractTravelTarget
implements ITravelTarget {
    private final BlockPos pos;
    private String name;
    private Item icon;
    private boolean visible;

    public AbstractTravelTarget(BlockPos pos, String name, Item icon, boolean visible) {
        this.pos = pos;
        this.name = name;
        this.icon = icon;
        this.visible = visible;
    }

    @Override
    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("BlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getPos()));
        nbt.m_128359_("AnchorName", this.getName());
        nbt.m_128359_("AnchorIcon", String.valueOf(ForgeRegistries.ITEMS.getKey((Object)this.getIcon())));
        nbt.m_128379_("AnchorVisibility", this.getVisibility());
        return nbt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractTravelTarget)) {
            return false;
        }
        AbstractTravelTarget other = (AbstractTravelTarget)o;
        return this.pos.equals((Object)other.pos) && this.name.equals(other.name) && this.visible == other.visible && Objects.equals(this.icon, other.icon);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.name, this.icon);
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    public boolean getVisibility() {
        return this.visible;
    }

    public void setVisibility(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean canTeleportTo() {
        return this.getVisibility();
    }

    @Override
    public boolean canJumpTo() {
        return true;
    }

    @Override
    public int getItem2BlockRange() {
        return GTOConfig.INSTANCE.travelConfig.blockRange;
    }

    @Override
    public int getBlock2BlockRange() {
        return GTOConfig.INSTANCE.travelConfig.itemRange;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Item getIcon() {
        return this.icon;
    }

    @Generated
    public boolean isVisible() {
        return this.visible;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setIcon(Item icon) {
        this.icon = icon;
    }

    @Generated
    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

