/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.transaction.data;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.api.gui.StackTexture;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMachines;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.data.transaction.TradingStationTool;
import com.gtocore.data.transaction.data.trade.EnergyGroup;
import com.gtocore.data.transaction.data.trade.PlayersGroup;
import com.gtocore.data.transaction.data.trade.UnlockTrade;
import com.gtocore.data.transaction.data.trade.WelcomeGroup;
import com.gtocore.data.transaction.data.trade.WelfareGroup;
import com.gtocore.data.transaction.manager.TradeData;
import com.gtocore.data.transaction.manager.TradeEntry;
import com.gtolib.GTOCore;
import com.gtolib.utils.WalletUtils;
import com.gtolib.utils.holder.IntObjectHolder;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public final class GTOTrade {
    public static void init() {
        GTOTrade.recipe();
        UnlockTrade.init();
        WelcomeGroup.init();
        PlayersGroup.init();
        WelfareGroup.init();
        EnergyGroup.init();
    }

    private static void recipe() {
        VanillaRecipeHelper.addShapedRecipe((ResourceLocation)GTOCore.id((String)"palm_sized_bank"), (ItemStack)GTOItems.PALM_SIZED_BANK.asStack(), (Object[])new Object[]{" A ", "ABA", " A ", Character.valueOf('A'), new MaterialEntry(GTOTagPrefix.COIN, GTMaterials.Copper), Character.valueOf('B'), GTItems.TERMINAL.asStack()});
        VanillaRecipeHelper.addShapedRecipe((ResourceLocation)GTOCore.id((String)"lv_trading_station"), (ItemStack)GTOMachines.TRADING_STATION[1].asStack(), (Object[])new Object[]{" A ", "ABA", " A ", Character.valueOf('A'), new MaterialEntry(GTOTagPrefix.COIN, GTMaterials.Copper), Character.valueOf('B'), GTOItems.GREG_MEMBERSHIP_CARD.asStack()});
    }

    public static TradeEntry simpleItemTrading(boolean BuyingOrSelling, String unlockCondition, ItemStack stack, String currency, int amount) {
        TradeEntry.Builder builder = new TradeEntry.Builder().texture((IGuiTexture)new StackTexture((Object)stack)).unlockCondition(unlockCondition);
        if (BuyingOrSelling) {
            builder.inputCurrency(currency, amount).outputItem(stack);
        } else {
            builder.outputCurrency(currency, amount).inputItem(stack);
        }
        return builder.build();
    }

    public static TradeEntry freeItemTrading(String unlockCondition, ItemStack stack) {
        return new TradeEntry.Builder().texture((IGuiTexture)new StackTexture((Object)stack)).unlockCondition(unlockCondition).outputItem(stack).build();
    }

    public static TradeEntry SimpleLotteryTrading(String unlockCondition, String currency, int amount, List<Component> components, List<IntObjectHolder<ItemStack>> reward) {
        ItemStack[] itemStacks = (ItemStack[])reward.stream().map(i -> (ItemStack)i.obj).toArray(ItemStack[]::new);
        ArrayList<Component> description = new ArrayList<Component>(components);
        for (IntObjectHolder<ItemStack> entry : reward) {
            ItemStack itemStack = (ItemStack)entry.obj;
            description.add((Component)Component.m_237110_((String)"gtocore.trade_lottery.weight", (Object[])new Object[]{itemStack.m_41611_(), itemStack.m_41613_(), entry.number}));
        }
        ImmutableList finalReward = ImmutableList.copyOf(reward);
        TradeEntry.Builder builder = new TradeEntry.Builder().texture((IGuiTexture)new StackTexture(itemStacks)).unlockCondition(unlockCondition).description(description).inputCurrency(currency, amount).onExecute((arg_0, arg_1, arg_2) -> GTOTrade.lambda$SimpleLotteryTrading$2((List)finalReward, arg_0, arg_1, arg_2));
        return builder.build();
    }

    public static IntObjectHolder<ItemStack> lotteryItem(int weight, ItemStack itemStack) {
        return new IntObjectHolder(weight, (Object)itemStack);
    }

    private static void performLottery(TradeData data, TradeEntry entry, int multiplier, List<IntObjectHolder<ItemStack>> rewards) {
        Level level = data.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int totalWeight = rewards.stream().mapToInt(i -> i.number).sum();
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        RandomSource random = serverLevel.m_213780_();
        block0: for (int i2 = 0; i2 < multiplier; ++i2) {
            int randomRoll = random.m_188503_(totalWeight);
            int currentWeight = 0;
            for (IntObjectHolder<ItemStack> rewardEntry : rewards) {
                if (randomRoll >= (currentWeight += rewardEntry.number)) continue;
                ItemStack winningStack = ((ItemStack)rewardEntry.obj).m_41777_();
                stackList.add(winningStack);
                continue block0;
            }
        }
        TradingStationTool.addMultipliedItems(data.outputItem(), stackList, 1, data.level(), data.pos());
    }

    public static TradeEntry simpleLimitedTimesItemTrading(boolean BuyingOrSelling, String unlockCondition, ItemStack stack, String currency, int amount, String record, long time, int maxMultiplier) {
        TradeEntry.Builder builder = new TradeEntry.Builder().texture((IGuiTexture)new StackTexture((Object)stack)).unlockCondition(unlockCondition).preCheck((a2, b2) -> GTOTrade.checkMultiplier(a2, b2, record, maxMultiplier)).onExecute((a2, b2, c) -> GTOTrade.performAddMultiplier(a2, b2, c, record, time));
        if (BuyingOrSelling) {
            builder.inputCurrency(currency, amount).outputItem(stack);
        } else {
            builder.outputCurrency(currency, amount).inputItem(stack);
        }
        return builder.build();
    }

    public static int checkMultiplier(TradeData data, TradeEntry entry, String record, int maxMultiplier) {
        Level level = data.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        long amount = WalletUtils.getTransactionTotalAmount((UUID)data.uuid(), (Level)serverLevel, (String)record);
        if ((long)maxMultiplier > amount) {
            return Math.toIntExact((long)maxMultiplier - amount);
        }
        return 0;
    }

    public static void performAddMultiplier(TradeData data, TradeEntry entry, int multiplier, String record, long time) {
        Level level = data.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        WalletUtils.addScheduledDeletion((UUID)data.uuid(), (Level)serverLevel, (String)record, (long)time, (long)multiplier);
    }

    public static TradeEntry simpleSingleTimesItemTrading(boolean BuyingOrSelling, String unlockCondition, ItemStack stack, String currency, int amount, String tag) {
        TradeEntry.Builder builder = new TradeEntry.Builder().texture((IGuiTexture)new StackTexture((Object)stack)).unlockCondition(unlockCondition).preCheck((a2, b2) -> GTOTrade.checkTag(a2, b2, tag)).onExecute((a2, b2, c) -> GTOTrade.performTag(a2, b2, c, tag));
        if (BuyingOrSelling) {
            builder.inputCurrency(currency, amount).outputItem(stack);
        } else {
            builder.outputCurrency(currency, amount).inputItem(stack);
        }
        return builder.build();
    }

    public static int checkTag(TradeData data, TradeEntry entry, String tag) {
        ServerLevel serverLevel;
        Level level = data.level();
        ServerLevel serverLevel2 = serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (!WalletUtils.containsTagValueInWallet((UUID)data.uuid(), (Level)serverLevel, (String)"Single Transaction", (String)tag)) {
            return 1;
        }
        return 0;
    }

    public static void performTag(TradeData data, TradeEntry entry, int multiplier, String tag) {
        Level level = data.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        WalletUtils.addTagToWallet((UUID)data.uuid(), (Level)serverLevel, (String)"Single Transaction", (String)tag);
    }

    public static List<TradeEntry> createTestTradeTemplates() {
        TradeEntry woodForBread = new TradeEntry.Builder().texture((IGuiTexture)new ItemStackTexture(new Item[]{Items.f_42406_})).description(List.of(Component.m_237113_((String)"10\u4e2a\u6728\u5934 \u2192 1\u4e2a\u9762\u5305"))).unlockCondition("Base").inputItem(new ItemStack((ItemLike)Items.f_41888_, 10)).outputItem(new ItemStack((ItemLike)Items.f_42406_, 1)).build();
        TradeEntry stoneForCobblestone = new TradeEntry.Builder().texture((IGuiTexture)new StackTexture((Object)Items.f_42594_)).description(List.of(Component.m_237113_((String)"1\u4e2a\u77f3\u5934 \u2192 2\u4e2a\u5706\u77f3"))).unlockCondition("Base").inputItem(new ItemStack((ItemLike)Items.f_41905_, 1)).outputItem(new ItemStack((ItemLike)Items.f_42594_, 2)).build();
        TradeEntry fluidsForObsidian = new TradeEntry.Builder().texture((IGuiTexture)new StackTexture((Object)GTOMaterials.TranscendingMatter.getFluid(60000000))).description(List.of(Component.m_237113_((String)"1\u6876\u6c34 + 1\u6876\u5ca9\u6d46 \u2192 1\u4e2a\u9ed1\u66dc\u77f3"))).unlockCondition("Base").inputFluid(new FluidStack((Fluid)Fluids.f_76193_, 1000)).inputFluid(new FluidStack((Fluid)Fluids.f_76195_, 1000)).outputItem(new ItemStack((ItemLike)Items.f_41999_, 1)).build();
        TradeEntry currencyForDiamond = new TradeEntry.Builder().texture((IGuiTexture)new StackTexture((Object)Items.f_42415_)).description(List.of(Component.m_237113_((String)"1000\u5355\u4f4d\u8d27\u5e01 \u2192 1\u4e2a\u94bb\u77f3"))).unlockCondition("Base").inputCurrency("tech_operator_coin", 1000L).outputItem(new ItemStack((ItemLike)Items.f_42415_, 1)).build();
        return List.of(woodForBread, stoneForCobblestone, fluidsForObsidian, currencyForDiamond);
    }

    private static /* synthetic */ void lambda$SimpleLotteryTrading$2(List finalReward, TradeData a2, TradeEntry b2, int c) {
        GTOTrade.performLottery(a2, b2, c, finalReward);
    }
}

