/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.record;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.item.ApothItem;
import com.gtocore.common.item.ColoringItems;
import com.gtocore.data.tag.Tags;
import com.gtolib.GTOCore;
import com.gtolib.utils.RLUtils;
import com.gtolib.utils.register.ItemRegisterUtils;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public record EnchantmentRecord(String enchantmentId, int maxLevels, String simplifiedId, String translationKey, int color, String processedId) {
    private static List<EnchantmentRecord> ENCHANTMENTS = new ArrayList<EnchantmentRecord>();
    public static final Map<Item, EnchantmentRecord> ENCHANTMENT_ITEM_MAP;

    public static EnchantmentRecord create(String enchantmentId, int maxLevels, String simplifiedId, String translationKey) {
        int color = EnchantmentRecord.generateColorFromId(enchantmentId);
        String processedId = enchantmentId.indexOf(58) > 0 ? enchantmentId.substring(enchantmentId.indexOf(58) + 1) : enchantmentId;
        return new EnchantmentRecord(enchantmentId, maxLevels, simplifiedId, translationKey, color, processedId);
    }

    private static int generateColorFromId(String enchantmentId) {
        int hash = enchantmentId.hashCode();
        int r = (hash & 0xFF0000) >> 16;
        int g = (hash & 0xFF00) >> 8;
        int b2 = hash & 0xFF;
        r = Math.max(r, 48);
        g = Math.max(g, 48);
        b2 = Math.max(b2, 48);
        return r << 16 | g << 8 | b2;
    }

    private static void addRecord(String enchantmentId, int maxLevels, String simplifiedId, String translationKey) {
        EnchantmentRecord record = EnchantmentRecord.create(enchantmentId, maxLevels, simplifiedId, translationKey);
        ENCHANTMENTS.add(record);
    }

    public static ItemStack getEnchantedBookByEnchantmentId(String enchantment, int lvl) {
        if (!EnchantmentRecord.isEnchantmentValid(enchantment)) {
            return new ItemStack((ItemLike)Items.f_42690_);
        }
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
        CompoundTag bookTag = enchantedBook.m_41784_();
        ListTag storedEnchantments = bookTag.m_128437_("StoredEnchantments", 10);
        CompoundTag enchantTag = new CompoundTag();
        enchantTag.m_128359_("id", enchantment);
        enchantTag.m_128376_("lvl", (short)lvl);
        storedEnchantments.add((Object)enchantTag);
        bookTag.m_128365_("StoredEnchantments", (Tag)storedEnchantments);
        enchantedBook.m_41751_(bookTag);
        return enchantedBook;
    }

    private static boolean isEnchantmentValid(String enchantmentId) {
        ResourceLocation rl = RLUtils.parse((String)enchantmentId);
        return BuiltInRegistries.f_256876_.m_7804_(rl);
    }

    public static Map<String, ItemEntry<ApothItem>> registerEnchantmentEssence() {
        ImmutableMap.Builder entries = ImmutableMap.builder();
        for (EnchantmentRecord record : ENCHANTMENTS) {
            String itemId = "enchantment_essence_" + record.processedId();
            String cnName = "\u9644\u9b54\u7cbe\u7cb9 (" + record.simplifiedId() + ")";
            String enName = "Enchantment Essence (" + FormattingUtil.toEnglishName((Object)record.processedId()) + ")";
            ItemEntry entry = ((ItemBuilder)ItemRegisterUtils.item((String)itemId, (String)cnName, p -> ApothItem.create(p, record.color())).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{GTOCore.id((String)"item/apoth/orb0"), GTOCore.id((String)"item/apoth/orb1")})).lang(enName).color(() -> ColoringItems::color).tag(new TagKey[]{Tags.ENCHANTMENT_ESSENCE}).onRegister(i -> ENCHANTMENT_ITEM_MAP.put((Item)i, record))).register();
            entries.put((Object)record.enchantmentId(), (Object)entry);
        }
        ENCHANTMENTS = null;
        return entries.build();
    }

    static {
        EnchantmentRecord.addRecord("original", 0, "\u539f\u59cb", "original");
        EnchantmentRecord.addRecord("apotheosis:bane_of_illagers", 5, "\u707e\u5384\u6751\u6c11\u6740\u624b", "enchantment.apotheosis.bane_of_illagers");
        EnchantmentRecord.addRecord("apotheosis:berserkers_fury", 3, "\u72c2\u6218\u58eb\u4e4b\u6012", "enchantment.apotheosis.berserkers_fury");
        EnchantmentRecord.addRecord("apotheosis:capturing", 5, "\u6355\u6349", "enchantment.apotheosis.capturing");
        EnchantmentRecord.addRecord("apotheosis:chainsaw", 1, "\u94fe\u952f", "enchantment.apotheosis.chainsaw");
        EnchantmentRecord.addRecord("apotheosis:chromatic", 1, "\u8272\u5dee", "enchantment.apotheosis.chromatic");
        EnchantmentRecord.addRecord("apotheosis:crescendo", 5, "\u53e0\u88c5\u5f29\u7bad", "enchantment.apotheosis.crescendo");
        EnchantmentRecord.addRecord("apotheosis:earths_boon", 3, "\u5730\u7403\u6069\u60e0", "enchantment.apotheosis.earths_boon");
        EnchantmentRecord.addRecord("apotheosis:endless_quiver", 1, "\u65e0\u5c3d\u7bad\u888b", "enchantment.apotheosis.endless_quiver");
        EnchantmentRecord.addRecord("apotheosis:exploitation", 1, "\u5265\u524a", "enchantment.apotheosis.exploitation");
        EnchantmentRecord.addRecord("apotheosis:growth_serum", 1, "\u751f\u957f\u8840\u6e05", "enchantment.apotheosis.growth_serum");
        EnchantmentRecord.addRecord("apotheosis:icy_thorns", 3, "\u5bd2\u51b0\u8346\u68d8", "enchantment.apotheosis.icy_thorns");
        EnchantmentRecord.addRecord("apotheosis:infusion", 1, "\u704c\u6ce8", "enchantment.apotheosis.infusion");
        EnchantmentRecord.addRecord("apotheosis:knowledge", 3, "\u5c81\u6708\u5b66\u8bc6", "enchantment.apotheosis.knowledge");
        EnchantmentRecord.addRecord("apotheosis:life_mending", 3, "\u751f\u547d\u4fee\u8865", "enchantment.apotheosis.life_mending");
        EnchantmentRecord.addRecord("apotheosis:miners_fervor", 5, "\u77ff\u5de5\u70ed\u5ff1", "enchantment.apotheosis.miners_fervor");
        EnchantmentRecord.addRecord("apotheosis:natures_blessing", 3, "\u81ea\u7136\u795d\u798f", "enchantment.apotheosis.natures_blessing");
        EnchantmentRecord.addRecord("apotheosis:obliteration", 1, "\u5206\u88c2", "enchantment.apotheosis.obliteration");
        EnchantmentRecord.addRecord("apotheosis:rebounding", 3, "\u5f39\u98de", "enchantment.apotheosis.rebounding");
        EnchantmentRecord.addRecord("apotheosis:reflective", 5, "\u9632\u5fa1\u53cd\u51fb", "enchantment.apotheosis.reflective");
        EnchantmentRecord.addRecord("apotheosis:scavenger", 3, "\u6e05\u9053\u592b", "enchantment.apotheosis.scavenger");
        EnchantmentRecord.addRecord("apotheosis:shield_bash", 4, "\u76fe\u51fb", "enchantment.apotheosis.shield_bash");
        EnchantmentRecord.addRecord("apotheosis:spearfishing", 5, "\u53c9\u9c7c", "enchantment.apotheosis.spearfishing");
        EnchantmentRecord.addRecord("apotheosis:splitting", 1, "\u62c6\u5206", "enchantment.apotheosis.splitting");
        EnchantmentRecord.addRecord("apotheosis:stable_footing", 1, "\u7a33\u5b9a\u7acb\u8db3", "enchantment.apotheosis.stable_footing");
        EnchantmentRecord.addRecord("apotheosis:tempting", 1, "\u5f15\u8bf1", "enchantment.apotheosis.tempting");
        EnchantmentRecord.addRecord("ars_nouveau:mana_boost", 3, "\u9b54\u529b\u63d0\u5347", "enchantment.ars_nouveau.mana_boost");
        EnchantmentRecord.addRecord("ars_nouveau:mana_regen", 3, "\u9b54\u529b\u518d\u751f", "enchantment.ars_nouveau.mana_regen");
        EnchantmentRecord.addRecord("ars_nouveau:reactive", 3, "\u53cd\u5e94", "enchantment.ars_nouveau.reactive");
        EnchantmentRecord.addRecord("deeperdarker:catalysis", 3, "\u50ac\u53d1", "enchantment.deeperdarker.catalysis");
        EnchantmentRecord.addRecord("deeperdarker:sculk_smite", 5, "\u5e7d\u533f\u6740\u624b", "enchantment.deeperdarker.sculk_smite");
        EnchantmentRecord.addRecord("farmersdelight:backstabbing", 3, "\u80cc\u523a", "enchantment.farmersdelight.backstabbing");
        EnchantmentRecord.addRecord("minecraft:aqua_affinity", 1, "\u6c34\u4e0b\u901f\u6398", "enchantment.minecraft.aqua_affinity");
        EnchantmentRecord.addRecord("minecraft:bane_of_arthropods", 5, "\u8282\u80a2\u6740\u624b", "enchantment.minecraft.bane_of_arthropods");
        EnchantmentRecord.addRecord("minecraft:binding_curse", 1, "\u7ed1\u5b9a\u8bc5\u5492", "enchantment.minecraft.binding_curse");
        EnchantmentRecord.addRecord("minecraft:blast_protection", 4, "\u7206\u70b8\u4fdd\u62a4", "enchantment.minecraft.blast_protection");
        EnchantmentRecord.addRecord("minecraft:channeling", 1, "\u5f15\u96f7", "enchantment.minecraft.channeling");
        EnchantmentRecord.addRecord("minecraft:depth_strider", 3, "\u6df1\u6d77\u63a2\u7d22\u8005", "enchantment.minecraft.depth_strider");
        EnchantmentRecord.addRecord("minecraft:efficiency", 5, "\u6548\u7387", "enchantment.minecraft.efficiency");
        EnchantmentRecord.addRecord("minecraft:feather_falling", 4, "\u6454\u843d\u7f13\u51b2", "enchantment.minecraft.feather_falling");
        EnchantmentRecord.addRecord("minecraft:fire_aspect", 2, "\u706b\u7130\u9644\u52a0", "enchantment.minecraft.fire_aspect");
        EnchantmentRecord.addRecord("minecraft:fire_protection", 4, "\u706b\u7130\u4fdd\u62a4", "enchantment.minecraft.fire_protection");
        EnchantmentRecord.addRecord("minecraft:flame", 1, "\u706b\u77e2", "enchantment.minecraft.flame");
        EnchantmentRecord.addRecord("minecraft:fortune", 3, "\u65f6\u8fd0", "enchantment.minecraft.fortune");
        EnchantmentRecord.addRecord("minecraft:frost_walker", 2, "\u51b0\u971c\u884c\u8005", "enchantment.minecraft.frost_walker");
        EnchantmentRecord.addRecord("minecraft:impaling", 5, "\u7a7f\u523a", "enchantment.minecraft.impaling");
        EnchantmentRecord.addRecord("minecraft:infinity", 1, "\u65e0\u9650", "enchantment.minecraft.infinity");
        EnchantmentRecord.addRecord("minecraft:knockback", 2, "\u51fb\u9000", "enchantment.minecraft.knockback");
        EnchantmentRecord.addRecord("minecraft:looting", 3, "\u62a2\u593a", "enchantment.minecraft.looting");
        EnchantmentRecord.addRecord("minecraft:loyalty", 3, "\u5fe0\u8bda", "enchantment.minecraft.loyalty");
        EnchantmentRecord.addRecord("minecraft:luck_of_the_sea", 3, "\u6d77\u4e4b\u7737\u987e", "enchantment.minecraft.luck_of_the_sea");
        EnchantmentRecord.addRecord("minecraft:lure", 3, "\u9975\u9493", "enchantment.minecraft.lure");
        EnchantmentRecord.addRecord("minecraft:mending", 1, "\u7ecf\u9a8c\u4fee\u8865", "enchantment.minecraft.mending");
        EnchantmentRecord.addRecord("minecraft:multishot", 1, "\u591a\u91cd\u5c04\u51fb", "enchantment.minecraft.multishot");
        EnchantmentRecord.addRecord("minecraft:piercing", 4, "\u7a7f\u900f", "enchantment.minecraft.piercing");
        EnchantmentRecord.addRecord("minecraft:power", 5, "\u529b\u91cf", "enchantment.minecraft.power");
        EnchantmentRecord.addRecord("minecraft:projectile_protection", 4, "\u5f39\u5c04\u7269\u4fdd\u62a4", "enchantment.minecraft.projectile_protection");
        EnchantmentRecord.addRecord("minecraft:protection", 4, "\u4fdd\u62a4", "enchantment.minecraft.protection");
        EnchantmentRecord.addRecord("minecraft:punch", 2, "\u51b2\u51fb", "enchantment.minecraft.punch");
        EnchantmentRecord.addRecord("minecraft:quick_charge", 3, "\u5feb\u901f\u88c5\u586b", "enchantment.minecraft.quick_charge");
        EnchantmentRecord.addRecord("minecraft:respiration", 3, "\u6c34\u4e0b\u547c\u5438", "enchantment.minecraft.respiration");
        EnchantmentRecord.addRecord("minecraft:riptide", 3, "\u6fc0\u6d41", "enchantment.minecraft.riptide");
        EnchantmentRecord.addRecord("minecraft:sharpness", 5, "\u950b\u5229", "enchantment.minecraft.sharpness");
        EnchantmentRecord.addRecord("minecraft:silk_touch", 1, "\u7cbe\u51c6\u91c7\u96c6", "enchantment.minecraft.silk_touch");
        EnchantmentRecord.addRecord("minecraft:smite", 5, "\u4ea1\u7075\u6740\u624b", "enchantment.minecraft.smite");
        EnchantmentRecord.addRecord("minecraft:soul_speed", 3, "\u7075\u9b42\u75be\u884c", "enchantment.minecraft.soul_speed");
        EnchantmentRecord.addRecord("minecraft:sweeping", 3, "\u6a2a\u626b\u4e4b\u5203", "enchantment.minecraft.sweeping");
        EnchantmentRecord.addRecord("minecraft:swift_sneak", 3, "\u8fc5\u6377\u6f5c\u884c", "enchantment.minecraft.swift_sneak");
        EnchantmentRecord.addRecord("minecraft:thorns", 3, "\u8346\u68d8", "enchantment.minecraft.thorns");
        EnchantmentRecord.addRecord("minecraft:unbreaking", 3, "\u8010\u4e45", "enchantment.minecraft.unbreaking");
        EnchantmentRecord.addRecord("minecraft:vanishing_curse", 1, "\u6d88\u5931\u8bc5\u5492", "enchantment.minecraft.vanishing_curse");
        EnchantmentRecord.addRecord("mythicbotany:hammer_mobility", 5, "\u5feb\u901f\u6325\u9524", "enchantment.mythicbotany.hammer_mobility");
        ENCHANTMENT_ITEM_MAP = new Reference2ReferenceOpenHashMap();
    }
}

