/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.misc;

import com.gregtechceu.gtceu.api.data.DimensionMarker;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTDimensionMarkers;
import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.data.machines.SpaceMultiblock;
import com.gtocore.common.item.OrderItem;
import com.gtolib.GTOCore;
import com.gtolib.api.data.Dimension;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.utils.RLUtils;
import earth.terrarium.adastra.common.recipes.SpaceStationRecipe;
import earth.terrarium.adastra.common.recipes.base.IngredientHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SpaceStationRecipes {
    public static void init() {
        SpaceStationBuilder.builder("earth_orbit_space_station").dimension(Dimension.OVERWORLD).inputItems((ItemLike)SpaceMultiblock.SPACE_STATION.asItem()).inputItems((ItemLike)GTBlocks.CASING_STAINLESS_CLEAN.m_5456_(), 64).inputItems((ItemLike)GTOBlocks.ALUMINUM_ALLOY_8090_SKIN_MECHANICAL_BLOCK.m_5456_(), 64).inputItems((ItemLike)GTBlocks.CASING_TITANIUM_STABLE.m_5456_(), 32).inputItems((ItemLike)GTOBlocks.ALUMINUM_ALLOY_7050_SUPPORT_MECHANICAL_BLOCK.m_5456_(), 16).inputItems((ItemLike)GTOBlocks.PRESSURE_CONTAINMENT_CASING.m_5456_(), 16).inputItems((ItemLike)GTBlocks.FILTER_CASING.m_5456_(), 16).inputItems(GTOTagPrefix.frameGt, GTOMaterials.StainlessSteelGC4, 16).inputItems((ItemLike)GTOBlocks.SPACECRAFT_SEALING_MECHANICAL_BLOCK.m_5456_(), 16).build();
        for (Dimension dimension : Dimension.values()) {
            if (dimension == Dimension.OVERWORLD || !dimension.isWithinGalaxy()) continue;
            SpaceStationBuilder.builder("orbit_space_station_" + dimension.name().toLowerCase()).dimension(dimension).inputItems((ItemLike)SpaceMultiblock.SPACE_STATION.asItem()).inputItems((ItemLike)GTBlocks.CASING_STAINLESS_CLEAN.m_5456_(), 344).inputItems((ItemLike)GTOBlocks.ALUMINUM_ALLOY_8090_SKIN_MECHANICAL_BLOCK.m_5456_(), 148).inputItems((ItemLike)GTOBlocks.TITANIUM_ALLOY_PROTECTIVE_MECHANICAL_BLOCK.m_5456_(), 128).inputItems((ItemLike)GTOBlocks.ALUMINUM_ALLOY_7050_SUPPORT_MECHANICAL_BLOCK.m_5456_(), 28).inputItems((ItemLike)GTOBlocks.PRESSURE_CONTAINMENT_CASING.m_5456_(), 38).inputItems((ItemLike)GTBlocks.FILTER_CASING.m_5456_(), 16).inputItems(GTOTagPrefix.frameGt, GTOMaterials.StainlessSteelGC4, 46).inputItems((ItemLike)GTOBlocks.SPACECRAFT_SEALING_MECHANICAL_BLOCK.m_5456_(), 117).inputItems((ItemLike)GTOBlocks.ALUMINUM_ALLOY_2090_SKIN_MECHANICAL_BLOCK.m_5456_(), 32).build();
        }
    }

    public static void initJsonFilter(Set<ResourceLocation> filters) {
        filters.add(RLUtils.ad((String)"space_station/earth_orbit_space_station"));
        filters.add(RLUtils.ad((String)"space_station/moon_orbit_space_station"));
        filters.add(RLUtils.ad((String)"space_station/mars_orbit_space_station"));
        filters.add(RLUtils.ad((String)"space_station/venus_orbit_space_station"));
        filters.add(RLUtils.ad((String)"space_station/mercury_orbit_space_station"));
    }

    private static class SpaceStationBuilder {
        private final List<IngredientHolder> ingredients = new ArrayList<IngredientHolder>();
        private ResourceKey<Level> orbit;
        private Dimension dimension;
        private final ResourceLocation id;
        private ResourceLocation structure = GTOCore.id((String)"space_station");

        private SpaceStationBuilder(String id) {
            this.id = GTOCore.id((String)("adastra_space_station_" + id));
        }

        public SpaceStationBuilder structure(ResourceLocation structure) {
            this.structure = structure;
            return this;
        }

        static SpaceStationBuilder builder(String id) {
            return new SpaceStationBuilder(id);
        }

        SpaceStationBuilder dimension(Dimension dimension) {
            this.orbit = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimension.getOrbit());
            this.dimension = dimension;
            return this;
        }

        public SpaceStationBuilder inputItems(TagKey<Item> tag, int count) {
            this.ingredients.add(IngredientHolder.of((Ingredient)Ingredient.m_204132_(tag), (int)count));
            return this;
        }

        SpaceStationBuilder inputItems(TagPrefix tagPrefix, Material material, int count) {
            return this.inputItems((ItemLike)ChemicalHelper.get((TagPrefix)tagPrefix, (Material)material).m_41720_(), count);
        }

        SpaceStationBuilder inputItems(ItemLike item, int count) {
            this.ingredients.add(IngredientHolder.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), (int)count));
            return this;
        }

        public SpaceStationBuilder inputItems(TagKey<Item> tag) {
            this.ingredients.add(IngredientHolder.of((Ingredient)Ingredient.m_204132_(tag)));
            return this;
        }

        SpaceStationBuilder inputItems(ItemLike item) {
            this.ingredients.add(IngredientHolder.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{item})));
            return this;
        }

        void build() {
            GTRecipes.RECIPE_MAP.put(this.id, new SpaceStationRecipe(this.id, this.ingredients, this.orbit, this.structure));
            RecipeBuilder recipe = GTORecipeTypes.SPACE_STATION_CONSTRUCTION_RECIPES.builder(this.id.m_135815_(), new Object[0]).dimension(this.dimension.getLocation());
            this.ingredients.forEach(i -> recipe.inputItems(i.ingredient(), i.count()));
            recipe.outputItems(OrderItem.setTarget(GTOItems.ORDER.asStack(), ((DimensionMarker)GTRegistries.DIMENSION_MARKERS.getOrDefault((Object)this.dimension.getLocation(), (Object)GTDimensionMarkers.OVERWORLD)).getIcon()));
            recipe.save();
        }
    }
}

