/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.gtm.misc;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidContainerIngredient;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.utils.RLUtils;
import com.gtolib.utils.RegistriesUtils;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public final class VanillaStandardRecipes {
    public static void init() {
        VanillaStandardRecipes.compressingRecipes();
        VanillaStandardRecipes.glassRecipes();
        VanillaStandardRecipes.smashingRecipes();
        VanillaStandardRecipes.woodRecipes();
        VanillaStandardRecipes.cuttingRecipes();
        VanillaStandardRecipes.dyingCleaningRecipes();
        VanillaStandardRecipes.redstoneRecipes();
        VanillaStandardRecipes.metalRecipes();
        VanillaStandardRecipes.miscRecipes();
        VanillaStandardRecipes.mixingRecipes();
        VanillaStandardRecipes.dyeRecipes();
    }

    private static void compressingRecipes() {
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("stone_from_dust").duration(300).EUt(2L).inputItems(TagPrefix.plate, GTMaterials.Stone, 9).outputItems((Object)Blocks.f_50069_).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("sandstone").duration(300).EUt(2L).inputItems(Blocks.f_49992_, 4).outputItems((Object)Blocks.f_50062_).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("red_sandstone").duration(300).EUt(2L).inputItems(Blocks.f_49993_, 4).outputItems((Object)Blocks.f_50394_).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("bricks").duration(300).EUt(2L).inputItems(Items.f_42460_, 4).outputItems((Object)Blocks.f_50076_).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("nether_bricks").duration(300).EUt(2L).inputItems(Items.f_42691_, 4).outputItems((Object)Blocks.f_50197_).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("ice_from_snow").duration(300).EUt(2L).inputItems((Object)Blocks.f_50125_).outputItems((Object)Blocks.f_50126_).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("clay").duration(300).EUt(2L).inputItems(Items.f_42461_, 4).outputItems((Object)Blocks.f_50129_).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("snowballs_to_snow").duration(200).EUt(2L).inputItems(Items.f_42452_, 4).outputItems(Items.f_41981_).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("glowstone").duration(300).EUt(2L).inputItems(Items.f_42525_, 4).outputItems((Object)Blocks.f_50141_).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("packed_ice").inputItems(Blocks.f_50126_, 9).outputItems((Object)Blocks.f_50354_).duration(300).EUt(2L).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("blue_ice").inputItems(Blocks.f_50354_, 9).outputItems((Object)Blocks.f_50568_).duration(300).EUt(2L).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("ice_from_dust").inputItems(TagPrefix.dust, GTMaterials.Ice).outputItems((Object)Blocks.f_50126_).duration(300).EUt(2L).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("dripstone_block_from_pointed_dripstone").inputItems(Items.f_151087_, 4).outputItems((Object)Blocks.f_152537_).duration(300).EUt(2L).save();
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("pointed_dripstone_from_dripstone_block").inputItems((Object)Blocks.f_152537_).outputItems(Items.f_151087_, 4).duration(300).EUt(2L).save();
        GTORecipeTypes.PACKER_RECIPES.recipeBuilder("hay_block").inputItems(Items.f_42405_, 9).circuitMeta(8).outputItems((Object)Blocks.f_50335_).duration(200).EUt(2L).save();
        GTORecipeTypes.PACKER_RECIPES.recipeBuilder("wheat").inputItems((Object)Blocks.f_50335_).outputItems(Items.f_42405_, 9).circuitMeta(9).duration(200).EUt(2L).save();
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("wheat_from_hay_block").inputItems((Object)Blocks.f_50335_).outputItems(Items.f_42405_, 9).duration(200).EUt(2L).save();
        GTORecipeTypes.PACKER_RECIPES.recipeBuilder("melon").inputItems(Items.f_42575_, 9).circuitMeta(9).outputItems((Object)Blocks.f_50186_).duration(200).EUt(2L).save();
    }

    private static void glassRecipes() {
        VanillaRecipeHelper.addShapedRecipe((String)"glass_dust_hammer", (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTMaterials.Glass), (Object[])new Object[]{"hG", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_)});
        VanillaRecipeHelper.addShapedRecipe((String)"quartz_sand", (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTMaterials.QuartzSand), (Object[])new Object[]{"S", "m", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_49992_)});
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("quartz_sand_from_sand").inputItems((Object)Blocks.f_49992_).outputItems(TagPrefix.dust, GTMaterials.QuartzSand).duration(30).EUt(2L).save();
        VanillaRecipeHelper.addShapelessRecipe((String)"glass_dust_flint", (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTMaterials.Glass), (Object[])new Object[]{new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dustTiny, GTMaterials.Flint)});
        VanillaRecipeHelper.addShapelessRecipe((String)"glass_full_dust_flint", (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTMaterials.Glass, (int)8), (Object[])new Object[]{new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.QuartzSand), new MaterialEntry(TagPrefix.dust, GTMaterials.Flint)});
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("glass_from_quartzite").duration(160).EUt((long)GTValues.VA[0]).inputItems(TagPrefix.dustSmall, GTMaterials.Flint).inputItems(TagPrefix.dust, GTMaterials.Quartzite, 4).outputItems(TagPrefix.dust, GTMaterials.Glass, 5).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("full_dust_glass_from_quartzite").duration(640).EUt((long)GTValues.VA[0]).inputItems(TagPrefix.dust, GTMaterials.Flint).inputItems(TagPrefix.dust, GTMaterials.Quartzite, 16).outputItems(TagPrefix.dust, GTMaterials.Glass, 20).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("glass_from_quartz_sand").duration(200).EUt((long)GTValues.VA[0]).inputItems(TagPrefix.dustSmall, GTMaterials.Flint).inputItems(TagPrefix.dust, GTMaterials.QuartzSand, 4).outputItems(TagPrefix.dust, GTMaterials.Glass, 4).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("full_dust_glass_from_sand").duration(800).EUt((long)GTValues.VA[0]).inputItems(TagPrefix.dust, GTMaterials.Flint).inputItems(TagPrefix.dust, GTMaterials.QuartzSand, 16).outputItems(TagPrefix.dust, GTMaterials.Glass, 16).save();
        GTORecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder("glass_from_sand").duration(20).EUt((long)GTValues.VA[1]).inputItems(ItemTags.f_273858_).outputItems(Blocks.f_50058_, 2).save();
        GTORecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("form_glass").duration(80).EUt((long)GTValues.VA[1]).notConsumable((Supplier)GTItems.SHAPE_MOLD_BLOCK).inputItems(TagPrefix.dust, GTMaterials.Glass).outputItems((Object)Blocks.f_50058_).save();
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("glass_bottle").duration(64).EUt(4L).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier)GTItems.SHAPE_MOLD_BOTTLE).outputItems(Items.f_42590_).save();
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("glass_bottle").duration(32).EUt(16L).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_BOTTLE).outputItems(Items.f_42590_).save();
        GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("glass_bottle").duration(12).EUt(4L).inputFluids(GTMaterials.Glass.getFluid(144)).notConsumable((Supplier)GTItems.SHAPE_MOLD_BOTTLE).outputItems(Items.f_42590_).save();
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("glass").duration(120).EUt(16L).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier)GTItems.SHAPE_MOLD_BLOCK).outputItems((Object)Blocks.f_50058_).save();
        GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("glass_block_to_plate").duration(50).EUt((long)GTValues.VA[0]).inputItems(Blocks.f_50058_, 3).outputItems(Blocks.f_50185_, 8).save();
    }

    private static void smashingRecipes() {
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("cobblestone_to_gravel").inputItems(ItemTags.f_13166_).outputItems((Object)Blocks.f_49994_).EUt(16L).duration(10).save();
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("gravel_to_sand").inputItems((Object)Blocks.f_49994_).outputItems((Object)Blocks.f_49992_).EUt(16L).duration(10).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("gravel_to_flint").inputItems((Object)Blocks.f_49994_).outputItems(TagPrefix.dust, GTMaterials.Stone).chancedOutput(new ItemStack((ItemLike)Items.f_42484_), 1000, 1000).duration(400).EUt(2L).save();
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("sandstone_to_sand").inputItems((Object)Blocks.f_50062_).outputItems((Object)Blocks.f_49992_).EUt(2L).duration(400).save();
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("smooth_sandstone_to_sand").inputItems((Object)Blocks.f_50471_).outputItems((Object)Blocks.f_49992_).EUt(2L).duration(400).save();
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("chiseled_sandstone_to_sand").inputItems((Object)Blocks.f_50063_).outputItems((Object)Blocks.f_49992_).EUt(2L).duration(400).save();
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("red_sandstone_to_red_sand").inputItems((Object)Blocks.f_50394_).outputItems((Object)Blocks.f_49993_).EUt(2L).duration(400).save();
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("smooth_red_sandstone_to_red_sand").inputItems((Object)Blocks.f_50473_).outputItems((Object)Blocks.f_49993_).EUt(2L).duration(400).save();
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("chiseled_red_sandstone_to_red_sand").inputItems((Object)Blocks.f_50395_).outputItems((Object)Blocks.f_49993_).EUt(2L).duration(400).save();
        VanillaRecipeHelper.addShapelessRecipe((String)"clay_block_to_dust", (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTMaterials.Clay), (Object[])new Object[]{Character.valueOf('m'), Blocks.f_50129_});
        VanillaRecipeHelper.addShapelessRecipe((String)"clay_ball_to_dust", (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.dustSmall, (Material)GTMaterials.Clay), (Object[])new Object[]{Character.valueOf('m'), Items.f_42461_});
        VanillaRecipeHelper.addShapelessRecipe((String)"brick_block_to_dust", (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTMaterials.Brick), (Object[])new Object[]{Character.valueOf('m'), Blocks.f_50076_});
        VanillaRecipeHelper.addShapelessRecipe((String)"brick_to_dust", (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.dustSmall, (Material)GTMaterials.Brick), (Object[])new Object[]{Character.valueOf('m'), Items.f_42460_});
        VanillaRecipeHelper.addShapelessRecipe((String)"wheat_to_dust", (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)GTMaterials.Wheat), (Object[])new Object[]{Character.valueOf('m'), Items.f_42405_});
        VanillaRecipeHelper.addShapelessRecipe((String)"gravel_to_flint", (ItemStack)new ItemStack((ItemLike)Items.f_42484_), (Object[])new Object[]{Character.valueOf('m'), Blocks.f_49994_});
        VanillaRecipeHelper.addShapelessRecipe((String)"bone_to_bone_meal", (ItemStack)new ItemStack((ItemLike)Items.f_42499_, 4), (Object[])new Object[]{Character.valueOf('m'), Items.f_42500_});
        VanillaRecipeHelper.addShapelessRecipe((String)"blaze_rod_to_powder", (ItemStack)new ItemStack((ItemLike)Items.f_42593_, 3), (Object[])new Object[]{Character.valueOf('m'), Items.f_42585_});
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_cocoa").inputItems(Items.f_42533_).outputItems(TagPrefix.dust, GTMaterials.Cocoa).duration(400).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_sugar_cane").inputItems(Items.f_41909_).outputItems(Items.f_42501_).duration(400).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_melon_block").inputItems((Object)Blocks.f_50186_).outputItems(Items.f_42575_, 8).chancedOutput(new ItemStack((ItemLike)Items.f_42578_), 8000, 500).duration(400).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_pumpkin").inputItems((Object)Blocks.f_50133_).outputItems(Items.f_42577_, 4).duration(400).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_melon_slice").inputItems(Items.f_42575_).outputItems(Items.f_42578_).duration(400).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_wool").inputItems(ItemTags.f_13167_).outputItems(Items.f_42401_).chancedOutput(new ItemStack((ItemLike)Items.f_42401_), 9000, 0).chancedOutput(new ItemStack((ItemLike)Items.f_42401_), 5000, 0).chancedOutput(new ItemStack((ItemLike)Items.f_42401_), 2000, 0).duration(200).EUt(2L).save();
    }

    private static void woodRecipes() {
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_logs").inputItems(ItemTags.f_13182_).outputItems(TagPrefix.dust, GTMaterials.Wood, 6).chancedOutput(TagPrefix.dust, GTMaterials.Wood, 8000, 680).duration(150).EUt(2L).save();
        GTORecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_planks").inputItems(ItemTags.f_13168_).outputItems(Items.f_42398_, 2).duration(10).EUt((long)GTValues.VA[0]).save();
        GTORecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_saplings").inputItems(ItemTags.f_13180_).outputItems(Items.f_42398_).outputItems(TagPrefix.dustTiny, GTMaterials.Wood).duration(16).EUt((long)GTValues.VA[0]).save();
        GTORecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_wood_slabs").inputItems(ItemTags.f_13175_).outputItems(Items.f_42399_).outputItems(TagPrefix.dustSmall, GTMaterials.Wood).duration(50).EUt((long)GTValues.VA[0]).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bookshelf").inputItems(ItemTags.f_13168_, 6).inputItems(Items.f_42517_, 3).outputItems((Object)Blocks.f_50078_).duration(100).EUt(4L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chest").inputItems(ItemTags.f_13168_, 8).outputItems((Object)Blocks.f_50087_).duration(100).EUt(4L).circuitMeta(8).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_coal").inputItems(ItemTags.f_13160_).inputItems(Items.f_42398_).outputItems(Blocks.f_50081_, 4).duration(100).EUt(1L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_coal_dust").inputItems(TagPrefix.dust, GTMaterials.Coal).inputItems(Items.f_42398_).outputItems(Blocks.f_50081_, 4).duration(100).EUt(1L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_charcoal_dust").inputItems(TagPrefix.dust, GTMaterials.Charcoal).inputItems(Items.f_42398_).outputItems(Blocks.f_50081_, 4).duration(100).EUt(1L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_coke_gem").inputItems(TagPrefix.gem, GTMaterials.Coke).inputItems(Items.f_42398_).outputItems(Blocks.f_50081_, 8).duration(100).EUt(1L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_coke_dust").inputItems(TagPrefix.dust, GTMaterials.Coke).inputItems(Items.f_42398_).outputItems(Blocks.f_50081_, 8).duration(100).EUt(1L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("soul_torch").inputItems((Object)Blocks.f_50081_).inputItems(ItemTags.f_13154_).outputItems((Object)Blocks.f_50139_).duration(100).EUt(1L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("soul_lantern_from_lantern").inputItems((Object)Blocks.f_50681_).inputItems(ItemTags.f_13154_).outputItems((Object)Blocks.f_50682_).duration(100).EUt(1L).save();
        VanillaRecipeHelper.addShapedRecipe((String)"sticky_resin_torch", (ItemStack)new ItemStack((ItemLike)Blocks.f_50081_), (Object[])new Object[]{3, "X", "Y", Character.valueOf('X'), GTItems.STICKY_RESIN, Character.valueOf('Y'), new ItemStack((ItemLike)Items.f_42398_)});
        VanillaRecipeHelper.addShapedRecipe((String)"torch_sulfur", (ItemStack)new ItemStack((ItemLike)Blocks.f_50081_), (Object[])new Object[]{2, "C", "S", Character.valueOf('C'), new MaterialEntry(TagPrefix.dust, GTMaterials.Sulfur), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_)});
        VanillaRecipeHelper.addShapedRecipe((String)"torch_phosphorus", (ItemStack)new ItemStack((ItemLike)Blocks.f_50081_), (Object[])new Object[]{6, "C", "S", Character.valueOf('C'), new MaterialEntry(TagPrefix.dust, GTMaterials.Phosphorus), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_)});
        VanillaRecipeHelper.addShapedRecipe((String)"torch_coal_dust", (ItemStack)new ItemStack((ItemLike)Blocks.f_50081_), (Object[])new Object[]{4, "C", "S", Character.valueOf('C'), new MaterialEntry(TagPrefix.dust, GTMaterials.Coal), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_)});
        VanillaRecipeHelper.addShapedRecipe((String)"torch_charcoal_dust", (ItemStack)new ItemStack((ItemLike)Blocks.f_50081_), (Object[])new Object[]{4, "C", "S", Character.valueOf('C'), new MaterialEntry(TagPrefix.dust, GTMaterials.Charcoal), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_)});
        VanillaRecipeHelper.addShapedRecipe((String)"torch_coke", (ItemStack)new ItemStack((ItemLike)Blocks.f_50081_), (Object[])new Object[]{8, "C", "S", Character.valueOf('C'), new MaterialEntry(TagPrefix.gem, GTMaterials.Coke), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_)});
        VanillaRecipeHelper.addShapedRecipe((String)"torch_coke_dust", (ItemStack)new ItemStack((ItemLike)Blocks.f_50081_), (Object[])new Object[]{8, "C", "S", Character.valueOf('C'), new MaterialEntry(TagPrefix.dust, GTMaterials.Coke), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_)});
        VanillaRecipeHelper.addShapedFluidContainerRecipe((String)"torch_creosote", (ItemStack)new ItemStack((ItemLike)Blocks.f_50081_), (Object[])new Object[]{16, "WB", "S ", Character.valueOf('W'), ItemTags.f_13167_, Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_), Character.valueOf('B'), new FluidContainerIngredient(GTMaterials.Creosote.getFluid(1000))});
        VanillaRecipeHelper.addShapedRecipe((String)"soul_torch", (ItemStack)new ItemStack((ItemLike)Blocks.f_50139_), (Object[])new Object[]{1, "WB", Character.valueOf('W'), ItemTags.f_13154_, Character.valueOf('B'), new ItemStack((ItemLike)Blocks.f_50081_)});
        if (!ConfigHolder.INSTANCE.recipes.hardMiscRecipes) {
            VanillaRecipeHelper.addShapedRecipe((String)"soul_lantern_from_lantern", (ItemStack)new ItemStack((ItemLike)Blocks.f_50682_), (Object[])new Object[]{1, "WB", Character.valueOf('W'), ItemTags.f_13154_, Character.valueOf('B'), new ItemStack((ItemLike)Blocks.f_50681_)});
        }
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("redstone_torch").EUt(4L).inputItems(TagPrefix.dust, GTMaterials.Redstone).inputItems(Items.f_42398_).outputItems((Object)Blocks.f_50174_).circuitMeta(3).duration(100).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_sulfur").EUt(4L).inputItems(Items.f_42398_).inputItems(TagPrefix.dust, GTMaterials.Sulfur).outputItems(Blocks.f_50081_, 2).duration(100).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_phosphorus").EUt(4L).inputItems(Items.f_42398_).inputItems(TagPrefix.dust, GTMaterials.Phosphorus).outputItems(Blocks.f_50081_, 6).duration(100).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("ladder").EUt(4L).duration(40).circuitMeta(7).inputItems(Items.f_42398_, 7).outputItems(Blocks.f_50155_, 2).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("barrel").inputItems(ItemTags.f_13168_, 7).outputItems((Object)Blocks.f_50618_).circuitMeta(24).duration(100).EUt(4L).save();
    }

    private static void cuttingRecipes() {
        GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("snow_layer").inputItems((Object)Blocks.f_50127_).outputItems(Blocks.f_50125_, 12).duration(25).EUt((long)GTValues.VA[0]).save();
    }

    private static void dyingCleaningRecipes() {
        for (DyeColor color : DyeColor.values()) {
            String dyeName = color.m_41065_();
            GTORecipeTypes.MIXER_RECIPES.recipeBuilder(dyeName + "_concrete_powder").duration(200).EUt((long)GTValues.VA[0]).inputItems(Tags.Items.SAND, 4).inputItems(Tags.Items.GRAVEL, 4).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(144)).outputItems(RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_concrete_powder"))), 8).save();
            GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder(dyeName + "_concrete").duration(20).EUt((long)GTValues.VA[0]).inputItems(RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_concrete_powder")))).inputFluids(GTMaterials.Water, 1000).outputItems(RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_concrete")))).category(GTRecipeCategories.CHEM_DYES).save();
            if (color != DyeColor.WHITE) {
                GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_concrete_to_" + dyeName).duration(20).EUt((long)GTValues.VA[0]).inputItems(CustomTags.CONCRETE_ITEM).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_concrete"))))).category(GTRecipeCategories.CHEM_DYES).save();
            }
            GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_terracotta_to_" + dyeName).duration(20).EUt((long)GTValues.VA[0]).inputItems((Object)Blocks.f_50352_).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_terracotta"))))).category(GTRecipeCategories.CHEM_DYES).save();
            GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_glass_to_" + dyeName).duration(20).EUt((long)GTValues.VA[0]).inputItems((Object)Blocks.f_50058_).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_stained_glass"))))).category(GTRecipeCategories.CHEM_DYES).save();
            GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_glass_pane_to_" + dyeName).duration(20).EUt((long)GTValues.VA[0]).inputItems((Object)Blocks.f_50185_).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_stained_glass_pane")))).category(GTRecipeCategories.CHEM_DYES).save();
            GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + dyeName + "_glass_to_pane").duration(20).EUt((long)GTValues.VA[0]).inputItems(RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_stained_glass"))), 3).outputItems(RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_stained_glass_pane"))), 8).save();
            GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_candle_to_" + dyeName).duration(20).EUt((long)GTValues.VA[0]).inputItems(Items.f_151065_).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_candle")))).category(GTRecipeCategories.CHEM_DYES).save();
            if (color != DyeColor.WHITE) {
                GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_wool_to_" + dyeName).duration(20).EUt((long)GTValues.VA[0]).inputItems((Object)Blocks.f_50041_).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(144)).outputItems(RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_wool")))).category(GTRecipeCategories.CHEM_DYES).save();
                GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_bed_to_" + dyeName).duration(20).EUt((long)GTValues.VA[0]).inputItems((Object)Blocks.f_50066_).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(144)).outputItems(RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_bed")))).category(GTRecipeCategories.CHEM_DYES).save();
            }
            GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + dyeName + "_wool_to_carpet").duration(20).EUt((long)GTValues.VA[0]).inputItems(RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_wool")))).outputItems(new ItemStack((ItemLike)RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_carpet"))), 2)).save();
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(dyeName + "_banner").duration(20).EUt((long)GTValues.VA[0]).circuitMeta(6).inputItems(Items.f_42398_).inputItems(RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_wool"))), 6).outputItems(RegistriesUtils.getItem((ResourceLocation)RLUtils.mc((String)(dyeName + "_banner")))).save();
        }
        GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_wool").inputItems(ItemTags.f_13167_).inputFluids(GTMaterials.Chlorine, 50).outputItems((Object)Blocks.f_50041_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save();
        GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_carpet").inputItems(ItemTags.f_215867_).inputFluids(GTMaterials.Chlorine, 25).outputItems((Object)Blocks.f_50336_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save();
        GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_terracotta").inputItems(ItemTags.f_198161_).inputFluids(GTMaterials.Chlorine, 50).outputItems(Items.f_42199_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save();
        GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_stained_glass").inputItems(Tags.Items.STAINED_GLASS).inputFluids(GTMaterials.Chlorine, 50).outputItems(Items.f_41904_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save();
        GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_stained_glass_pane").inputItems(Tags.Items.STAINED_GLASS_PANES).inputFluids(GTMaterials.Chlorine, 20).outputItems(Items.f_42027_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save();
        GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_concrete").inputItems(CustomTags.CONCRETE_ITEM).inputFluids(GTMaterials.Chlorine, 20).outputItems(Items.f_42246_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save();
        GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("sticky_piston_to_piston").inputItems((Object)Blocks.f_50032_).inputFluids(GTMaterials.Chlorine, 10).outputItems((Object)Blocks.f_50039_).duration(30).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_candle").inputItems(ItemTags.f_144319_).inputFluids(GTMaterials.Chlorine, 20).outputItems(Items.f_151065_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save();
        GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_bed").inputItems(ItemTags.f_13146_).inputFluids(GTMaterials.Chlorine, 20).outputItems(Items.f_42503_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save();
    }

    private static void redstoneRecipes() {
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("sticky_piston_resin").inputItems((Supplier)GTItems.STICKY_RESIN).inputItems((Object)Blocks.f_50039_).outputItems((Object)Blocks.f_50032_).duration(100).EUt(4L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("sticky_piston_slime").inputItems(Items.f_42518_).inputItems((Object)Blocks.f_50039_).outputItems((Object)Blocks.f_50032_).duration(100).EUt(4L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("sticky_piston_glue").inputItems((Object)Blocks.f_50039_).inputFluids(GTMaterials.Glue, 100).outputItems((Object)Blocks.f_50032_).duration(100).EUt(4L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tripwire_hook_iron").inputItems(Items.f_42398_, 2).inputItems(TagPrefix.ring, GTMaterials.Iron, 2).outputItems((Object)Blocks.f_50266_).duration(100).EUt(4L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tripwire_hook_wrought_iron").inputItems(Items.f_42398_, 2).inputItems(TagPrefix.ring, GTMaterials.WroughtIron, 2).outputItems((Object)Blocks.f_50266_).duration(100).EUt(4L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("redstone_lamp").inputItems(TagPrefix.dust, GTMaterials.Redstone, 4).inputItems(TagPrefix.dust, GTMaterials.Glowstone, 4).outputItems((Object)Blocks.f_50261_).duration(100).EUt(1L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("repeater").inputItems(Blocks.f_50174_, 2).inputItems(TagPrefix.dust, GTMaterials.Redstone).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(Items.f_42350_).duration(100).EUt(10L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("comparator_nether_quartz").inputItems(Blocks.f_50174_, 3).inputItems(TagPrefix.gem, GTMaterials.NetherQuartz).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(Items.f_42351_).duration(100).EUt(1L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("comparator_certus_quartz").inputItems(Blocks.f_50174_, 3).inputItems(TagPrefix.gem, GTMaterials.CertusQuartz).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(Items.f_42351_).duration(100).EUt(1L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("comparator_quartzite").inputItems(Blocks.f_50174_, 3).inputItems(TagPrefix.gem, GTMaterials.Quartzite).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(Items.f_42351_).duration(100).EUt(1L).save();
        if (!ConfigHolder.INSTANCE.recipes.hardRedstoneRecipes) {
            GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("stone_pressure_plate").inputItems((Object)Blocks.f_50404_).circuitMeta(26).outputItems(Blocks.f_50165_, 8).duration(250).EUt((long)GTValues.VA[0]).save();
            GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("polished_blackstone_pressure_plate").inputItems((Object)Blocks.f_50708_).outputItems(Blocks.f_50709_, 8).duration(250).EUt((long)GTValues.VA[0]).save();
        }
    }

    private static void metalRecipes() {
        VanillaRecipeHelper.addShapedRecipe((String)"leather_horse_armor", (ItemStack)new ItemStack((ItemLike)Items.f_42654_), (Object[])new Object[]{"hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((ItemLike)Items.f_42407_), Character.valueOf('P'), new ItemStack((ItemLike)Items.f_42454_), Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42408_), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42462_), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron)});
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"iron_horse_armor", (ItemStack)new ItemStack((ItemLike)Items.f_42651_), (Object[])new Object[]{"hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((ItemLike)Items.f_42468_), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42469_), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42470_), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron)});
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"golden_horse_armor", (ItemStack)new ItemStack((ItemLike)Items.f_42652_), (Object[])new Object[]{"hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((ItemLike)Items.f_42476_), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42477_), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42478_), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Gold)});
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"diamond_horse_armor", (ItemStack)new ItemStack((ItemLike)Items.f_42653_), (Object[])new Object[]{"hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((ItemLike)Items.f_42472_), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Diamond), Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42473_), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42474_), Character.valueOf('S'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Diamond)});
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"chainmail_helmet", (ItemStack)new ItemStack((ItemLike)Items.f_42464_), (Object[])new Object[]{"PPP", "PhP", Character.valueOf('P'), Items.f_42026_});
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"chainmail_chestplate", (ItemStack)new ItemStack((ItemLike)Items.f_42465_), (Object[])new Object[]{"PhP", "PPP", "PPP", Character.valueOf('P'), Items.f_42026_});
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"chainmail_leggings", (ItemStack)new ItemStack((ItemLike)Items.f_42466_), (Object[])new Object[]{"PPP", "PhP", "P P", Character.valueOf('P'), Items.f_42026_});
        VanillaRecipeHelper.addShapedRecipe((boolean)true, (String)"chainmail_boots", (ItemStack)new ItemStack((ItemLike)Items.f_42467_), (Object[])new Object[]{"P P", "PhP", Character.valueOf('P'), Items.f_42026_});
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cauldron").inputItems(TagPrefix.plate, GTMaterials.Iron, 7).outputItems(Items.f_42544_).circuitMeta(7).duration(700).EUt(4L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("iron_bars").inputItems(TagPrefix.rod, GTMaterials.Iron, 3).outputItems(Blocks.f_50183_, 4).circuitMeta(3).duration(300).EUt(4L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("iron_trapdoor").inputItems(TagPrefix.plate, GTMaterials.Iron, 4).circuitMeta(16).outputItems((Object)Blocks.f_50376_).duration(100).EUt(16L).save();
        if (!ConfigHolder.INSTANCE.recipes.hardAdvancedIronRecipes) {
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("iron_door").inputItems(TagPrefix.plate, GTMaterials.Iron, 6).circuitMeta(6).outputItems(Items.f_42341_, 3).duration(100).EUt(16L).save();
        }
    }

    private static void miscRecipes() {
        if (ConfigHolder.INSTANCE.recipes.hardToolArmorRecipes) {
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fishing_rod").inputItems(Items.f_42401_).inputItems(TagPrefix.rodLong, GTMaterials.Wood, 2).inputItems(TagPrefix.ring, GTMaterials.Iron).outputItems(Items.f_42523_).circuitMeta(16).duration(100).EUt(4L).save();
        } else {
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fishing_rod").inputItems(Items.f_42401_, 2).inputItems(TagPrefix.rod, GTMaterials.Wood, 3).outputItems(Items.f_42523_).circuitMeta(16).duration(100).EUt(4L).save();
        }
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("book_from_leather").inputItems(Items.f_42516_, 3).inputItems(Items.f_42454_).inputFluids(GTMaterials.Glue, 20).outputItems(Items.f_42517_).duration(32).EUt((long)GTValues.VA[0]).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("book_from_pvc").inputItems(Items.f_42516_, 3).inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride).inputFluids(GTMaterials.Glue, 20).outputItems(Items.f_42517_).duration(20).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("map").inputItems(Items.f_42516_, 8).inputItems(Items.f_42522_).outputItems(Items.f_42676_).duration(100).EUt((long)GTValues.VA[0]).save();
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("form_nether_brick").inputItems(TagPrefix.dust, GTMaterials.Netherrack).notConsumable((Supplier)GTItems.SHAPE_MOLD_INGOT).outputItems(Items.f_42691_).duration(200).EUt(2L).save();
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("form_brick").inputItems(Items.f_42461_).notConsumable((Supplier)GTItems.SHAPE_MOLD_INGOT).outputItems(Items.f_42460_).duration(200).EUt(2L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lead").inputItems(Items.f_42401_).inputItems(Items.f_42518_).outputItems(Items.f_42655_, 2).duration(100).EUt(2L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("name_tag").inputItems(Items.f_42454_).inputItems(Items.f_42655_).inputFluids(GTMaterials.Glue, 100).outputItems(Items.f_42656_).duration(100).EUt((long)GTValues.VA[0]).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bow").inputItems(Items.f_42401_, 3).inputItems(Items.f_42398_, 3).outputItems(Items.f_42411_).circuitMeta(10).duration(100).EUt(4L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crossbow").inputItems(Items.f_42401_, 2).inputItems(Items.f_42398_, 3).inputItems(Items.f_42109_).outputItems(Items.f_42717_).circuitMeta(11).duration(100).EUt(4L).save();
        GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("snowball").duration(128).EUt(4L).notConsumable((Supplier)GTItems.SHAPE_MOLD_BALL).inputFluids(GTMaterials.Water, 250).outputItems(Items.f_42452_).save();
        GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("snowball_distilled").duration(128).EUt(4L).notConsumable((Supplier)GTItems.SHAPE_MOLD_BALL).inputFluids(GTMaterials.DistilledWater, 250).outputItems(Items.f_42452_).save();
        GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("snow_block").duration(512).EUt(4L).notConsumable((Supplier)GTItems.SHAPE_MOLD_BLOCK).inputFluids(GTMaterials.Water, 1000).outputItems((Object)Blocks.f_50127_).save();
        GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("snow_block_distilled").duration(512).EUt(4L).notConsumable((Supplier)GTItems.SHAPE_MOLD_BLOCK).inputFluids(GTMaterials.DistilledWater, 1000).outputItems((Object)Blocks.f_50127_).save();
        GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("obsidian").duration(1024).EUt(16L).notConsumable((Supplier)GTItems.SHAPE_MOLD_BLOCK).inputFluids(GTMaterials.Lava, 1000).outputItems((Object)Blocks.f_50080_).save();
        GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_anvil").duration(1680).EUt(16L).notConsumable((Supplier)GTItems.SHAPE_MOLD_ANVIL).inputFluids(GTMaterials.Iron.getFluid(4464)).outputItems((Object)Blocks.f_50322_).save();
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("anvil").inputItems(TagPrefix.ingot, GTMaterials.Iron, 31).notConsumable((Supplier)GTItems.SHAPE_MOLD_ANVIL).outputItems((Object)Blocks.f_50322_).duration(1680).EUt(16L).save();
        VanillaRecipeHelper.addSmeltingRecipe((String)"sticky_resin_from_slime", (ItemStack)new ItemStack((ItemLike)Items.f_42518_), (ItemStack)GTItems.STICKY_RESIN.asStack(), (float)0.3f);
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("mossy_cobblestone_from_vine").inputItems((Object)Blocks.f_50652_).inputItems((Object)Blocks.f_50191_).inputFluids(GTMaterials.Water, 250).outputItems((Object)Blocks.f_50079_).duration(40).EUt(1L).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("mossy_cobblestone_from_moss_block").inputItems((Object)Blocks.f_50652_).inputItems((Object)Blocks.f_152544_).inputFluids(GTMaterials.Water, 250).outputItems((Object)Blocks.f_50079_).duration(40).EUt(1L).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("mossy_stone_bricks_from_vine").inputItems((Object)Blocks.f_50222_).inputItems((Object)Blocks.f_50191_).inputFluids(GTMaterials.Water, 250).outputItems((Object)Blocks.f_50223_).duration(40).EUt(1L).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("mossy_stone_bricks_from_moss_block").inputItems((Object)Blocks.f_50222_).inputItems((Object)Blocks.f_152544_).inputFluids(GTMaterials.Water, 250).outputItems((Object)Blocks.f_50223_).duration(40).EUt(1L).save();
        GTORecipeTypes.CANNER_RECIPES.recipeBuilder("jack_o_lantern").EUt(4L).duration(100).inputItems((Object)Blocks.f_50133_).inputItems((Object)Blocks.f_50081_).outputItems((Object)Blocks.f_50144_).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("sea_lantern").EUt(4L).duration(40).inputItems(Items.f_42696_, 5).inputItems(Items.f_42695_, 4).outputItems((Object)Blocks.f_50386_).save();
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("red_nether_bricks").EUt(4L).duration(40).inputItems(Items.f_42691_, 2).inputItems(Items.f_42588_, 2).outputItems((Object)Blocks.f_50452_).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("nether_brick_fence").duration(100).EUt(4L).circuitMeta(3).inputItems((Object)Blocks.f_50197_).outputItems((Object)Blocks.f_50198_).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("end_rod").duration(100).EUt(4L).inputItems(Items.f_42731_).inputItems(Items.f_42585_).outputItems(Blocks.f_50489_, 4).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("shulker_box").duration(100).EUt((long)GTValues.VA[0]).inputItems(Tags.Items.CHESTS_WOODEN).inputItems(Items.f_42748_, 2).outputItems((Object)Blocks.f_50456_).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("painting").duration(100).EUt(4L).circuitMeta(1).inputItems(ItemTags.f_13167_).inputItems(Items.f_42398_, 8).outputItems(Items.f_42487_).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("item_frame").duration(100).EUt(4L).inputItems(Items.f_42454_).inputItems(Items.f_42398_, 8).outputItems(Items.f_42617_).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("flower_pot").duration(10).EUt(2L).inputItems(Items.f_42460_, 3).outputItems(Items.f_42618_).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("end_crystal").duration(30).EUt(16L).inputItems(Items.f_42586_).inputItems(Items.f_42545_).inputFluids(GTMaterials.Glass.getFluid(1008)).outputItems(Items.f_42729_).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("rail").inputItems(TagPrefix.rod, GTMaterials.Iron, 12).inputItems(Items.f_42398_).circuitMeta(1).outputItems(Blocks.f_50156_, 32).duration(100).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("powered_rail").inputItems(TagPrefix.rod, GTMaterials.Gold, 12).inputItems(Items.f_42398_).inputItems(TagPrefix.dust, GTMaterials.Redstone).circuitMeta(1).outputItems(Blocks.f_50030_, 12).duration(100).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("detector_rail").inputItems(TagPrefix.rod, GTMaterials.Iron, 12).inputItems(Items.f_42398_).inputItems(TagPrefix.dust, GTMaterials.Redstone).circuitMeta(5).outputItems(Blocks.f_50031_, 12).duration(100).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("activator_rail").inputItems(TagPrefix.rod, GTMaterials.Iron, 12).inputItems(Items.f_42398_, 2).inputItems((Object)Blocks.f_50174_).circuitMeta(5).outputItems(Blocks.f_50285_, 12).duration(100).EUt((long)GTValues.VA[1]).save();
        VanillaRecipeHelper.addShapedRecipe((String)"saddle", (ItemStack)new ItemStack((ItemLike)Items.f_42450_), (Object[])new Object[]{"LLL", "LCL", "RSR", Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42454_), Character.valueOf('C'), ItemTags.f_215867_, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_)});
        GTORecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("clay_from_dust").inputItems(TagPrefix.dust, GTMaterials.Clay).inputFluids(GTMaterials.Water, 250).outputItems(Items.f_42461_).duration(600).EUt(24L).save();
        GTORecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("clay_from_dust_distilled").inputItems(TagPrefix.dust, GTMaterials.Clay).inputFluids(GTMaterials.DistilledWater, 250).outputItems(Items.f_42461_).duration(300).EUt(24L).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("redstone_block").inputItems(TagPrefix.dust, GTMaterials.Redstone, 9).outputItems((Object)Blocks.f_50330_).duration(300).EUt(2L).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("bone_block").inputItems(TagPrefix.dust, GTMaterials.Bone, 9).outputItems((Object)Blocks.f_50453_).duration(300).EUt(2L).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("purpur_block").inputItems(Items.f_42731_, 4).outputItems(Blocks.f_50492_, 4).duration(300).EUt(2L).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("magma_block").inputItems(Items.f_42542_, 4).outputItems((Object)Blocks.f_50450_).duration(300).EUt(2L).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("slime_block").inputItems(Items.f_42518_, 9).outputItems((Object)Blocks.f_50374_).duration(300).EUt(2L).save();
        GTORecipeTypes.PACKER_RECIPES.recipeBuilder("nether_wart_block").inputItems(Items.f_42588_, 9).circuitMeta(9).outputItems((Object)Blocks.f_50451_).duration(200).EUt(2L).save();
        GTORecipeTypes.PACKER_RECIPES.recipeBuilder("prismarine").inputItems(Items.f_42695_, 4).circuitMeta(4).outputItems((Object)Blocks.f_50377_).duration(100).EUt(2L).save();
        GTORecipeTypes.PACKER_RECIPES.recipeBuilder("prismarine_bricks").inputItems(Items.f_42695_, 9).circuitMeta(9).outputItems((Object)Blocks.f_50378_).duration(200).EUt(2L).save();
        GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("eye_of_ender").inputFluids(GTMaterials.Blaze.getFluid(144)).inputItems(TagPrefix.gem, GTMaterials.EnderPearl).outputItems(Items.f_42545_).duration(50).EUt((long)GTValues.VA[3]).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("blaze_rod").inputItems(TagPrefix.dust, GTMaterials.Blaze, 4).outputItems(Items.f_42585_).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("mud_to_clay").inputItems(Items.f_220216_).outputItems(Items.f_41983_).duration(40).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("ender_chest").duration(100).EUt(4L).inputItems(Blocks.f_50080_, 8).inputItems(Items.f_42545_).outputItems((Object)Blocks.f_50265_).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("armor_stand").duration(30).EUt((long)GTValues.VA[0]).inputItems((Object)Blocks.f_50405_).inputItems(Items.f_42398_, 6).outputItems(Items.f_42650_).save();
        GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("candle").inputFluids(GTMaterials.Wax.getFluid(144)).inputItems(Items.f_42401_).outputItems(Blocks.f_152482_, 2).duration(20).EUt(1L).save();
        GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("disc_fragment_5").inputItems(Items.f_220217_).outputItems(Items.f_220218_, 9).duration(100).EUt(6L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chest_minecart").EUt(4L).duration(100).inputItems(Items.f_42449_).inputItems(Tags.Items.CHESTS_WOODEN).outputItems(Items.f_42519_).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("furnace_minecart").EUt(4L).duration(100).inputItems(Items.f_42449_).inputItems((Object)Blocks.f_50094_).outputItems(Items.f_42520_).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tnt_minecart").EUt(4L).duration(100).inputItems(Items.f_42449_).inputItems((Object)Blocks.f_50077_).outputItems(Items.f_42693_).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hopper_minecart").EUt(4L).duration(100).inputItems(Items.f_42449_).inputItems((Object)Blocks.f_50332_).outputItems(Items.f_42694_).save();
        VanillaRecipeHelper.addShapelessRecipe((String)"hay_block_to_hay", (ItemStack)new ItemStack((ItemLike)Items.f_42405_, 9), (Object[])new Object[]{Items.f_42129_, Character.valueOf('k')});
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("conduit").inputItems(Items.f_42716_).inputItems(Items.f_42715_, 8).outputItems((Object)Blocks.f_50569_).duration(200).EUt(16L).save();
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("granite").inputItems(Items.f_42064_).inputItems(Items.f_42692_).outputItems(Items.f_41958_).duration(80).EUt(4L).save();
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("diorite").inputItems(Items.f_42594_, 2).inputItems(Items.f_42692_, 2).outputItems(Items.f_42064_, 2).duration(80).EUt(4L).save();
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("andesite").inputItems(Items.f_42064_).inputItems(Items.f_42594_).outputItems(Items.f_42170_, 2).duration(80).EUt(4L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_block_of_quartz_into_quartz_pillar").inputItems(Items.f_42157_).circuitMeta(5).outputItems(Items.f_42159_).duration(80).EUt(1L).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("packed_mud").inputItems(Items.f_220216_).inputItems(Items.f_42405_).outputItems(Items.f_220185_).duration(80).EUt(4L).save();
    }

    private static void mixingRecipes() {
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("fire_charge").inputItems(TagPrefix.dust, GTMaterials.Coal).inputItems(TagPrefix.dust, GTMaterials.Gunpowder).inputItems(TagPrefix.dust, GTMaterials.Blaze).outputItems(Items.f_42613_, 3).duration(100).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("coarse_dirt").inputItems((Object)Blocks.f_49994_).inputItems((Object)Blocks.f_50493_).outputItems(Blocks.f_50546_, 2).duration(100).EUt(4L).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("mud").inputItems((Object)Blocks.f_50493_).circuitMeta(1).inputFluids(GTMaterials.Water.getFluid(144)).outputItems((Object)Blocks.f_220864_).duration(100).EUt(4L).save();
    }

    private static void dyeRecipes() {
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("poppy_dye").inputItems((Object)Blocks.f_50112_).outputItems(Items.f_42497_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("blue_orchid_dye").inputItems((Object)Blocks.f_50113_).outputItems(Items.f_42538_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("allium_dye").inputItems((Object)Blocks.f_50114_).outputItems(Items.f_42537_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("azure_bluet_dye").inputItems((Object)Blocks.f_50115_).outputItems(Items.f_42491_).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("red_tulip_dye").inputItems((Object)Blocks.f_50116_).outputItems(Items.f_42497_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("orange_tulip_dye").inputItems((Object)Blocks.f_50117_).outputItems(Items.f_42536_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("white_tulip_dye").inputItems((Object)Blocks.f_50118_).outputItems(Items.f_42491_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("pink_tulip_dye").inputItems((Object)Blocks.f_50119_).outputItems(Items.f_42489_).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("oxeye_daisy_dye").inputItems((Object)Blocks.f_50120_).outputItems(Items.f_42491_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("dandelion_dye").inputItems((Object)Blocks.f_50111_).outputItems(Items.f_42539_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("cornflower_dye").inputItems((Object)Blocks.f_50121_).outputItems(Items.f_42494_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("lily_of_the_valley_dye").inputItems((Object)Blocks.f_50071_).outputItems(Items.f_42535_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("wither_rose_dye").inputItems((Object)Blocks.f_50070_).outputItems(Items.f_42498_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("sunflower_dye").inputItems((Object)Blocks.f_50355_).outputItems(Items.f_42539_, 3).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("lilac_dye").inputItems((Object)Blocks.f_50356_).outputItems(Items.f_42537_, 3).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("rose_bush_dye").inputItems((Object)Blocks.f_50357_).outputItems(Items.f_42497_, 3).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("peony_dye").inputItems((Object)Blocks.f_50358_).outputItems(Items.f_42489_, 3).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("beetroot_dye").inputItems(Items.f_42732_).outputItems(Items.f_42497_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("torchflower_dye").inputItems(Items.f_271471_).outputItems(Items.f_42536_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("pitcher_dye").inputItems(Items.f_276698_).outputItems(Items.f_42492_, 3).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("pink_petals_dye").inputItems(Items.f_271209_).outputItems(Items.f_42489_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("sea_pickle_dye").inputItems(Items.f_41868_).outputItems(Items.f_42540_, 2).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("white_dye").inputItems(Items.f_42499_).outputItems(Items.f_42535_).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("lapis_dye").inputItems(Items.f_42534_).outputItems(Items.f_42494_).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("ink_dye").inputItems(Items.f_42532_).outputItems(Items.f_42498_).save();
        GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dark_prismarine").inputItems(Items.f_42695_, 4).inputFluids(GTMaterials.DyeBlack.getFluid(144)).outputItems((Object)Blocks.f_50379_).duration(20).EUt((long)GTValues.VA[0]).save();
    }
}

