/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.gtm.misc;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GCYMBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gtocore.common.data.GTORecipeTypes;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class GCYMRecipes {
    private GCYMRecipes() {
    }

    public static void init() {
        GCYMRecipes.registerManualRecipes();
        GCYMRecipes.registerMachineRecipes();
    }

    private static void registerManualRecipes() {
        GCYMRecipes.registerFormulaic();
        GCYMRecipes.registerManual();
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("graphene_to_foil").inputItems(TagPrefix.dust, GTMaterials.Graphene).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_FOIL).outputItems(TagPrefix.foil, GTMaterials.Graphene, 4).duration((int)GTMaterials.Graphene.getMass()).EUt(24L).save();
        GTORecipeTypes.ELECTROPLATING_RECIPES.recipeBuilder("palladium_plating").inputItems(TagPrefix.plate, GTMaterials.Palladium, 6).inputItems(TagPrefix.plateDouble, GTMaterials.Rhodium, 1).inputItems(TagPrefix.dust, GTMaterials.AmmoniumChloride, 2).inputFluids(GTMaterials.NitricAcid, 1000).outputItems(TagPrefix.ingot, GTMaterials.RhodiumPlatedPalladium, 8).outputFluids(GTMaterials.DilutedHydrochloricAcid, 1000).duration(2400).EUt((long)GTValues.VA[5]).save();
    }

    private static void registerMachineRecipes() {
        GCYMRecipes.registerAssemblerRecipes();
        GCYMRecipes.registerMixerRecipes();
    }

    private static void registerAssemblerRecipes() {
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crushing_wheels").inputItems(TagPrefix.gearSmall, GTMaterials.TungstenCarbide, 2).inputItems(TagPrefix.gear, GTMaterials.Ultimet, 3).inputItems(GCYMBlocks.CASING_SECURE_MACERATION.m_5456_()).inputItems(GTItems.ELECTRIC_MOTOR_IV.m_5456_()).outputItems(GCYMBlocks.CRUSHING_WHEELS.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("slicing_blades").inputItems(TagPrefix.plate, GTMaterials.TungstenCarbide, 2).inputItems(TagPrefix.gear, GTMaterials.Ultimet, 3).inputItems(GCYMBlocks.CASING_SHOCK_PROOF.m_5456_()).inputItems(GTItems.ELECTRIC_MOTOR_IV.m_5456_()).outputItems(GCYMBlocks.SLICING_BLADES.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("electrolytic_cell").inputItems(TagPrefix.wireGtDouble, GTMaterials.Platinum, 4).inputItems(TagPrefix.cableGtSingle, GTMaterials.Tungsten, 1).inputItems(GCYMBlocks.CASING_NONCONDUCTING.m_5456_()).inputItems(CustomTags.IV_CIRCUITS).outputItems(GCYMBlocks.ELECTROLYTIC_CELL.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("mds_coil_block").inputItems(TagPrefix.ring, GTMaterials.MolybdenumDisilicide, 32).inputItems(TagPrefix.foil, GTMaterials.Graphene, 16).inputFluids(GTMaterials.HSLASteel, 144).outputItems(GCYMBlocks.MOLYBDENUM_DISILICIDE_COIL_BLOCK.m_5456_(), 1).duration(500).EUt(1920L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("heat_vent").inputItems(TagPrefix.plate, GTMaterials.TantalumCarbide, 3).inputItems(TagPrefix.plateDouble, GTMaterials.MolybdenumDisilicide, 2).inputItems(TagPrefix.rotor, GTMaterials.Titanium, 1).inputItems(TagPrefix.rodLong, GTMaterials.MolybdenumDisilicide, 1).outputItems(GCYMBlocks.HEAT_VENT.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_hsla_nonconducting").inputItems(TagPrefix.plate, GTMaterials.HSLASteel, 6).inputItems(TagPrefix.frameGt, GTMaterials.HSLASteel).circuitMeta(6).outputItems(GCYMBlocks.CASING_NONCONDUCTING.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_incoloy_vibration_safe").inputItems(TagPrefix.plate, GTMaterials.IncoloyMA956, 6).inputItems(TagPrefix.frameGt, GTMaterials.IncoloyMA956).circuitMeta(6).outputItems(GCYMBlocks.CASING_VIBRATION_SAFE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).EUt(16L).duration(50).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_watertight").inputItems(TagPrefix.plate, GTMaterials.WatertightSteel, 6).inputItems(TagPrefix.frameGt, GTMaterials.WatertightSteel).circuitMeta(6).outputItems(GCYMBlocks.CASING_WATERTIGHT.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_secure_maceration").inputItems(TagPrefix.plate, GTMaterials.Zeron100, 6).inputItems(TagPrefix.frameGt, GTMaterials.Titanium).circuitMeta(6).outputItems(GCYMBlocks.CASING_SECURE_MACERATION.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).EUt(16L).duration(50).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_high_temperature_smelting").inputItems(TagPrefix.plate, GTMaterials.TitaniumCarbide, 4).inputItems(TagPrefix.plate, GTMaterials.HSLASteel, 2).inputItems(TagPrefix.frameGt, GTMaterials.TungstenCarbide).circuitMeta(6).outputItems(GCYMBlocks.CASING_HIGH_TEMPERATURE_SMELTING.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_reaction_safe_mixing").inputItems(TagPrefix.plate, GTMaterials.HastelloyX, 6).inputItems(TagPrefix.frameGt, GTMaterials.MaragingSteel300).circuitMeta(6).outputItems(GCYMBlocks.CASING_REACTION_SAFE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_laser_safe_engraving").inputItems(TagPrefix.plate, GTMaterials.TitaniumTungstenCarbide, 6).inputItems(TagPrefix.frameGt, GTMaterials.Titanium).circuitMeta(6).outputItems(GCYMBlocks.CASING_LASER_SAFE_ENGRAVING.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_large_scale_assembling").inputItems(TagPrefix.plate, GTMaterials.Stellite100, 6).inputItems(TagPrefix.frameGt, GTMaterials.Tungsten).circuitMeta(6).outputItems(GCYMBlocks.CASING_LARGE_SCALE_ASSEMBLING.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_shock_proof").inputItems(TagPrefix.plate, GTMaterials.HastelloyC276, 6).inputItems(TagPrefix.frameGt, GTMaterials.HastelloyC276).circuitMeta(6).outputItems(GCYMBlocks.CASING_SHOCK_PROOF.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_corrosion_proof").inputItems(TagPrefix.plate, GTMaterials.CobaltBrass, 6).inputItems(TagPrefix.frameGt, GTMaterials.HSLASteel).circuitMeta(6).outputItems(GCYMBlocks.CASING_CORROSION_PROOF.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_stress_proof").inputItems(TagPrefix.plate, GTMaterials.MaragingSteel300, 6).inputItems(TagPrefix.frameGt, GTMaterials.StainlessSteel).circuitMeta(6).outputItems(GCYMBlocks.CASING_STRESS_PROOF.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).EUt(16L).save();
    }

    private static void registerMixerRecipes() {
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("hsla_steel").inputItems(TagPrefix.dust, GTMaterials.Invar, 2).inputItems(TagPrefix.dust, GTMaterials.Vanadium).inputItems(TagPrefix.dust, GTMaterials.Titanium).inputItems(TagPrefix.dust, GTMaterials.Molybdenum).outputItems(TagPrefix.dust, GTMaterials.HSLASteel, 5).duration(140).EUt((long)GTValues.VA[3]).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("molybdenum_disilicide").inputItems(TagPrefix.dust, GTMaterials.Molybdenum).inputItems(TagPrefix.dust, GTMaterials.Silicon, 2).circuitMeta(2).outputItems(TagPrefix.dust, GTMaterials.MolybdenumDisilicide, 3).duration(180).EUt((long)GTValues.VA[4]).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("titanium_carbide").inputItems(TagPrefix.dust, GTMaterials.Titanium).inputItems(TagPrefix.dust, GTMaterials.Carbon).circuitMeta(3).outputItems(TagPrefix.dust, GTMaterials.TitaniumCarbide, 2).duration(160).EUt((long)GTValues.VA[4]).save();
    }

    private static void registerFormulaic() {
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Copper, 3, GTMaterials.Tin, 1, GTMaterials.Bronze, 4, 400);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Copper, 3, GTMaterials.Zinc, 1, GTMaterials.Brass, 4, 400);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Copper, 1, GTMaterials.Nickel, 1, GTMaterials.Cupronickel, 2, 200);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Copper, 1, GTMaterials.Redstone, 4, GTMaterials.RedAlloy, 1, 100);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Iron, 1, GTMaterials.Tin, 1, GTMaterials.TinAlloy, 2, 100);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Iron, 2, GTMaterials.Nickel, 1, GTMaterials.Invar, 3, 300);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Lead, 4, GTMaterials.Antimony, 1, GTMaterials.BatteryAlloy, 5, 250);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Magnesium, 1, GTMaterials.Aluminium, 2, GTMaterials.Magnalium, 3, 150);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Silver, 1, GTMaterials.Electrotine, 4, GTMaterials.BlueAlloy, 1, 100);
        GCYMRecipes.registerBinaryAlloy(GTMaterials.Glass, 7, GTMaterials.Boron, 1, GTMaterials.BorosilicateGlass, 8, 200);
        GCYMRecipes.registerTrinaryAlloy(GTMaterials.Brass, 7, GTMaterials.Aluminium, 1, GTMaterials.Cobalt, 1, GTMaterials.CobaltBrass, 9, 900);
        GCYMRecipes.registerTrinaryAlloy(GTMaterials.Tin, 6, GTMaterials.Lead, 3, GTMaterials.Antimony, 1, GTMaterials.SolderingAlloy, 10, 200);
        GCYMRecipes.registerTrinaryAlloy(GTMaterials.Copper, 6, GTMaterials.Tin, 2, GTMaterials.Lead, 1, GTMaterials.Potin, 9, 400);
    }

    private static void registerManual() {
        GTORecipeTypes.ALLOY_BLAST_RECIPES.recipeBuilder("nickel_zinc_ferrite").inputItems(TagPrefix.dust, GTMaterials.Nickel).inputItems(TagPrefix.dust, GTMaterials.Zinc).inputItems(TagPrefix.dust, GTMaterials.Iron, 4).circuitMeta(6).inputFluids(GTMaterials.Oxygen, 8000).outputFluids(GTMaterials.NickelZincFerrite.getFluid(864)).duration(1800).EUt((long)GTValues.VA[2]).blastFurnaceTemp(1500).save();
    }

    private static void registerBinaryAlloy(@NotNull Material input1, int input1Amount, @NotNull Material input2, int input2Amount, @NotNull Material output, int outputAmount, int duration) {
        GTORecipeTypes.ALLOY_BLAST_RECIPES.recipeBuilder(output.getName()).inputItems(TagPrefix.dust, input1, input1Amount).inputItems(TagPrefix.dust, input2, input2Amount).circuitMeta(input1Amount + input2Amount).outputFluids(output.getFluid(144 * outputAmount)).duration(duration * 3 / 4).EUt(16L).blastFurnaceTemp(output.getFluid().getFluidType().getTemperature()).save();
    }

    private static void registerTrinaryAlloy(@NotNull Material input1, int input1Amount, @NotNull Material input2, int input2Amount, @NotNull Material input3, int input3Amount, @NotNull Material output, int outputAmount, int duration) {
        GTORecipeTypes.ALLOY_BLAST_RECIPES.recipeBuilder(output.getName()).inputItems(TagPrefix.dust, input1, input1Amount).inputItems(TagPrefix.dust, input2, input2Amount).inputItems(TagPrefix.dust, input3, input3Amount).circuitMeta(input1Amount + input2Amount + input3Amount).outputFluids(output.getFluid(144 * outputAmount)).duration(duration * 3 / 4).EUt(16L).blastFurnaceTemp(output.getFluid().getFluidType().getTemperature()).save();
    }
}

