/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.gtm.chemistry;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTORecipeTypes;

final class TitaniumRecipes {
    private TitaniumRecipes() {
    }

    public static void init() {
        TitaniumRecipes.titaniumProcess();
        TitaniumRecipes.solvayProcess();
        TitaniumRecipes.bauxiteProcess();
        TitaniumRecipes.ilmeniteProcess();
    }

    private static void titaniumProcess() {
        GTORecipeTypes.REACTION_FURNACE_RECIPES.recipeBuilder("rutile_from_ilmenite").inputItems(TagPrefix.dust, GTMaterials.Ilmenite, 5).inputItems(TagPrefix.dust, GTMaterials.Carbon).outputItems(TagPrefix.ingot, GTMaterials.WroughtIron).outputItems(TagPrefix.dust, GTMaterials.Rutile, 3).outputFluids(GTMaterials.CarbonDioxide.getFluid(1000)).blastFurnaceTemp(1700).duration(1600).EUt((long)GTValues.VA[3]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("titanium_tetrachloride").inputItems(TagPrefix.dust, GTMaterials.Carbon, 2).inputItems(TagPrefix.dust, GTMaterials.Rutile).inputFluids(GTMaterials.Chlorine, 4000).outputFluids(GTMaterials.CarbonMonoxide.getFluid(2000)).outputFluids(GTMaterials.TitaniumTetrachloride.getFluid(1000)).displayPriority(1).duration(400).EUt((long)GTValues.VA[3]).save();
        GTORecipeTypes.REACTION_FURNACE_RECIPES.recipeBuilder("titanium_from_tetrachloride").inputItems(TagPrefix.dust, GTMaterials.Magnesium, 2).inputFluids(GTMaterials.TitaniumTetrachloride, 1000).outputItems(TagPrefix.ingotHot, GTMaterials.Titanium).outputItems(TagPrefix.dust, GTMaterials.MagnesiumChloride, 6).blastFurnaceTemp(GTMaterials.Titanium.getBlastTemperature() + 200).displayPriority(1).duration(800).EUt((long)GTValues.VA[3]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("salt_from_magnesium_chloride").inputItems(TagPrefix.dust, GTMaterials.MagnesiumChloride, 3).inputItems(TagPrefix.dust, GTMaterials.Sodium, 2).outputItems(TagPrefix.dust, GTMaterials.Magnesium, 1).outputItems(TagPrefix.dust, GTMaterials.Salt, 4).duration(200).EUt((long)GTValues.VA[3]).save();
    }

    private static void solvayProcess() {
        GTORecipeTypes.REACTION_FURNACE_RECIPES.recipeBuilder("quicklime_from_calcite").circuitMeta(1).inputItems(TagPrefix.dust, GTMaterials.Calcite, 5).outputItems(TagPrefix.dust, GTMaterials.Quicklime, 2).outputFluids(GTMaterials.CarbonDioxide.getFluid(1000)).blastFurnaceTemp(1250).duration(200).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("sodium_bicarbonate_from_salt").inputItems(TagPrefix.dust, GTMaterials.Salt, 4).inputFluids(GTMaterials.CarbonDioxide, 1000).inputFluids(GTMaterials.Ammonia, 1000).inputFluids(GTMaterials.Water, 1000).outputItems(TagPrefix.dust, GTMaterials.AmmoniumChloride, 2).outputItems(TagPrefix.dust, GTMaterials.SodiumBicarbonate, 6).duration(400).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.ELECTROLYZER_RECIPES.recipeBuilder("soda_ash_from_bicarbonate").inputItems(TagPrefix.dust, GTMaterials.SodiumBicarbonate, 12).outputItems(TagPrefix.dust, GTMaterials.SodaAsh, 6).outputFluids(GTMaterials.CarbonDioxide.getFluid(1000)).outputFluids(GTMaterials.Water.getFluid(1000)).duration(200).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.CHEMICAL_RECIPES.recipeBuilder("calcium_chloride_from_quicklime").inputItems(TagPrefix.dust, GTMaterials.AmmoniumChloride, 4).inputItems(TagPrefix.dust, GTMaterials.Quicklime, 2).outputItems(TagPrefix.dust, GTMaterials.CalciumChloride, 3).outputFluids(GTMaterials.Ammonia.getFluid(2000)).outputFluids(GTMaterials.Water.getFluid(1000)).duration(200).EUt((long)GTValues.VA[2]).save();
    }

    private static void bauxiteProcess() {
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("bauxite_slurry_from_crushed_bauxite").inputItems(TagPrefix.crushed, GTMaterials.Bauxite, 32).inputItems(TagPrefix.dust, GTMaterials.SodaAsh, 12).inputItems(TagPrefix.dust, GTMaterials.CalciumChloride, 6).inputFluids(GTMaterials.Water, 1000).outputFluids(GTMaterials.BauxiteSlurry.getFluid(4000)).duration(500).EUt((long)GTValues.VA[3]).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("bauxite_slurry_from_washed_bauxite").inputItems(TagPrefix.crushedPurified, GTMaterials.Bauxite, 32).inputItems(TagPrefix.dust, GTMaterials.SodaAsh, 12).inputItems(TagPrefix.dust, GTMaterials.CalciumChloride, 6).inputFluids(GTMaterials.Water, 1000).outputFluids(GTMaterials.BauxiteSlurry.getFluid(4000)).duration(500).EUt((long)GTValues.VA[3]).save();
        GTORecipeTypes.CRACKING_RECIPES.recipeBuilder("cracked_bauxite_slurry").circuitMeta(1).inputFluids(GTMaterials.BauxiteSlurry, 16000).inputFluids(GTMaterials.Steam, 1000).outputFluids(GTMaterials.CrackedBauxiteSlurry.getFluid(16000)).duration(500).EUt((long)GTValues.VA[3]).save();
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("bauxite_sludge_from_slurry").inputFluids(GTMaterials.CrackedBauxiteSlurry, 4000).inputFluids(GTMaterials.SulfuricAcid, 1000).outputItems(TagPrefix.dust, GTMaterials.Aluminium, 24).outputItems(TagPrefix.dust, GTMaterials.BauxiteSlag, 8).outputFluids(GTMaterials.BauxiteSludge.getFluid(2500)).outputFluids(GTMaterials.SulfurTrioxide.getFluid(1000)).duration(500).EUt((long)GTValues.VA[3]).save();
        GTORecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder("bauxite_slag_separation").inputItems(TagPrefix.dust, GTMaterials.BauxiteSlag).outputItems(TagPrefix.dust, GTMaterials.Salt).chancedOutput(TagPrefix.dust, GTMaterials.Neodymium, 2000, 250).chancedOutput(TagPrefix.dust, GTMaterials.Chromium, 1000, 250).duration(50).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.DISTILLERY_RECIPES.recipeBuilder("bauxite_sludge_decalcification").circuitMeta(1).inputFluids(GTMaterials.BauxiteSludge, 500).outputItems(TagPrefix.dust, GTMaterials.Calcite, 2).outputFluids(GTMaterials.DecalcifiedBauxiteSludge.getFluid(500)).duration(100).EUt((long)GTValues.VA[2]).save();
        GTORecipeTypes.CENTRIFUGE_RECIPES.recipeBuilder("bauxite_sludge_centrifuge").inputFluids(GTMaterials.DecalcifiedBauxiteSludge, 250).outputItems(TagPrefix.dust, GTMaterials.Rutile, 2).chancedOutput(TagPrefix.dust, GTMaterials.Gallium, 5000, 550).chancedOutput(TagPrefix.dust, GTMaterials.Gallium, 3000, 800).chancedOutput(TagPrefix.dust, GTMaterials.Gallium, 1000, 1000).chancedOutput(TagPrefix.dust, GTMaterials.SiliconDioxide, 9000, 250).chancedOutput(TagPrefix.dust, GTMaterials.Iron, 8000, 250).outputFluids(GTMaterials.Water.getFluid(250)).duration(100).EUt((long)GTValues.VA[2]).save();
    }

    private static void ilmeniteProcess() {
        GTORecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder("ilmenite_separation").inputItems(TagPrefix.dust, GTMaterials.IlmeniteSlag).chancedOutput(TagPrefix.dust, GTMaterials.Iron, 8000, 0).chancedOutput(TagPrefix.dust, GTMaterials.Tantalum, 2000, 0).chancedOutput(TagPrefix.dust, GTMaterials.Niobium, 500, 0).duration(50).EUt((long)GTValues.VA[2]).save();
    }
}

