/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.generated;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTORecipeTypes;
import java.util.Locale;

public final class RadiationHatchRecipes {
    public static void init() {
        RadiationHatchRecipes.registerRadioactiveMaterial(GTMaterials.Uranium238, 8000, 50);
        RadiationHatchRecipes.registerRadioactiveMaterial(GTMaterials.Uranium235, 6500, 100);
        RadiationHatchRecipes.registerRadioactiveMaterial(GTMaterials.Plutonium241, 6000, 110);
        RadiationHatchRecipes.registerRadioactiveMaterial(GTMaterials.Naquadah, 15000, 120);
        RadiationHatchRecipes.registerRadioactiveMaterial(GTMaterials.NaquadahEnriched, 10000, 140);
        RadiationHatchRecipes.registerRadioactiveMaterial(GTMaterials.Naquadria, 7500, 160);
    }

    private static void registerRadioactiveMaterial(Material material, int duration, int radioactivity) {
        if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            GTORecipeTypes.RADIATION_HATCH_RECIPES.recipeBuilder("radioactive_material_rod" + material.getName().toLowerCase(Locale.ROOT)).inputItems(ChemicalHelper.get((TagPrefix)TagPrefix.rod, (Material)material, (int)1)).duration(duration).addData("radioactivity", radioactivity).save();
        }
        if (material.hasFlag(MaterialFlags.GENERATE_LONG_ROD)) {
            GTORecipeTypes.RADIATION_HATCH_RECIPES.recipeBuilder("radioactive_material_long_rod" + material.getName().toLowerCase(Locale.ROOT)).inputItems(ChemicalHelper.get((TagPrefix)TagPrefix.rodLong, (Material)material, (int)1)).duration((int)((double)duration * 1.5)).addData("radioactivity", (int)((double)radioactivity * 1.2)).save();
        }
    }
}

