/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.generated;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.common.data.GTORecipeTypes;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class GTOWireCombiningHandler {
    private static final Map<TagPrefix, TagPrefix> cableToWireMap = ImmutableMap.of((Object)TagPrefix.cableGtSingle, (Object)TagPrefix.wireGtSingle, (Object)TagPrefix.cableGtDouble, (Object)TagPrefix.wireGtDouble, (Object)TagPrefix.cableGtQuadruple, (Object)TagPrefix.wireGtQuadruple, (Object)TagPrefix.cableGtOctal, (Object)TagPrefix.wireGtOctal, (Object)TagPrefix.cableGtHex, (Object)TagPrefix.wireGtHex);
    private static final TagPrefix[] WIRE_DOUBLING_ORDER = new TagPrefix[]{TagPrefix.wireGtSingle, TagPrefix.wireGtDouble, TagPrefix.wireGtQuadruple, TagPrefix.wireGtOctal, TagPrefix.wireGtHex};

    GTOWireCombiningHandler() {
    }

    public static void run(@NotNull Material material) {
        WireProperties property = (WireProperties)material.getProperty(PropertyKey.WIRE);
        if (property == null) {
            return;
        }
        GTOWireCombiningHandler.processWireCompression(material, property);
        if (property.isSuperconductor()) {
            return;
        }
        for (TagPrefix cablePrefix : cableToWireMap.keySet()) {
            GTOWireCombiningHandler.processCableStripping(cablePrefix, material, property);
        }
    }

    private static void processWireCompression(Material material, WireProperties property) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.wireGtSingle)) {
            return;
        }
        int mass = (int)material.getMass();
        long v = property.getVoltage();
        for (int startTier = 0; startTier < 4; ++startTier) {
            for (int i = 1; i < 5 - startTier; ++i) {
                GTORecipeTypes.LOOM_RECIPES.recipeBuilder("loom_" + material.getName() + "_wires_" + i + "_" + startTier).inputItems(WIRE_DOUBLING_ORDER[startTier], material, 1 << i).circuitMeta(1 << i).outputItems(WIRE_DOUBLING_ORDER[startTier + i], material, 1).EUt(v > 2048L ? 56L : (v > 128L ? 28L : 7L)).duration(mass * i).save();
            }
            if (startTier >= 3 || v >= 33L) continue;
            GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder(material.getName() + "_wires_" + startTier).inputItems(WIRE_DOUBLING_ORDER[startTier], material, 2).outputItems(WIRE_DOUBLING_ORDER[startTier + 1], material, 1).EUt(30L).duration(mass * (startTier + 1) * 2).save();
        }
        for (int i = 1; i < 5; ++i) {
            GTORecipeTypes.UNPACKER_RECIPES.recipeBuilder("pack_" + material.getName() + "_wires_" + i + "_single").inputItems(WIRE_DOUBLING_ORDER[i], material, 1).outputItems(WIRE_DOUBLING_ORDER[0], material, 1 << i).duration(mass * i).save();
        }
    }

    private static void processCableStripping(TagPrefix prefix, Material material, WireProperties property) {
        if (!material.shouldGenerateRecipesFor(prefix)) {
            return;
        }
        Material rubber = GTMaterials.Rubber;
        byte voltageTier = GTUtil.getTierByVoltage((long)property.getVoltage());
        if (voltageTier > 8) {
            rubber = GTMaterials.StyreneButadieneRubber;
        } else if (voltageTier > 4) {
            rubber = GTMaterials.SiliconeRubber;
        }
        GTORecipeTypes.UNPACKER_RECIPES.recipeBuilder("strip_" + material.getName() + "_" + prefix.name.toLowerCase()).inputItems(prefix, material).outputItems(cableToWireMap.get(prefix), material).outputItems(TagPrefix.plate, rubber, (int)(((MaterialStack)prefix.secondaryMaterials().get(0)).amount() / 3628800L)).duration(100).EUt((long)GTValues.VA[0]).save();
    }
}

