/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterials;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlag;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.AlloyBlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.api.data.material.GTOMaterialFlags;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.common.data.GTOFluidStorageKey;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTORecipeCategories;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.data.recipe.processing.CompositeMaterialsProcessing;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.gtolib.utils.GTOUtils;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

final class GTOMaterialRecipeHandler {
    private static final List<TagPrefix> GEM_ORDER = Arrays.asList(TagPrefix.gem, TagPrefix.gemFlawless, TagPrefix.gemExquisite);
    static Reference2ReferenceMap<Fluid, Fluid> inertGas2HighPressureCache = null;

    GTOMaterialRecipeHandler() {
    }

    static void run(Material material) {
        if (GTOUtils.isGeneration((TagPrefix)TagPrefix.ingot, (Material)material)) {
            GTOMaterialRecipeHandler.processIngot(material);
            GTOMaterialRecipeHandler.processNugget(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)TagPrefix.block, (Material)material)) {
            GTOMaterialRecipeHandler.processBlock(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)TagPrefix.frameGt, (Material)material)) {
            GTOMaterialRecipeHandler.processFrame(material);
        }
        GTOMaterialRecipeHandler.processDust(material);
        if (GTOUtils.isGeneration((TagPrefix)TagPrefix.dustSmall, (Material)material)) {
            GTOMaterialRecipeHandler.processSmallDust(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)TagPrefix.dustTiny, (Material)material)) {
            GTOMaterialRecipeHandler.processTinyDust(material);
        }
        if (material.shouldGenerateRecipesFor(TagPrefix.gemExquisite) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES)) {
            for (TagPrefix orePrefix : Arrays.asList(TagPrefix.gem, TagPrefix.gemFlawless, TagPrefix.gemExquisite)) {
                GTOMaterialRecipeHandler.processGemConversion(orePrefix, material);
            }
        }
    }

    private static void processIngot(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        if (material.hasFlag(MaterialFlags.MORTAR_GRINDABLE)) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("mortar_grind_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)material), (Object[])new Object[]{"X", "m", Character.valueOf('X'), stack});
        }
        if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            if (mass < 240 && material.getBlastTemperature() < 3600) {
                VanillaRecipeHelper.addShapedRecipe((String)String.format("stick_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.rod, (Material)material), (Object[])new Object[]{"f ", " X", Character.valueOf('X'), stack});
            }
            if (!material.hasFlag(MaterialFlags.NO_WORKING)) {
                GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_to_rod").inputItems(stack).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_ROD).outputItems(TagPrefix.rod, material, 2).duration(mass << 1).EUt(6L * (long)GTOUtils.getVoltageMultiplier((Material)material)).save();
            }
        }
        if (material.hasFluid()) {
            GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_ingot").notConsumable((Supplier)GTItems.SHAPE_MOLD_INGOT).inputFluids(material.getFluid(144)).outputItems(stack).duration(mass).EUt((long)GTValues.VA[0]).save();
        }
        if (material.hasAnyOfFlags(new MaterialFlag[]{MaterialFlags.NO_SMASHING, GTOMaterialFlags.COMPOSITE_MATERIAL})) {
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_to_ingot").inputItems(TagPrefix.dust, material).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_INGOT).outputItems(stack).duration(mass).EUt(4L * (long)GTOUtils.getVoltageMultiplier((Material)material)).save();
        }
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_to_nugget").EUt((long)GTValues.VA[0]).duration(mass).inputItems(stack).notConsumable((Supplier)GTItems.SHAPE_MOLD_NUGGET).outputItems(TagPrefix.nugget, material, 9).category(GTRecipeCategories.INGOT_MOLDING).save();
        if (!ChemicalHelper.get((TagPrefix)TagPrefix.block, (Material)material).m_41619_()) {
            int amount = (int)(TagPrefix.block.getMaterialAmount(material) / 3628800L);
            GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_to_ingot").EUt(16L).duration(Math.max(1, mass * amount / 4)).inputItems(TagPrefix.block, material).notConsumable((Supplier)GTItems.SHAPE_MOLD_INGOT).outputItems(stack.m_255036_(amount)).category(GTRecipeCategories.INGOT_MOLDING).save();
            GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_" + material.getName() + "_to_block").EUt((long)GTValues.VA[0]).duration(Math.max(1, mass * amount / 2)).inputItems(stack.m_255036_(amount)).outputItems(TagPrefix.block, material).save();
        }
        if (GTOUtils.isGeneration((TagPrefix)TagPrefix.ingotHot, (Material)material) && material.hasFlag(GTOMaterialFlags.CAN_BE_COOLED_DOWN_BY_BATHING)) {
            GTORecipeTypes.CHEMICAL_BATH_RECIPES.builder("%s_cool_down".formatted(material), new Object[0]).inputItems(TagPrefix.ingotHot, material).inputFluids(GTOMaterials.CoolantLiquid, 100).outputItems(TagPrefix.ingot, material).duration(mass * 5).EUt((long)GTValues.VA[2]).save();
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && !material.hasFlag(MaterialFlags.NO_WORKING)) {
            ItemStack plateStack;
            if (!material.hasFlag(MaterialFlags.NO_SMASHING) && !(plateStack = ChemicalHelper.get((TagPrefix)TagPrefix.plate, (Material)material)).m_41619_()) {
                GTORecipeTypes.ROLLING_RECIPES.recipeBuilder("rolling_" + material.getName() + "_to_plate").inputItems(stack).outputItems(plateStack).EUt(30L).duration(Math.max(1, mass / 2)).circuitMeta(1).save();
                GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_to_plate").inputItems(stack.m_255036_(3)).outputItems(plateStack.m_255036_(2)).EUt(16L).duration(Math.max(1, mass / 2)).save();
                if (mass < 240 && material.getBlastTemperature() < 3600) {
                    VanillaRecipeHelper.addShapedRecipe((String)String.format("plate_%s", material.getName()), (ItemStack)plateStack, (Object[])new Object[]{"h", "I", "I", Character.valueOf('I'), stack});
                }
            }
            int voltageMultiplier = GTOUtils.getVoltageMultiplier((Material)material) << 3;
            if (!ChemicalHelper.get((TagPrefix)TagPrefix.plate, (Material)material).m_41619_()) {
                GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_to_plate").inputItems(stack).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_PLATE).outputItems(TagPrefix.plate, material).duration(mass << 1).EUt((long)voltageMultiplier).save();
                if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                    GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_plate").inputItems(TagPrefix.dust, material).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_PLATE).outputItems(TagPrefix.plate, material).duration(mass).EUt((long)voltageMultiplier).save();
                }
            }
        }
    }

    private static void processNugget(Material material) {
        ItemStack nuggetStack = ChemicalHelper.get((TagPrefix)TagPrefix.nugget, (Material)material, (int)9);
        if (nuggetStack.m_41619_()) {
            return;
        }
        if (material.hasProperty(PropertyKey.INGOT)) {
            ItemStack ingotStack = ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)(material.hasFlag(MaterialFlags.IS_MAGNETIC) ? ((IngotProperty)material.getProperty(PropertyKey.INGOT)).getMacerateInto() : material));
            if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
                if (!TagPrefix.ingot.isIgnored(material)) {
                    VanillaRecipeHelper.addShapelessRecipe((String)String.format("nugget_disassembling_%s", material.getName()), (ItemStack)nuggetStack.m_255036_(9), (Object[])new Object[]{new MaterialEntry(TagPrefix.ingot, material)});
                }
                if (!TagPrefix.nugget.isIgnored(material)) {
                    VanillaRecipeHelper.addShapedRecipe((String)String.format("nugget_assembling_%s", material.getName()), (ItemStack)ingotStack, (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), new MaterialEntry(TagPrefix.nugget, material)});
                }
            }
            GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_" + material.getName() + "_nugget_to_ingot").inputItems(nuggetStack).outputItems(ingotStack).EUt((long)GTValues.VA[0]).duration((int)material.getMass()).save();
            GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_nugget_to_ingot").EUt((long)GTValues.VA[0]).duration((int)material.getMass()).inputItems(nuggetStack).notConsumable((Supplier)GTItems.SHAPE_MOLD_INGOT).outputItems(ingotStack).category(GTRecipeCategories.INGOT_MOLDING).save();
            if (material.hasFluid()) {
                GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_nugget").notConsumable((Supplier)GTItems.SHAPE_MOLD_NUGGET).inputFluids(material.getFluid(144)).outputItems(nuggetStack).duration((int)material.getMass()).EUt((long)GTValues.VA[0]).save();
            }
        } else if (material.hasProperty(PropertyKey.GEM)) {
            ItemStack gemStack = ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)material);
            if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
                if (!TagPrefix.gem.isIgnored(material)) {
                    VanillaRecipeHelper.addShapelessRecipe((String)String.format("nugget_disassembling_%s", material.getName()), (ItemStack)nuggetStack.m_255036_(9), (Object[])new Object[]{new MaterialEntry(TagPrefix.gem, material)});
                }
                if (!TagPrefix.nugget.isIgnored(material)) {
                    VanillaRecipeHelper.addShapedRecipe((String)String.format("nugget_assembling_%s", material.getName()), (ItemStack)gemStack, (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), new MaterialEntry(TagPrefix.nugget, material)});
                }
            }
        }
    }

    private static void processBlock(Material material) {
        ItemStack plateStack;
        ItemStack blockStack = ChemicalHelper.get((TagPrefix)TagPrefix.block, (Material)material);
        if (blockStack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        int amount = (int)(TagPrefix.block.getMaterialAmount(material) / 3628800L);
        if (material.hasFluid()) {
            GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_block").notConsumable((Supplier)GTItems.SHAPE_MOLD_BLOCK).inputFluids(material.getFluid(amount * 144)).outputItems(blockStack).duration(mass * amount).EUt((long)GTValues.VA[0]).save();
        }
        if (material.hasAnyOfFlags(new MaterialFlag[]{MaterialFlags.NO_SMASHING, GTOMaterialFlags.COMPOSITE_MATERIAL}) && material.hasFlag(MaterialFlags.GENERATE_PLATE) && !(plateStack = ChemicalHelper.get((TagPrefix)TagPrefix.plate, (Material)material)).m_41619_()) {
            GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_block_to_plate").inputItems(blockStack).outputItems(plateStack.m_255036_(amount)).duration(mass << 3).EUt((long)GTValues.VA[1]).save();
        }
        if (!material.hasFlag(MaterialFlags.EXCLUDE_BLOCK_CRAFTING_RECIPES)) {
            if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
                int size = (int)(TagPrefix.block.getMaterialAmount(material) / 3628800L);
                int sizeSqrt = Math.round(Mth.m_14116_((float)size));
                if (!material.hasFlag(MaterialFlags.EXCLUDE_BLOCK_CRAFTING_BY_HAND_RECIPES) && sizeSqrt * sizeSqrt == size && !TagPrefix.block.isIgnored(material)) {
                    String patternString = "B".repeat(Math.max(0, sizeSqrt));
                    Object[] pattern = new String[sizeSqrt];
                    Arrays.fill(pattern, patternString);
                    MaterialEntry blockEntry = material.hasProperty(PropertyKey.GEM) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES) ? new MaterialEntry(TagPrefix.gem, material) : (material.hasProperty(PropertyKey.INGOT) ? new MaterialEntry(TagPrefix.ingot, material) : new MaterialEntry(TagPrefix.dust, material));
                    VanillaRecipeHelper.addShapedRecipe((String)String.format("block_compress_%s", material.getName()), (ItemStack)blockStack, (Object[])new Object[]{pattern, Character.valueOf('B'), blockEntry});
                    VanillaRecipeHelper.addShapelessRecipe((String)String.format("block_decompress_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)blockEntry.tagPrefix(), (Material)blockEntry.material()).m_255036_(size), (Object[])new Object[]{new MaterialEntry(TagPrefix.block, material)});
                }
            }
            if (material.hasProperty(PropertyKey.INGOT)) {
                GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_block").inputItems(TagPrefix.ingot, material, amount).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_BLOCK).outputItems(blockStack).duration(mass << 1).EUt(8L * (long)GTOUtils.getVoltageMultiplier((Material)material)).save();
            } else if (material.hasProperty(PropertyKey.GEM) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES)) {
                GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_" + material.getName() + "_gem_to_block").inputItems(TagPrefix.gem, material, amount).outputItems(blockStack).duration(Math.max(1, mass * amount / 4)).EUt((long)GTValues.VA[0]).save();
                GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_block_to_gem").inputItems(blockStack).outputItems(TagPrefix.gem, material, amount).duration(100).EUt(24L).save();
            }
        }
    }

    private static void processFrame(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.frameGt, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        boolean isWoodenFrame = material.hasProperty(PropertyKey.WOOD);
        if (material.getMass() < 240L && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("frame_%s", material.getName()), (ItemStack)stack.m_255036_(2), (Object[])new Object[]{"SSS", isWoodenFrame ? "SsS" : "SwS", "SSS", Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, material)});
        }
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + material.getName() + "_frame").inputItems(TagPrefix.rod, material, 4).circuitMeta(4).outputItems(stack).EUt((long)GTValues.VA[0]).duration(64).save();
    }

    private static void processGemConversion(TagPrefix gemPrefix, Material material) {
        TagPrefix prevPrefix;
        ItemStack prevStack;
        if (material.hasFlag(MaterialFlags.MORTAR_GRINDABLE)) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("gem_to_dust_%s_%s", material.getName(), FormattingUtil.toLowerCaseUnderscore((String)gemPrefix.name)), (ItemStack)ChemicalHelper.getDust((Material)material, (long)gemPrefix.getMaterialAmount(material)), (Object[])new Object[]{"X", "m", Character.valueOf('X'), new MaterialEntry(gemPrefix, material)});
        }
        ItemStack itemStack = prevStack = (prevPrefix = (TagPrefix)GTUtil.getItem(GEM_ORDER, (int)(GEM_ORDER.indexOf(gemPrefix) - 1), null)) == null ? ItemStack.f_41583_ : ChemicalHelper.get((TagPrefix)prevPrefix, (Material)material, (int)2);
        if (!prevStack.m_41619_() && prevPrefix != null) {
            GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_" + FormattingUtil.toLowerCaseUnderscore((String)gemPrefix.name) + "_to_" + FormattingUtil.toLowerCaseUnderscore((String)prevPrefix.name)).inputItems(gemPrefix, material).outputItems(prevStack).duration(20).EUt(16L).save();
            GTORecipeTypes.LASER_ENGRAVER_RECIPES.recipeBuilder("engrave_" + material.getName() + "_" + FormattingUtil.toLowerCaseUnderscore((String)gemPrefix.name) + "_to_" + FormattingUtil.toLowerCaseUnderscore((String)prevPrefix.name)).inputItems(prevStack).notConsumable(TagPrefix.lens, (Material)MarkerMaterials.Color.White).inputFluids(GTMaterials.DistilledWater, 10).outputItems(gemPrefix, material).duration(300).EUt(240L).save();
        }
    }

    private static void processDust(Material material) {
        ItemStack dustStack = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)material);
        if (dustStack.m_41619_()) {
            return;
        }
        String id = "%s_%s_".formatted(FormattingUtil.toLowerCaseUnderscore((String)TagPrefix.dust.name), material.getName().toLowerCase(Locale.ROOT));
        OreProperty oreProperty = material.hasProperty(PropertyKey.ORE) ? (OreProperty)material.getProperty(PropertyKey.ORE) : null;
        int mass = (int)material.getMass();
        if (material.hasFluid()) {
            if (inertGas2HighPressureCache == null) {
                inertGas2HighPressureCache = new Reference2ReferenceOpenHashMap();
            }
            Fluid molten = material.getFluid(FluidStorageKeys.MOLTEN);
            Fluid liquid = material.getFluid();
            FastFluidIngredient N2 = FastFluidIngredient.of((FluidStack[])new FluidStack[]{GTMaterials.Nitrogen.getFluid(4 * mass)});
            FastFluidIngredient N2HP = FastFluidIngredient.of((FluidStack[])new FluidStack[]{GTOMaterials.HighPressureNitrogen.getFluid(5 * mass)});
            FastFluidIngredient inert = material.hasProperty(PropertyKey.BLAST) ? (FluidIngredient)Optional.ofNullable(((BlastProperty)material.getProperty(PropertyKey.BLAST)).getGasTier()).map(gas -> gas.getFluid().getStacks()[0]).map(fs -> FastFluidIngredient.of((FluidStack[])new FluidStack[]{new FluidStack(fs.getFluid(), fs.getAmount() * mass / 500 + 30 + mass)})).orElse(N2) : N2;
            FastFluidIngredient inertHighPressure = material.hasProperty(PropertyKey.BLAST) ? (FluidIngredient)Optional.ofNullable(((BlastProperty)material.getProperty(PropertyKey.BLAST)).getGasTier()).map(gas -> gas.getFluid().getStacks()[0]).map(fs -> {
                Fluid fluid = fs.getFluid();
                int amount = fs.getAmount() * mass / 450 + 40 + mass / 5 * 6;
                if (inertGas2HighPressureCache.containsKey((Object)fluid)) {
                    return new FluidStack((Fluid)inertGas2HighPressureCache.get((Object)fluid), amount);
                }
                Fluid HP = GTCEuAPI.materialManager.getRegisteredMaterials().stream().filter(m -> m.hasFluid() && m.getFluid() == fluid).findAny().orElseThrow().getFluid(GTOFluidStorageKey.HIGH_PRESSURE_GAS);
                inertGas2HighPressureCache.put((Object)fluid, (Object)HP);
                return new FluidStack(HP, amount);
            }).map(xva$0 -> FastFluidIngredient.of((FluidStack[])new FluidStack[]{xva$0})).orElse(N2HP) : N2HP;
            GTORecipeTypes.ATOMIZATION_CONDENSATION_RECIPES.recipeBuilder("atomize_condense_" + id + "to_dust").inputFluids(material.getFluid(144)).inputFluids(new FluidIngredient[]{inertHighPressure}).outputItems(dustStack).outputFluids(new FluidIngredient[]{inert}).duration(mass / 2 + 1).EUt((long)(GTValues.VA[1] / 2)).category(GTORecipeCategories.CONDENSE_FLUID_TO_DUST).save();
            if (molten != null) {
                boolean needLiquidHelium = ((AlloyBlastProperty)material.getProperty(PropertyKey.ALLOY_BLAST)).getTemperature() >= 5000;
                RecipeBuilder b2 = GTORecipeTypes.ATOMIZATION_CONDENSATION_RECIPES.recipeBuilder("atomize_condense_" + id + "to_dust_from_molten").inputFluids(molten, 144L).inputFluids(new FluidIngredient[]{inertHighPressure}).outputItems(dustStack).outputFluids(new FluidIngredient[]{inert}).duration((int)((float)mass * 1.5f)).EUt((long)GTOUtils.getVoltageMultiplier((Material)material)).circuitMeta(1).category(GTORecipeCategories.CONDENSE_MOLTEN_TO_DUST);
                RecipeBuilder bl = GTORecipeTypes.ATOMIZATION_CONDENSATION_RECIPES.recipeBuilder("atomize_condense_" + id + "to_liquid_from_molten").inputFluids(molten, 144L).inputFluids(new FluidIngredient[]{inertHighPressure}).outputFluids(liquid, 144L).outputFluids(new FluidIngredient[]{inert}).duration((int)((float)mass * 2.5f)).EUt((long)GTOUtils.getVoltageMultiplier((Material)material)).circuitMeta(2).category(GTORecipeCategories.CONDENSE_MOLTEN_TO_DUST);
                if (needLiquidHelium) {
                    b2.inputFluids(GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID, 500)).outputFluids(GTMaterials.Helium, 250);
                    bl.inputFluids(GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID, 500)).outputFluids(GTMaterials.Helium, 250);
                }
                b2.save();
                bl.save();
            }
        }
        if (material.hasFlag(GTOMaterialFlags.GENERATE_MXene)) {
            int temp = Math.max(3700 + 10 * mass, material.getBlastTemperature());
            Material A = temp >= 5000 ? GTMaterials.Gallium : GTMaterials.Aluminium;
            GTORecipeTypes.CRYSTALLIZATION_RECIPES.builder("mxene_precursor_" + id, new Object[0]).inputItems(TagPrefix.dust, material, 4).inputItems(TagPrefix.dustTiny, material, 16).outputItems(GTOTagPrefix.AluminumContainedMXenePrecursor, material).inputFluids(A, 288).inputFluids(GTOMaterials.HighPressureArgon, 1000).EUt(128L).blastFurnaceTemp(temp).duration(2400).save();
            GTORecipeTypes.REACTION_FURNACE_RECIPES.builder("mxene_etching_" + id, new Object[0]).inputItems(GTOTagPrefix.AluminumContainedMXenePrecursor, material).inputItems(GTOTagPrefix.dust, GTOMaterials.SodiumFluoride, 8).outputItems(GTOTagPrefix.MXene, material).inputFluids(GTMaterials.HydrofluoricAcid, 13000).outputFluids(GTOMaterials.DiluteHydrofluoricAcid, 13000).EUt(555L).blastFurnaceTemp(temp - 2000).duration(20 * mass + 10).save();
        }
        if (material.hasFlag(GTOMaterialFlags.GENERATE_FIBER)) {
            if (!material.hasFlag(GTOMaterialFlags.IS_CARBON_FIBER)) {
                int fiberTemp = CompositeMaterialsProcessing.getFiberExtrusionTemperature(material);
                if (fiberTemp == 0) {
                    fiberTemp = Math.max(800, material.getBlastTemperature());
                }
                int amount = material == GTMaterials.BorosilicateGlass || material == GTOMaterials.Kevlar ? 8 : 1;
                GTORecipeTypes.FIBER_EXTRUSION_RECIPES.builder("fiber_" + id + "from_extrusion", new Object[0]).inputItems(TagPrefix.dust, material).outputItems(GTOTagPrefix.FIBER, material, amount).EUt(50L + (long)mass * 2L).duration(200 + mass * 4).blastFurnaceTemp(fiberTemp).save();
                GTORecipeTypes.DRAWING_RECIPES.recipeBuilder("drawing_fiber_" + id).circuitMeta(4).inputItems(TagPrefix.dust, material, 256).outputItems(GTOTagPrefix.FIBER, material, amount * 256).addData("spool", 5).duration((200 + mass * 4) * 512).EUt((50L + (long)mass * 2L) * 16L).blastFurnaceTemp(4300 + fiberTemp).save();
            }
            GTORecipeTypes.LOOM_RECIPES.builder("fiber_mesh_" + id + "_from_fiber", new Object[0]).inputItems(GTOTagPrefix.FIBER, material, 2).outputItems(GTOTagPrefix.FIBER_MESH, material, 1).circuitMeta(4).EUt(30L + (long)mass * 2L).duration(500 + mass * 4).save();
        }
        if (material.hasFlag(GTOMaterialFlags.HAS_NANOSCALE_FORM)) {
            GTORecipeTypes.ULTRA_FINE_GRINDING_RECIPES.recipeBuilder("ultra_fine_grind_" + id).inputItems(TagPrefix.dust, material).outputItems(GTOTagPrefix.NANO, material).duration(100).EUt((long)GTValues.VA[11]).save();
        }
        if (material.hasProperty(PropertyKey.GEM) && !material.hasFlag(GTOMaterialFlags.DISABLE_GEM_RECIPES)) {
            Material smeltingResult;
            ItemStack gemStack = ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)material);
            if (material.hasFlag(MaterialFlags.CRYSTALLIZABLE)) {
                GTORecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("autoclave_" + id + "_water").inputItems(dustStack).inputFluids(GTMaterials.Water, 250).chancedOutput(gemStack, 7000, 1000).duration(1200).EUt(24L).save();
                GTORecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("autoclave_" + id + "_distilled").inputItems(dustStack).inputFluids(GTMaterials.DistilledWater, 50).outputItems(gemStack).duration(600).EUt(24L).save();
            }
            if (!material.hasFlag(MaterialFlags.EXPLOSIVE) && !material.hasFlag(MaterialFlags.FLAMMABLE)) {
                ItemStack dustStack4 = dustStack.m_255036_(4);
                ItemStack gemStack3 = gemStack.m_255036_(3);
                GTORecipeTypes.IMPLOSION_RECIPES.recipeBuilder("implode_" + id + "_powderbarrel").inputItems(dustStack4).outputItems(gemStack3).chancedOutput(TagPrefix.dust, GTMaterials.DarkAsh, 2500, 0).explosivesType(new ItemStack((ItemLike)GTBlocks.POWDERBARREL, 8)).save();
                GTORecipeTypes.IMPLOSION_RECIPES.recipeBuilder("implode_" + id + "_tnt").inputItems(dustStack4).outputItems(gemStack3).chancedOutput(TagPrefix.dust, GTMaterials.DarkAsh, 2500, 0).explosivesAmount(4).save();
                GTORecipeTypes.IMPLOSION_RECIPES.recipeBuilder("implode_" + id + "_dynamite").inputItems(dustStack4).outputItems(gemStack3).chancedOutput(TagPrefix.dust, GTMaterials.DarkAsh, 2500, 0).explosivesType(GTItems.DYNAMITE.asStack(2)).save();
                GTORecipeTypes.IMPLOSION_RECIPES.recipeBuilder("implode_" + id + "_itnt").inputItems(dustStack4).outputItems(gemStack3).chancedOutput(TagPrefix.dust, GTMaterials.DarkAsh, 2500, 0).explosivesType(new ItemStack((ItemLike)GTBlocks.INDUSTRIAL_TNT)).save();
                GTORecipeTypes.ELECTRIC_IMPLOSION_COMPRESSOR_RECIPES.recipeBuilder("electric_implode_" + id).inputItems(dustStack4).outputItems(gemStack3).save();
            }
            if (oreProperty != null && !(smeltingResult = oreProperty.getDirectSmeltResult()).isNull()) {
                VanillaRecipeHelper.addSmeltingRecipe((String)(id + "_ingot"), (ItemStack)dustStack, (ItemStack)ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)smeltingResult));
            }
        } else if (material.hasProperty(PropertyKey.INGOT)) {
            if (!material.hasAnyOfFlags(new MaterialFlag[]{MaterialFlags.FLAMMABLE, MaterialFlags.NO_SMELTING})) {
                int blastTemp;
                Material smeltingResult;
                boolean hasHotIngot = TagPrefix.ingotHot.doGenerateItem(material);
                ingotStack = ChemicalHelper.get((TagPrefix)(hasHotIngot ? TagPrefix.ingotHot : TagPrefix.ingot), (Material)material);
                if (ingotStack.m_41619_() && oreProperty != null && (smeltingResult = oreProperty.getDirectSmeltResult()).isNull()) {
                    ingotStack = ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)smeltingResult);
                }
                if ((blastTemp = material.getBlastTemperature()) <= 0) {
                    if (!material.hasFlag(MaterialFlags.IS_MAGNETIC)) {
                        VanillaRecipeHelper.addSmeltingRecipe((String)(id + "_demagnetize_from_dust"), (ItemStack)dustStack, (ItemStack)ingotStack);
                    }
                } else {
                    IngotProperty ingotProperty = (IngotProperty)material.getProperty(PropertyKey.INGOT);
                    BlastProperty blastProperty = (BlastProperty)material.getProperty(PropertyKey.BLAST);
                    GTOMaterialRecipeHandler.processEBFRecipe(material, blastProperty, ingotStack);
                    if (!ingotProperty.getMagneticMaterial().isNull()) {
                        GTOMaterialRecipeHandler.processEBFRecipe(ingotProperty.getMagneticMaterial(), blastProperty, ingotStack);
                    }
                }
            }
        } else {
            Material smeltingResult;
            if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && !material.hasFlag(MaterialFlags.EXCLUDE_PLATE_COMPRESSOR_RECIPE)) {
                GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_plate_" + id).inputItems(dustStack).outputItems(TagPrefix.plate, material).EUt((long)GTValues.VA[0]).duration((int)material.getMass()).save();
            }
            if (oreProperty != null && (smeltingResult = oreProperty.getDirectSmeltResult()).isNull() && !(ingotStack = ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)smeltingResult)).m_41619_()) {
                VanillaRecipeHelper.addSmeltingRecipe((String)(id + "_dust_to_ingot"), (ItemStack)dustStack, (ItemStack)ingotStack);
            }
        }
    }

    private static void processSmallDust(Material material) {
        ItemStack stack1 = ChemicalHelper.get((TagPrefix)TagPrefix.dustSmall, (Material)material, (int)4);
        if (stack1.m_41619_()) {
            return;
        }
        ItemStack stack2 = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)material);
        GTORecipeTypes.PACKER_RECIPES.recipeBuilder("package_" + material.getName() + "_small_dust").inputItems(stack1).outputItems(stack2).save();
        GTORecipeTypes.UNPACKER_RECIPES.recipeBuilder("unpackage_" + material.getName() + "_small_dust").inputItems(stack2).circuitMeta(1).outputItems(stack1).save();
    }

    private static void processTinyDust(Material material) {
        ItemStack stack1 = ChemicalHelper.get((TagPrefix)TagPrefix.dustTiny, (Material)material, (int)9);
        if (stack1.m_41619_()) {
            return;
        }
        ItemStack stack2 = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)material);
        GTORecipeTypes.PACKER_RECIPES.recipeBuilder("package_" + material.getName() + "_tiny_dust").inputItems(stack1).outputItems(stack2).save();
        GTORecipeTypes.UNPACKER_RECIPES.recipeBuilder("unpackage_" + material.getName() + "_tiny_dust").inputItems(stack2).circuitMeta(2).outputItems(stack1).save();
    }

    private static void processEBFRecipe(Material material, BlastProperty property, ItemStack output) {
        AlloyBlastProperty alloyBlastProperty;
        int EUt;
        if (material.hasFlag(GTOMaterialFlags.COMPOSITE_MATERIAL)) {
            return;
        }
        int blastTemp = property.getBlastTemperature();
        BlastProperty.GasTier gasTier = property.getGasTier();
        int duration = property.getDurationOverride();
        if (duration <= 0) {
            duration = Math.max(1, (int)(material.getMass() * (long)blastTemp / 50L));
        }
        if ((EUt = property.getEUtOverride()) <= 0) {
            EUt = GTValues.VA[2];
        }
        RecipeBuilder blastBuilder = GTORecipeTypes.BLAST_RECIPES.recipeBuilder("blast_" + material.getName()).inputItems(TagPrefix.dust, material).outputItems(output).blastFurnaceTemp(blastTemp).EUt((long)EUt);
        if (gasTier != null) {
            FluidIngredient gas = property.getGasTier().getFluid();
            blastBuilder.copy("blast_" + material.getName()).circuitMeta(1).duration(duration).save();
            blastBuilder.copy("blast_" + material.getName() + "_gas").circuitMeta(2).inputFluids(new FluidIngredient[]{gas}).duration((int)((double)duration * 0.67)).save();
        } else {
            blastBuilder.duration(duration);
            if (material == GTMaterials.Silicon) {
                blastBuilder.circuitMeta(1);
            }
            blastBuilder.save();
        }
        if (TagPrefix.ingotHot.doGenerateItem(material)) {
            int vacuumDuration;
            int vacuumEUt = property.getVacuumEUtOverride() != -1 ? property.getVacuumEUtOverride() : GTValues.VA[2];
            int n = vacuumDuration = property.getVacuumDurationOverride() != -1 ? property.getVacuumDurationOverride() : (int)material.getMass() * 3;
            if (blastTemp < 5000) {
                GTORecipeTypes.VACUUM_RECIPES.recipeBuilder("cool_hot_" + material.getName() + "_ingot").inputItems(TagPrefix.ingotHot, material).outputItems(TagPrefix.ingot, material).duration(vacuumDuration).EUt((long)vacuumEUt).save();
            } else {
                GTORecipeTypes.VACUUM_RECIPES.recipeBuilder("cool_hot_" + material.getName() + "_ingot").inputItems(TagPrefix.ingotHot, material).inputFluids(GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID, 500)).outputItems(TagPrefix.ingot, material).outputFluids(GTMaterials.Helium.getFluid(250)).duration(vacuumDuration).EUt((long)vacuumEUt).save();
            }
        }
        if ((alloyBlastProperty = (AlloyBlastProperty)material.getProperty(PropertyKey.ALLOY_BLAST)) != null) {
            alloyBlastProperty.getRecipeProducer().produce(material, property);
        }
    }
}

