/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.research;

import com.gregtechceu.gtceu.api.GTValues;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.data.recipe.builder.research.ExResearchManager;
import com.gtolib.api.recipe.RecipeBuilder;
import java.util.Arrays;
import net.minecraft.world.item.ItemStack;

public final class DataIntegrationRecipeBuilder {
    private int[] inputData = new int[0];
    private int outputData;
    private int chanced;
    private int errorWeight = 2000;
    private ItemStack catalyst1;
    private ItemStack catalyst2;
    private long eut = GTValues.VA[6];
    private int cwut = 0;
    private int totalCWU = 0;

    public static DataIntegrationRecipeBuilder buildRecipe() {
        return new DataIntegrationRecipeBuilder();
    }

    public DataIntegrationRecipeBuilder catalyst1(ItemStack catalyst) {
        this.catalyst1 = catalyst;
        return this;
    }

    public DataIntegrationRecipeBuilder catalyst2(ItemStack catalyst) {
        this.catalyst2 = catalyst;
        return this;
    }

    public DataIntegrationRecipeBuilder inputData(int data) {
        if (this.inputData.length > 10) {
            return this;
        }
        this.inputData = Arrays.copyOf(this.inputData, this.inputData.length + 1);
        this.inputData[this.inputData.length - 1] = data;
        return this;
    }

    public DataIntegrationRecipeBuilder outputData(int data, int chanced) {
        this.outputData = data;
        this.chanced = chanced;
        return this;
    }

    public DataIntegrationRecipeBuilder errorWeight(int weight) {
        if (weight < 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u6570\u636e\u6743\u91cd\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        this.errorWeight = weight;
        return this;
    }

    public DataIntegrationRecipeBuilder EUt(long eut) {
        this.eut = eut;
        return this;
    }

    public DataIntegrationRecipeBuilder CWUt(int cwut) {
        this.cwut = cwut;
        this.totalCWU = cwut * 800;
        return this;
    }

    public DataIntegrationRecipeBuilder CWUt(int cwut, int totalCWU) {
        this.cwut = cwut;
        this.totalCWU = totalCWU;
        return this;
    }

    public void save() {
        if (this.cwut > this.totalCWU) {
            throw new IllegalStateException("Total CWU cannot be greater than CWU/t!");
        }
        if (this.catalyst1 == null || this.catalyst2 == null) {
            throw new IllegalStateException("Catalyst input required");
        }
        if (this.inputData == null) {
            throw new IllegalStateException("Missing input items");
        }
        ExResearchManager.DataCrystal dataCrystal = (ExResearchManager.DataCrystal)ExResearchManager.analyzeMap.get(this.outputData);
        if (dataCrystal == null) {
            throw new IllegalStateException("Unknown output items");
        }
        int crystalTire = dataCrystal.tier();
        int originalTotalWeight = this.chanced + this.errorWeight;
        int normalizedOutput = (int)((double)this.chanced / (double)originalTotalWeight * 10000.0);
        int normalizedError = (int)((double)this.errorWeight / (double)originalTotalWeight * 10000.0);
        int difference = 10000 - normalizedOutput - normalizedError;
        if (difference != 0) {
            normalizedError += difference;
        }
        RecipeBuilder build = GTORecipeTypes.DATA_INTEGRATION_RECIPES.recipeBuilder(dataCrystal.data());
        build.notConsumable(this.catalyst1).notConsumable(this.catalyst2).inputItems(ExResearchManager.EmptyDataCrystalList.get(crystalTire));
        for (int inputAnalyzeDatum : this.inputData) {
            build.notConsumable(ExResearchManager.getDataCrystal(inputAnalyzeDatum));
        }
        build.chancedOutput(ExResearchManager.getDataCrystal(this.outputData), normalizedOutput, 0).chancedOutput(ExResearchManager.ErrorDataCrystalList.get(crystalTire), normalizedError, 0).EUt(this.eut).CWUt(this.cwut).totalCWU(this.totalCWU).save();
    }
}

