/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.config;

import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gtocore.config.Difficulty;
import com.gtocore.config.SparkRange;
import com.gtolib.GTOCore;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.Config;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.UpdateRestrictions;
import dev.toma.configuration.config.format.ConfigFormats;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import dev.toma.configuration.config.io.ConfigIO;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ObjectValue;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.embeddedt.modernfix.spark.SparkLaunchProfiler;

@Config(id="gtocore", group="gtocore")
@DataGeneratorScanned
public final class GTOConfig {
    @RegisterLanguage(en="GTO Core Config", cn="GTO Core \u914d\u7f6e")
    private static final String SCREEN = "config.screen.gtocore";
    public static final GTOConfig INSTANCE;
    @Configurable
    @Configurable.Comment(value={"\u6e38\u620f\u96be\u5ea6\u7b49\u7ea7", "Game difficulty level"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Game Difficulty", cn="\u6e38\u620f\u96be\u5ea6")
    public Difficulty difficulty = Difficulty.Normal;
    @Configurable
    @Configurable.Comment(value={"\u542f\u7528\u81ea\u6211\u7ea6\u675f\u6a21\u5f0f\u4ee5\u9650\u5236\u4efb\u4f55\u5f62\u5f0f\u7684\u4f5c\u5f0a\u6307\u4ee4\u4f7f\u7528\uff08\u8b66\u544a\uff1a\u4e00\u65e6\u5f00\u542f\uff0c\u6e38\u73a9\u7684\u5b58\u6863\u5c06\u6c38\u4e45\u9501\u5b9a\u81ea\u6211\u7ea6\u675f\u6a21\u5f0f\uff01\uff09", "Enable Self Restraint Mode to restrict the use of any form of cheat commands (Warning: Once enabled, the played save will be permanently locked in Self Restraint Mode!)"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Self Restraint Mode", cn="\u81ea\u6211\u7ea6\u675f\u6a21\u5f0f")
    public boolean selfRestraint = false;
    @Configurable
    @RegisterLanguage(namePrefix="config.gtocore.option", en="disable Muffler Part", cn="\u7981\u7528\u6d88\u58f0\u4ed3")
    @Configurable.Comment(value={"\u7981\u7528\u540e\u5931\u53bb\u638f\u7070\u73a9\u6cd5(\u5728\u975e\u4e13\u5bb6\u6a21\u5f0f\u751f\u6548)", "Removing this disables Ash-Scooping gameplay (only applies in non-Expert mode)"})
    public boolean disableMufflerPart = false;
    @Configurable
    @Configurable.Range(min=36L, max=216L)
    @Configurable.Comment(value={"\u6269\u5c55\u6837\u677f\u4f9b\u5e94\u5668\u5bb9\u91cf", "\u4e13\u5bb6\u6a21\u5f0f\u4e0b\uff0c\u6b64\u9009\u9879\u65e0\u6548", "Extended Pattern Provider Size", "In Expert mode, this option is invalid"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Extended Pattern Provider Size", cn="\u6269\u5c55\u6837\u677f\u4f9b\u5e94\u5668\u5bb9\u91cf")
    @Configurable.Gui.Slider
    public int exPatternSize = 36;
    @Configurable
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Default Value for Rename Pattern", cn="\u91cd\u547d\u540d\u6837\u677f\u7684\u9ed8\u8ba4\u503c")
    @Configurable.Comment(value={"\u5728\u88c5\u914d\u7ebf\u6a21\u5f0f\u7f16\u7801\u5e26\u6709\u91cd\u547d\u540d\u7269\u54c1\u7684\u6837\u677f\u65f6\u4f7f\u7528\u7684\u9ed8\u8ba4\u540d\u5b57", "The default name used when encoding patterns with renamed items in assembly line mode"})
    public String renamePatternDefaultString = "";
    @Configurable
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Allow Missing Crafting Jobs", cn="\u5141\u8bb8\u4e0b\u5355\u7f3a\u5c11\u6750\u6599\u7684\u5408\u6210\u4efb\u52a1")
    @Configurable.Comment(value={"\u5141\u8bb8\u5728 AE2 \u4e2d\u4e0b\u5355\u7f3a\u5c11\u539f\u6599\u7684\u4efb\u52a1", "\u7f3a\u5c11\u7684\u539f\u6599\u5c06\u4ee5\u201c\u6b63\u5728\u5408\u6210\u201d\u7684\u72b6\u6001\u88ab\u7b49\u5f85\u63a5\u6536", "Allow placing orders for tasks that are missing ingredients in AE2", "Missing ingredients will be in a 'crafting' state waiting to be received"})
    public boolean allowMissingCraftingJobs = true;
    @Configurable
    @Configurable.Comment(value={"\u542f\u7528\u540e\uff0c\u4e14\u672a\u5f00\u542f EMI \u4f5c\u5f0a\u65f6\uff0cEMI \u7684\u4f5c\u5f0a\u4ea4\u4e92\u529f\u80fd\u5c06\u8f6c\u4e3a\u8bd5\u56fe\u4ece\u73b0\u6709\u7684ME\u7ec8\u7aef/\u65e0\u7ebf\u7ec8\u7aef\u4e2d\u63d0\u53d6\u7269\u54c1", "When enabled, and EMI cheats are not enabled, EMI's cheat interaction feature will attempt to extract items from existing ME Terminals/Wireless Terminals"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Non-Cheat EMI Interaction", cn="\u975e\u4f5c\u5f0a\u65f6EMI\u4ea4\u4e92")
    public boolean nonCheatEmiInteraction = true;
    @Configurable
    @Configurable.Comment(value={"\u542f\u7528\u540e\uff0c\u4e14\u672a\u5f00\u542f EMI \u4f5c\u5f0a\u65f6\uff0c\u5728 EMI \u754c\u9762\u4e2d\u60ac\u505c\u7269\u54c1\u65f6\uff0c\u5c06\u663e\u793a AE \u7cfb\u7edf\u4e2d\u8be5\u7269\u54c1\u7684\u6570\u91cf\u4fe1\u606f", "When enabled, and EMI cheats are not enabled, hovering over an item in the EMI interface will show the quantity information of that item in the AE system"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Show AE Amount Tooltip Everywhere in EMI", cn="\u5728EMI\u663e\u793a AE \u6570\u91cf\u63d0\u793a")
    public boolean showAEAmountTooltipEverywhereEmi = true;
    @Configurable
    @Configurable.Comment(value={"\u5feb\u901f\u52a0\u8f7d\u591a\u65b9\u5757\u7ed3\u6784\u9875\u9762\uff0c\u51cf\u5c11\u4e0d\u5fc5\u8981\u7684\u52a0\u8f7d\u65f6\u95f4", "Fast loading of multiblock structure pages to reduce unnecessary loading time"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Fast Multiblock Page Loading", cn="\u5feb\u901f\u591a\u65b9\u5757\u9875\u9762\u52a0\u8f7d")
    public boolean fastMultiBlockPage = true;
    @Configurable
    @Configurable.Comment(value={"\u6279\u5904\u7406\u6a21\u5f0f\u7684\u6700\u5927\u6301\u7eed\u65f6\u95f4\uff08tick\uff09", "Maximum duration of batch processing mode (ticks)"})
    @Configurable.Range(min=600L, max=144000L)
    @Configurable.Gui.Slider
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Batch Processing Max Duration", cn="\u6279\u5904\u7406\u6a21\u5f0f\u6700\u5927\u6301\u7eed\u65f6\u95f4")
    public int batchProcessingMaxDuration = 1200;
    @Configurable
    @Configurable.Comment(value={"\u8fde\u9501\u6316\u6398\uff08\u4e0d\u8fde\u7eed\u6a21\u5f0f\uff09\u65f6\uff0c\u68c0\u67e5\u76f8\u90bb\u65b9\u5757\u7684\u8303\u56f4", "The range to check adjacent blocks during chain mining (non-continuous mode)"})
    @Configurable.Range(min=1L, max=20L)
    @Configurable.Gui.Slider
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Chain Mining Range", cn="\u8fde\u9501\u6316\u6398\u68c0\u67e5\u8303\u56f4")
    public int ftbUltimineRange = 3;
    @Configurable
    @Configurable.Comment(value={"\u8fde\u9501\u6316\u6398\u529f\u80fd\u7684\u65b9\u5757\u9ed1\u540d\u5355", "Block blacklist for chain mining feature"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Chain Mining Blacklist", cn="\u8fde\u9501\u6316\u6398\u9ed1\u540d\u5355")
    public String[] breakBlocksBlackList = new String[]{"ae2:cable_bus"};
    @Configurable
    @Configurable.Comment(value={"\u7981\u7528\u540e\uff0c\u4e0d\u540c\u5b58\u6863\u7684 EMI \u6536\u85cf\u5939\u5c06\u76f8\u4e92\u72ec\u7acb", "After disabling, EMI favorites from different saves will be independent of each other"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="EMI Global Favorites", cn="EMI \u5168\u5c40\u6536\u85cf\u5939")
    public boolean emiGlobalFavorites = true;
    @Configurable
    @Configurable.Comment(value={"\u7981\u7528\u7206\u5f39\u7269\u54c1\u7684\u4f7f\u7528", "\u8b66\u544a\uff1a\u7206\u5f39\u4f1a\u9020\u6210\u6781\u5927\u8303\u56f4\u7684\u7834\u574f\uff01\u5982\u679c\u4f60\u4e0d\u60f3\u7206\u5f39\u7834\u574f\u91cd\u8981\u7684\u4e1c\u897f\uff0c\u8bf7\u786e\u4fdd\u63d0\u524d\u5907\u4efd\u5b58\u6863\u3002", "Disable the use of Charge Bomb items", "Warning: Charge Bombs can cause massive destruction! If you don't want Charge Bombs to destroy important things, make sure to back up your save in advance."})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Disable Charge Bomb", cn="\u7981\u7528\u7206\u5f39")
    public boolean disableChargeBomb = false;
    @Configurable
    @Configurable.Comment(value={"\u5728\u7269\u54c1\u4e0b\u65b9\u663e\u793a\u82f1\u6587\u540d\u79f0", "\u540c\u65f6\u5141\u8bb8\u5728ME\u7ec8\u7aef\u4e2d\u4f7f\u7528\u82f1\u6587\u540d\u79f0\u641c\u7d22\u7269\u54c1", "Show the English name below the item", "Also allows searching for items by English name in ME Terminals"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Show Item English Name", cn="\u663e\u793a\u7269\u54c1\u82f1\u6587\u540d\u79f0")
    public boolean showEnglishName = false;
    @Configurable
    @Configurable.Comment(value={"\u8c03\u6574\u76d1\u63a7\u5668\u7684\u6700\u5927\u6210\u578b\u5c3a\u5bf8", "Adjust the maximum formed size of the monitor"})
    @Configurable.Range(min=4L, max=64L)
    @Configurable.Gui.Slider
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Maximum Monitor Size", cn="\u76d1\u63a7\u5668\u6700\u5927\u5c3a\u5bf8")
    public int maxMonitorSize = 16;
    @Configurable
    @Configurable.Comment(value={"\u5f15\u96f7\u9488\u5728\u5de5\u4f5c\u65f6\u662f\u5426\u751f\u6210\u95ea\u7535\u7279\u6548", "Whether the lightning rod generates lightning effects when working"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Lightning Rod Effect", cn="\u5f15\u96f7\u9488\u7279\u6548")
    public boolean lightningRodEffect = true;
    @Configurable
    @Configurable.Comment(value={"\u542f\u7528\u5185\u7f6e\u591c\u89c6\u3002\u8be5\u6548\u679c\u4e5f\u53ef\u5728\u6e38\u620f\u5185\u6309\u7ed1\u5b9a\u70ed\u952e\u5207\u6362", "Enable built-in night vision. This effect can also be toggled in-game by pressing the bound hotkey"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Built-in Night Vision", cn="\u5185\u7f6e\u591c\u89c6")
    public boolean nightVision = false;
    @Configurable
    @Configurable.Comment(value={"\u7981\u7528\u540e\u5c06\u6e32\u67d3\u89c6\u89d2\u5916\uff0c\u4e14\u6e32\u67d3\u5668\u88ab\u6807\u8bb0\u4e3aGlobal\u7684\u673a\u5668\uff0c\u4e00\u4e9b\u9ad8\u7ea7\u7279\u6548\u673a\u5668\u9700\u8981\u5f00\u542f\u6b64\u9009\u9879\u624d\u80fd\u6b63\u5e38\u6e32\u67d3", "When turned disable, machines that are outside the field of view and whose renderer is marked as Global will be rendered. Some advanced effect machines need to turn on this option to render properly"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Disable Embeddium Global BE Culling", cn="\u7981\u7528Embbedium Global\u65b9\u5757\u5b9e\u4f53\u5254\u9664")
    public boolean disableEmbeddiumBECulling = true;
    @Configurable
    @Configurable.Comment(value={"\u542f\u7528\u540e\uff0c\u8fdb\u5165\u6e38\u620f\u65f6\uff0c\u82e5\u591a\u65b9\u5757\u7ed3\u6784\u672a\u80fd\u6210\u578b\uff0c\u5219\u5c06\u9519\u8bef\u4fe1\u606f\u5c06\u53d1\u9001\u7ed9\u673a\u5668\u7684\u6240\u6709\u8005", "When enabled, if the multiblock structure fails to form when entering the game, the error message will be sent to the owner of the machine"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Send Multiblock Error Messages", cn="\u53d1\u9001\u591a\u65b9\u5757\u9519\u8bef\u4fe1\u606f")
    public boolean sendMultiblockErrorMessages = true;
    @Configurable
    @Configurable.Comment(value={"\u4e00\u4e9b\u673a\u5668\u5185\u5bb9\u4f1a\u4ee5\u670d\u52a1\u5668\u8bed\u8a00\u7684\u7ffb\u8bd1\u5448\u73b0", "Some machine contents will be presented in the server language translation"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Server language", cn="\u670d\u52a1\u5668\u8bed\u8a00")
    public String serverLang = "en_us";
    @Configurable
    @Configurable.UpdateRestriction(value=UpdateRestrictions.GAME_RESTART)
    @Configurable.Comment(value={"\u542f\u7528\u81ea\u5b9a\u4e49\u914d\u65b9", "\u81ea\u5b9a\u4e49\u914d\u65b9\u8be6\u60c5\u4e0e\u6559\u7a0b\u53c2\u89c1https://gtodyssey.com/zh-hans/%E6%95%B4%E5%90%88%E5%8C%85%E6%95%99%E5%AD%A6/%E5%AE%98%E6%96%B9%E6%96%87%E6%A1%A3/%E5%A6%82%E4%BD%95%E4%BF%AE%E6%94%B9gto%E9%85%8D%E6%96%B9/", "\u6ce8\u610f\uff1a\u542f\u7528\u6b64\u9009\u9879\u540e\uff0c\u82e5\u52a0\u8f7d\u9519\u8bef\u7684\u914d\u65b9\u811a\u672c\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u8fdb\u5165\u6e38\u620f\u540e\u914d\u65b9\u4e22\u5931\uff0c\u8bf7\u52a1\u5fc5\u5728\u975e\u5e38\u89c4\u6e38\u73a9\u5b58\u6863\u4e2d\u6d4b\u8bd5\u914d\u65b9\u811a\u672c\u7684\u6b63\u786e\u6027\u3002", "\u6ce8\u610f\uff1a\u5728\u670d\u52a1\u5668\u4e0a\u6e38\u73a9\u65f6\uff0c\u670d\u52a1\u5668\u548c\u5ba2\u6237\u7aef\u5747\u9700\u542f\u7528\u6b64\u9009\u9879\u4e14\u4f7f\u7528\u76f8\u540c\u7684\u914d\u65b9\u811a\u672c\u6587\u4ef6\u3002", "Enable custom recipes", "For details and tutorials on custom recipes, please refer to https://gtodyssey.com/zh-hans/%E6%95%B4%E5%90%88%E5%8C%85%E6%95%99%E5%AD%A6/%E5%AE%98%E6%96%B9%E6%96%87%E6%A1%A3/%E5%A6%82%E4%BD%95%E4%BF%AE%E6%94%B9gto%E9%85%8D%E6%96%B9/", "Note: After enabling this option, if an incorrect recipe script is loaded, it may cause recipes to be lost after entering the game. Please be sure to test the correctness of the recipe script in a non-conventional play save.", "Note: When playing on a server, both the server and client need to enable this option and use the same recipe script file."})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Enable Custom Recipes", cn="\u542f\u7528\u81ea\u5b9a\u4e49\u914d\u65b9")
    public boolean enableCustomRecipes = false;
    @Configurable
    @Configurable.Comment(value={"\u5f00\u542f\u5f00\u53d1\u8005\u6a21\u5f0f", "Enable Developer Mode"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Developer Mode", cn="\u5f00\u53d1\u8005\u6a21\u5f0f")
    public boolean dev = false;
    @Configurable
    @Configurable.Comment(value={"\u542f\u7528\u540e\u5c06\u663e\u793a\u8be6\u7ec6\u7684\u542f\u52a8\u65e5\u5fd7\u8f93\u51fa\uff0c\u5305\u542b\u6240\u6709 DEBUG \u7ea7\u522b\u7684\u65e5\u5fd7\uff08\u589e\u52a0\u65e5\u5fd7\u6587\u4ef6\u5927\u5c0f\u4f46\u4fbf\u4e8e\u8c03\u8bd5\uff09", "When enabled, shows detailed startup log output including all DEBUG level logs (increases log file size but useful for debugging)"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="[Debug] Detailed Logging", cn="[\u8c03\u8bd5] \u8be6\u7ec6\u65e5\u5fd7\u8f93\u51fa")
    public boolean detailedLogging = false;
    @Configurable
    @Configurable.Comment(value={"\u68c0\u67e5\u914d\u65b9\u4e4b\u95f4\u7684\u51b2\u7a81\u95ee\u9898", "Check for conflicts between recipes"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="[Debug] Recipe Conflict Check", cn="[\u8c03\u8bd5] \u914d\u65b9\u51b2\u7a81\u68c0\u67e5")
    public boolean recipeCheck = false;
    @Configurable
    @Configurable.Comment(value={"\u542f\u7528 AE2 \u548c\u540c\u6b65\u7ec4\u4ef6\u7684\u8be6\u7ec6\u65e5\u5fd7", "Enable detailed logging for AE2 and sync components"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="[Debug] AE2 & Sync Logging", cn="[\u8c03\u8bd5] AE2 \u548c\u540c\u6b65\u65e5\u5fd7")
    public boolean aeLog = false;
    @Configurable
    @Configurable.Comment(value={"\u542f\u7528 AE2 \u65e0\u7ebf\u7f51\u7edc\u8c03\u8bd5\u65e5\u5fd7", "Enable AE2 wireless network debug logging"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="[Debug] AE2 & Sync Logging", cn="[\u8c03\u8bd5] AE2 \u65e0\u7ebf\u7f51\u7edc\u8c03\u8bd5\u65e5\u5fd7")
    public boolean aeWirelessLog = false;
    @Configurable
    @Configurable.Comment(value={"AE2 \u65e0\u7ebf\u7f51\u7edc\u4f7f\u7528\u7684\u5b58\u50a8\u952e\uff0c\u5207\u6362\u540e\u5c06\u4f7f\u7528\u65b0\u7684\u5b58\u50a8\u952e\u91cd\u65b0\u751f\u6210\u7f51\u7edc\uff08\u8b66\u544a\uff1a\u5207\u6362\u540e\u6240\u6709AE\u65e0\u7ebf\u8bbe\u5907\u7684\u8bbe\u7f6e\u5c06\u91cd\u7f6e\uff01\uff09", "The storage key used by the AE2 wireless network. After switching, a new storage key will be used to regenerate the network (Warning: After switching, all AE wireless device settings will be reset!)"})
    @RegisterLanguage(namePrefix="config.gtocore.option", cn="AE2 \u7f51\u683c\u5b58\u50a8\u952e", en="AE2 Grid Storage Key")
    public String aeGridKey = "four";
    @Configurable
    @Configurable.Comment(value={"Spark \u6027\u80fd\u5206\u6790\u5668\u7684\u542f\u52a8\u9636\u6bb5", "The startup phase of the Spark profiler"})
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Spark Profiler Start Phase", cn="Spark \u5206\u6790\u5668\u542f\u52a8\u9636\u6bb5")
    public SparkRange startSpark = SparkRange.NONE;
    @Configurable
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Travel Settings", cn="\u65c5\u884c\u624b\u6756/\u65c5\u884c\u951a\u8bbe\u7f6e")
    public TravelConfig travelConfig = new TravelConfig();
    @Configurable
    @RegisterLanguage(namePrefix="config.gtocore.option", en="Mob Settings", cn="\u751f\u7269\u8bbe\u7f6e")
    public MobConfig mobConfig = new MobConfig();
    @Configurable
    @RegisterLanguage(namePrefix="config.gtocore.option", en="HUD Settings", cn="HUD \u8bbe\u7f6e")
    public HUDConfig hud = new HUDConfig();

    public static <T> void set(String fieldName, T value) {
        ConfigHolder.getConfig((String)"gtocore").ifPresent(config -> {
            ((ConfigValue)config.getValueMap().get(fieldName)).setValue(value);
            ConfigIO.saveClientValues((ConfigHolder)config);
            ConfigIO.reloadClientValues((ConfigHolder)config);
        });
    }

    public static <T> void set(String fieldName, T value, String ... objectPath) {
        if (objectPath.length == 0) {
            GTOConfig.set(fieldName, value);
            return;
        }
        ConfigHolder.getConfig((String)"gtocore").ifPresent(config -> {
            ObjectValue valueMap0 = (ObjectValue)config.getValueMap().get(objectPath[0]);
            if (objectPath.length == 1) {
                ((ConfigValue)valueMap0.getChildById(fieldName)).setValue(value);
            } else {
                for (int i = 1; i < objectPath.length; ++i) {
                    valueMap0 = (ObjectValue)valueMap0.getChildById(objectPath[i]);
                }
                ((ConfigValue)valueMap0.getChildById(fieldName)).setValue(value);
            }
            ConfigIO.saveClientValues((ConfigHolder)config);
            ConfigIO.reloadClientValues((ConfigHolder)config);
        });
    }

    static {
        int difficulty;
        com.gregtechceu.gtceu.config.ConfigHolder.init();
        INSTANCE = (GTOConfig)Configuration.registerConfig(GTOConfig.class, (IConfigFormatHandler)ConfigFormats.YAML).getConfigInstance();
        if (GTOConfig.INSTANCE.startSpark == SparkRange.ALL || GTOConfig.INSTANCE.startSpark == SparkRange.MAIN_MENU) {
            SparkLaunchProfiler.start((String)"all");
        }
        if (GTOConfig.INSTANCE.dev) {
            Configurator.setRootLevel((Level)Level.INFO);
        }
        if (GTOConfig.INSTANCE.detailedLogging) {
            Configurator.setRootLevel((Level)Level.DEBUG);
        }
        GTOCore.difficulty = difficulty = GTOConfig.INSTANCE.difficulty.ordinal() + 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.generateLowQualityGems = false;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.disableManualCompression = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.harderRods = difficulty == 3;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.harderBrickRecipes = difficulty == 3;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.nerfWoodCrafting = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.hardWoodRecipes = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.hardIronRecipes = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.hardRedstoneRecipes = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.hardToolArmorRecipes = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.hardMiscRecipes = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.hardGlassRecipes = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.nerfPaperCrafting = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.hardAdvancedIronRecipes = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.hardDyeRecipes = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.harderCharcoalRecipe = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.flintAndSteelRequireSteel = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.removeVanillaBlockRecipes = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.removeVanillaTNTRecipe = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.casingsPerCraft = Math.max(1, 3 - difficulty);
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.harderCircuitRecipes = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.hardMultiRecipes = difficulty == 3;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.recipes.enchantedTools = difficulty == 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.compat.energy.nativeEUToFE = true;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.compat.energy.enableFEConverters = false;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.compat.energy.feToEuRatio = 20;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.compat.energy.euToFeRatio = 16;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.compat.ae2.meHatchEnergyUsage = 32 * difficulty;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.compat.showDimensionTier = true;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.worldgen.rubberTreeSpawnChance = (float)(2.0 - 0.5 * (double)difficulty);
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.worldgen.allUniqueStoneTypes = true;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.worldgen.oreVeins.removeVanillaOreGen = false;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.worldgen.oreVeins.removeVanillaLargeOreVeins = true;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.worldgen.oreVeins.bedrockOreDistance = difficulty;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.worldgen.oreVeins.infiniteBedrockOresFluids = difficulty == 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.worldgen.oreVeins.oreIndicators = true;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.worldgen.oreVeins.oreGenerationChunkCacheSize = 512;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.worldgen.oreVeins.oreIndicatorChunkCacheSize = 2048;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.recipeProgressLowEnergy = difficulty == 3;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.requireGTToolsForBlocks = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.shouldWeatherOrTerrainExplosion = difficulty == 3;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.energyUsageMultiplier = 100 * difficulty;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.prospectorEnergyUseMultiplier = 100 * difficulty;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.doesExplosionDamagesTerrain = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.harmlessActiveTransformers = difficulty == 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.steelSteamMultiblocks = false;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.enableCleanroom = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.cleanMultiblocks = difficulty == 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.replaceMinedBlocksWith = "minecraft:cobblestone";
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.enableResearch = true;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.enableMaintenance = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.dualChamberPressurizationMode = difficulty == 3 ? 3 : 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.enableWorldAccelerators = true;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.gt6StylePipesCables = true;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.doBedrockOres = true;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.bedrockOreDropTagPrefix = "raw";
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.minerSpeed = 80;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.enableTieredCasings = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.ldItemPipeMinDistance = 50;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.ldFluidPipeMinDistance = 50;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.onlyOwnerGUI = false;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.onlyOwnerBreak = false;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.ownerOPBypass = 2;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.highTierContent = true;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.orderedAssemblyLineItems = difficulty > 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.orderedAssemblyLineFluids = difficulty == 3;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.steamMultiParallelAmount = 8;
        int boilerFactor = 8 >> difficulty;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.smallBoilers.solidBoilerBaseOutput = 120 * boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.smallBoilers.hpSolidBoilerBaseOutput = 300 * boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.smallBoilers.liquidBoilerBaseOutput = 240 * boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.smallBoilers.hpLiquidBoilerBaseOutput = 600 * boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.smallBoilers.solarBoilerBaseOutput = 80 * boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.smallBoilers.hpSolarBoilerBaseOutput = 240 * boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.largeBoilers.steamPerWater = 160 * boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.largeBoilers.bronzeBoilerMaxTemperature = 800 * boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.largeBoilers.bronzeBoilerHeatSpeed = boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.largeBoilers.steelBoilerMaxTemperature = 1800 * boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.largeBoilers.steelBoilerHeatSpeed = boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.largeBoilers.titaniumBoilerMaxTemperature = 3200 * boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.largeBoilers.titaniumBoilerHeatSpeed = boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.largeBoilers.tungstensteelBoilerMaxTemperature = 6400 * boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.machines.largeBoilers.tungstensteelBoilerHeatSpeed = boilerFactor;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.rngDamageElectricTools = 5 << difficulty;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.sprayCanChainLength = 16;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.treeFellingDelay = 2;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.voltageTierNightVision = 1;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.voltageTierNanoSuit = 3;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.voltageTierAdvNanoSuit = 3;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.voltageTierQuarkTech = 5;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.voltageTierAdvQuarkTech = 6;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.voltageTierImpeller = 2;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.voltageTierAdvImpeller = 3;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.nanoSaber.nanoSaberDamageBoost = 256 >> difficulty;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.nanoSaber.nanoSaberBaseDamage = 1.0;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.nanoSaber.zombieSpawnWithSabers = true;
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.tools.nanoSaber.energyConsumption = 64;
        if (GTOCore.isEasy()) {
            com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.gameplay.hazardsEnabled = false;
        }
        com.gregtechceu.gtceu.config.ConfigHolder.INSTANCE.dev.debug = GTOConfig.INSTANCE.dev;
        MultiblockControllerMachine.sendMessage = GTOConfig.INSTANCE.sendMultiblockErrorMessages;
    }

    @DataGeneratorScanned
    public static class TravelConfig {
        @Configurable
        @Configurable.Range(min=0L, max=1200L)
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Travel Staff Cooldown (ticks)", cn="\u65c5\u884c\u6743\u6756\u51b7\u5374\u65f6\u95f4\uff08tick\uff09")
        @Configurable.Comment(value={"\u65c5\u884c\u6743\u6756\u4f7f\u7528\u540e\u7684\u51b7\u5374\u65f6\u95f4\uff08tick\uff09", "Cooldown time after using the Staff of Travelling (ticks)"})
        @Configurable.Gui.Slider
        public int travelStaffCooldown = 5;
        @Configurable
        @Configurable.Range(min=4L, max=512L)
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Travel Anchor Block Range (blocks)", cn="\u65c5\u884c\u951a\u65b9\u5757\u8303\u56f4\uff08\u683c\uff09")
        @Configurable.Comment(value={"\u951a\u5230\u951a\u4e4b\u95f4\u7684\u6700\u5927\u4f20\u9001\u8ddd\u79bb\uff08\u683c\uff09", "The maximum teleportation distance between anchors (blocks)"})
        @Configurable.Gui.Slider
        public int blockRange = 96;
        @Configurable
        @Configurable.Range(min=4L, max=512L)
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Travel Anchor Item Range (blocks)", cn="\u65c5\u884c\u951a\u7269\u54c1\u8303\u56f4\uff08\u683c\uff09")
        @Configurable.Comment(value={"\u65c5\u884c\u624b\u6756\u5411\u951a\u70b9\u4f20\u9001\u7684\u6700\u5927\u8ddd\u79bb\uff08\u683c\uff09", "The maximum distance (blocks) the Staff of Travelling can teleport to an anchor"})
        @Configurable.Gui.Slider
        public int itemRange = 192;
        @Configurable
        @Configurable.Range(min=4L, max=64L)
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Staff of Travelling Blink Range (blocks)", cn="\u65c5\u884c\u624b\u6756\u77ac\u79fb\u8303\u56f4\uff08\u683c\uff09")
        @Configurable.Comment(value={"\u65c5\u884c\u624b\u6756\u77ac\u79fb\u529f\u80fd\u7684\u6700\u5927\u8ddd\u79bb\uff08\u683c\uff09", "The maximum distance (blocks) for the Staff of Travelling's blink function"})
        @Configurable.Gui.Slider
        public int blinkRange = 24;
        @Configurable
        @Configurable.Comment(value={"\u542f\u7528\u540e\uff0c\u6837\u677f\u4f9b\u5e94\u5668/\u6837\u677f\u603b\u6210\u4f1a\u663e\u793a\u5728\u65c5\u884c\u624b\u6756\u7684\u8282\u70b9\u5217\u8868\u4e2d\uff0c\u4ee5\u4fbf\u6377\u4f20\u9001", "When enabled, Pattern Providers/Pattern Assemblers will appear in the node list of the Staff Of Travelling for easy teleportation"})
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Staff Of Travelling Pattern Nodes", cn="\u65c5\u884c\u624b\u6756\u6837\u677f\u8282\u70b9")
        public boolean staffOfTravellingPatternNodes = true;
    }

    @DataGeneratorScanned
    public static class MobConfig {
        @Configurable
        @Configurable.Comment(value={"\u5f53\u73a9\u5bb6\u5728\u67d0\u52a8\u7269\u9644\u8fd1\u98df\u7528\u5176\u6765\u6e90\u98df\u7269\u65f6\uff0c\u5f71\u54cd\u7684\u534a\u5f84\uff08\u683c\uff09", "The radius (blocks) affected when a player consumes food derived from an animal near that animal"})
        @Configurable.Range(min=1L, max=64L)
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Carnivory Punish Radius", cn="\u98df\u8089\u60e9\u7f5a\u534a\u5f84")
        @Configurable.Gui.Slider
        public int cannibalismRadius = 32;
        @Configurable
        @Configurable.Comment(value={"\u5f53\u73a9\u5bb6\u5728\u67d0\u52a8\u7269\u9644\u8fd1\u98df\u7528\u5176\u6765\u6e90\u98df\u7269\u65f6\uff0c\u5bf9\u8be5\u52a8\u7269\u9020\u6210\u7684\u4f24\u5bb3\u503c\uff08\u534a\u9897\u5fc3=1.0\uff09", "The amount of damage dealt to the animal when a player consumes food derived from that animal nearby (Half Heart = 1.0)"})
        @Configurable.Range(min=0L, max=100L)
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Carnivory Punish Damage", cn="\u98df\u8089\u60e9\u7f5a\u4f24\u5bb3")
        public float cannibalismDamage = 1.0f;
        @Configurable
        @Configurable.Comment(value={"\u542f\u7528\u540e\uff0c\u6240\u6709\u751f\u7269\u5c06\u80fd\u591f\u81ea\u7136\u56de\u8840", "When enabled, all mobs will naturally regenerate health"})
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Mob Natural Regeneration", cn="\u751f\u7269\u81ea\u7136\u56de\u8840")
        public boolean naturalRegeneration = true;
    }

    @DataGeneratorScanned
    public static class HUDConfig {
        @Configurable
        @Configurable.Comment(value={"\u542f\u7528\u65e0\u7ebf\u80fd\u91cf HUD \u663e\u793a", "Enable Wireless Energy HUD display"})
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Wireless Energy HUD Enabled", cn="\u65e0\u7ebf\u80fd\u91cf HUD \u542f\u7528")
        public boolean wirelessEnergyHUDEnabled = false;
        @Configurable
        @Configurable.Comment(value={"\u65e0\u7ebf\u80fd\u91cf HUD \u7684\u9ed8\u8ba4 X \u76f8\u5bf9\u4f4d\u7f6e", "0\u610f\u5473\u7740\u5c4f\u5e55\u5de6\u4fa7\uff0c100\u610f\u5473\u7740\u5c4f\u5e55\u53f3\u4fa7", "The default X relative position of the Wireless Energy HUD", "0.0 means the left side of the screen, 1.0 means the right side of the screen"})
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Wireless Energy HUD Default X", cn="\u65e0\u7ebf\u80fd\u91cf HUD \u9ed8\u8ba4 X \u4f4d\u7f6e")
        @Configurable.Range(min=0L, max=100L)
        @Configurable.Gui.Slider
        public int wirelessEnergyHUDDefaultX = 5;
        @Configurable
        @Configurable.Comment(value={"\u65e0\u7ebf\u80fd\u91cf HUD \u7684\u9ed8\u8ba4 Y \u76f8\u5bf9\u4f4d\u7f6e", "0\u610f\u5473\u7740\u5c4f\u5e55\u9876\u90e8\uff0c100\u610f\u5473\u7740\u5c4f\u5e55\u5e95\u90e8", "The default Y relative position of the Wireless Energy HUD", "0.0 means the top of the screen, 1.0 means the bottom of the screen"})
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Wireless Energy HUD Default Y", cn="\u65e0\u7ebf\u80fd\u91cf HUD \u9ed8\u8ba4 Y \u4f4d\u7f6e")
        @Configurable.Range(min=0L, max=100L)
        @Configurable.Gui.Slider
        public int wirelessEnergyHUDDefaultY = 75;
        @Configurable
        @Configurable.Comment(value={"\u65e0\u7ebf\u80fd\u91cf HUD \u663e\u793a\u7684\u5386\u53f2\u79d2\u6570", "\u4f8b\u5982\uff1a\u8bbe\u4e3a30\u5219\u663e\u793a\u8fc7\u53bb30\u79d2\u7684\u80fd\u91cf\u53d8\u5316\u60c5\u51b5", "The number of historical seconds displayed by the Wireless Energy HUD", "For example: setting it to 30 will show the energy changes over the past 30 seconds"})
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Wireless Energy HUD History Seconds", cn="\u65e0\u7ebf\u80fd\u91cf HUD \u5386\u53f2\u79d2\u6570")
        @Configurable.Range(min=5L, max=300L)
        @Configurable.Gui.Slider
        public int wirelessEnergyHUDHistorySeconds = 30;
        @Configurable
        @Configurable.Comment(value={"\u65e0\u7ebf\u80fd\u91cf HUD \u6298\u7ebf\u989c\u8272", "Wireless Energy HUD line color"})
        @RegisterLanguage(namePrefix="config.gtocore.option", en="Wireless Energy HUD Line Color", cn="\u65e0\u7ebf\u80fd\u91cf HUD \u6298\u7ebf\u989c\u8272")
        @Configurable.StringPattern(value="#[0-9a-fA-F]{1,6}")
        @Configurable.Gui.ColorValue
        public String wirelessEnergyHUDLineColor = "#ECEC71";
    }
}

