/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.recipe;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.machine.steam.SteamLiquidBoilerMachine;
import com.gregtechceu.gtceu.common.machine.steam.SteamSolidBoilerMachine;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTORecipeCategories;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.recipe.custom.FormingPressLogic;
import com.gtocore.data.recipe.generated.GenerateDisassembly;
import com.gtolib.api.capability.recipe.ManaRecipeCapability;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;

public final class RecipeTypeModify {
    private static final CuttingFluid[] FLUID_TIERS = new CuttingFluid[]{new CuttingFluid(GTMaterials.Water.getFluid(), 60), new CuttingFluid(GTMaterials.Lubricant.getFluid(), 2880), new CuttingFluid(GTOMaterials.FilteredSater.getFluid(), 3840), new CuttingFluid(GTOMaterials.OzoneWater.getFluid(), 15360), new CuttingFluid(GTOMaterials.FlocculentWater.getFluid(), 61440), new CuttingFluid(GTOMaterials.PHNeutralWater.getFluid(), 245760), new CuttingFluid(GTOMaterials.ExtremeTemperatureWater.getFluid(), 983040), new CuttingFluid(GTOMaterials.ElectricEquilibriumWater.getFluid(), 0x3C0000), new CuttingFluid(GTOMaterials.DegassedWater.getFluid(), 0xF00000), new CuttingFluid(GTOMaterials.BaryonicPerfectionWater.getFluid(), 0x3C00000)};

    private RecipeTypeModify() {
    }

    public static void init() {
        GTORecipeTypes.COMBUSTION_GENERATOR_FUELS.setMaxIOSize(0, 0, 2, 0);
        GTORecipeTypes.GAS_TURBINE_FUELS.setMaxIOSize(0, 0, 2, 0);
        GTORecipeTypes.DUMMY_RECIPES.setMaxIOSize(1, 1, 1, 1);
        GTORecipeTypes.WIREMILL_RECIPES.setMaxIOSize(1, 1, 0, 0);
        GTORecipeTypes.SIFTER_RECIPES.setMaxIOSize(1, 6, 1, 0);
        GTORecipeTypes.CHEMICAL_RECIPES.onRecipeBuild(r -> {});
        GTORecipeTypes.LARGE_CHEMICAL_RECIPES.getProxyRecipes().add(GTORecipeTypes.CHEMICAL_RECIPES);
        GTORecipeTypes.ASSEMBLY_LINE_RECIPES.onRecipeBuild(GenerateDisassembly::generateDisassembly);
        GTORecipeTypes.ASSEMBLER_RECIPES.setMANAIO(IO.IN);
        GTORecipeTypes.ASSEMBLER_RECIPES.onRecipeBuild(b2 -> {
            List mana = (List)b2.tickInput.get(ManaRecipeCapability.CAP);
            if (mana != null && !mana.isEmpty()) {
                b2.category(GTORecipeCategories.MANA_ASSEMBLER);
            }
            GenerateDisassembly.generateDisassembly(b2);
        });
        GTORecipeTypes.PLASMA_GENERATOR_FUELS.onRecipeBuild(recipeBuilder -> {
            long eu = (long)recipeBuilder.duration * GTValues.V[4] * 2L;
            int water = (int)(eu / 80L);
            FluidIngredient output = ((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)((List)recipeBuilder.output.get(FluidRecipeCapability.CAP)).get(0)).getContent())).copy();
            FluidIngredient input = ((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)((List)recipeBuilder.input.get(FluidRecipeCapability.CAP)).get(0)).getContent())).copy();
            output.setAmount(9L);
            input.setAmount(10L);
            GTORecipeTypes.HEAT_EXCHANGER_RECIPES.recipeBuilder(recipeBuilder.id).inputFluids(new FluidIngredient[]{input}).inputFluids(GTMaterials.DistilledWater.getFluid(water)).outputFluids(new FluidIngredient[]{output}).outputFluids(GTOMaterials.HighPressureSteam.getFluid(water * 40)).outputFluids(GTOMaterials.SupercriticalSteam.getFluid(water * 10)).addData("eu", eu).duration(200).save();
        });
        GTORecipeTypes.LASER_ENGRAVER_RECIPES.setMaxIOSize(2, 1, 2, 1).onRecipeBuild(recipeBuilder -> {
            if (recipeBuilder.data.m_128441_("special")) {
                return;
            }
            RecipeBuilder recipe = GTORecipeTypes.DIMENSIONAL_FOCUS_ENGRAVING_ARRAY_RECIPES.copyFrom(recipeBuilder).duration((int)((double)recipeBuilder.duration * 0.2)).EUt(recipeBuilder.EUt() << 2);
            double value = Math.log10(recipeBuilder.EUt()) / Math.log10(4.0);
            if (value > 10.0) {
                recipe.inputFluids(GTOMaterials.EuvPhotoresist.getFluid((int)(value / 2.0)));
            } else {
                recipe.inputFluids(GTOMaterials.Photoresist.getFluid((int)value));
            }
            recipe.save();
        });
        GTORecipeTypes.CUTTER_RECIPES.onRecipeBuild(recipeBuilder -> {
            if (recipeBuilder.input.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty() && recipeBuilder.tickInput.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty()) {
                int originalDuration = recipeBuilder.duration;
                int index = RecipeTypeModify.getEUTierIndex(GTUtil.getTierByVoltage((long)recipeBuilder.EUt()));
                GTRecipeBuilder builder = recipeBuilder.copy(recipeBuilder.id);
                RecipeTypeModify.addCuttingFluid(recipeBuilder, index);
                if (index > 1 && index < FLUID_TIERS.length - 1) {
                    int maxUpgradeTiers = FLUID_TIERS.length - index;
                    for (int upgradeTier = 1; upgradeTier < maxUpgradeTiers; ++upgradeTier) {
                        double reductionFactor = Math.pow(0.8, upgradeTier);
                        GTRecipeBuilder upgradedRecipe = builder.copy(builder.id.m_135815_() + "_upgraded_t" + (index + upgradeTier)).duration((int)Math.max(1.0, (double)originalDuration * reductionFactor));
                        RecipeTypeModify.addUpgradedCuttingFluid(upgradedRecipe, index, index + upgradeTier, originalDuration, builder.EUt(), reductionFactor);
                    }
                }
            }
        });
        GTORecipeTypes.CIRCUIT_ASSEMBLER_RECIPES.onRecipeBuild(recipeBuilder -> {
            if (recipeBuilder.input.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty() && recipeBuilder.tickInput.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty()) {
                if (recipeBuilder.EUt() < (long)GTValues.VA[3]) {
                    recipeBuilder.inputFluids(GTMaterials.Tin.getFluid(Math.max(1, 144 * recipeBuilder.getSolderMultiplier())));
                } else if (recipeBuilder.EUt() < (long)GTValues.VA[8]) {
                    recipeBuilder.inputFluids(GTMaterials.SolderingAlloy.getFluid(Math.max(1, 144 * recipeBuilder.getSolderMultiplier())));
                } else if (recipeBuilder.EUt() < (long)GTValues.VA[11]) {
                    recipeBuilder.inputFluids(GTOMaterials.MutatedLivingSolder.getFluid(Math.max(1, 144 * (GTUtil.getFloorTierByVoltage((long)recipeBuilder.EUt()) - 6))));
                } else {
                    recipeBuilder.inputFluids(GTOMaterials.SuperMutatedLivingSolder.getFluid(Math.max(1, 144 * (GTUtil.getFloorTierByVoltage((long)recipeBuilder.EUt()) - 8))));
                }
            }
        });
        GTORecipeTypes.STEAM_BOILER_RECIPES.onRecipeBuild(builder -> {
            GTORecipeTypes.THERMAL_GENERATOR_FUELS.copyFrom(builder).EUt(-8L).duration((int)Math.sqrt(builder.duration)).save();
            GTORecipeTypes.MANA_GARDEN_FUEL.copyFrom(builder).notConsumable("botania:endoflame").MANAt(-12L).EUt((long)GTValues.VA[2]).duration(builder.duration / 2).save();
            List list = builder.input.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList());
            if (!list.isEmpty()) {
                Arrays.stream(((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)list.get((int)0)).content)).getStacks()).forEach(stack -> SteamLiquidBoilerMachine.FUEL_CACHE.add((Object)stack.getFluid()));
            }
            if (!(list = builder.input.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList())).isEmpty()) {
                Arrays.stream(FastSizedIngredient.getInner((Ingredient)((Ingredient)ItemRecipeCapability.CAP.of(((Content)list.get((int)0)).content))).m_43908_()).forEach(stack -> SteamSolidBoilerMachine.FUEL_CACHE.add((Object)stack.m_41720_()));
            }
        });
        GTORecipeTypes.LARGE_BOILER_RECIPES.addDataInfo(data -> {
            int temperature = data.m_128451_("temperature");
            if (temperature > 0) {
                return I18n.m_118938_((String)"gtceu.multiblock.hpca.temperature", (Object[])new Object[]{temperature});
            }
            return "";
        }).prioritySearch();
        GTRecipeTypes.FORMING_PRESS_RECIPES.getCustomRecipeLogicRunners().clear();
        GTRecipeTypes.FORMING_PRESS_RECIPES.getCustomRecipeLogicRunners().add(new FormingPressLogic());
    }

    private static int getEUTierIndex(int euTier) {
        return switch (euTier) {
            case 0, 1 -> 0;
            case 2, 3 -> 1;
            case 4 -> 2;
            case 5 -> 3;
            case 6 -> 4;
            case 7 -> 5;
            case 8 -> 6;
            case 9 -> 7;
            case 10 -> 8;
            default -> 9;
        };
    }

    private static void addCuttingFluid(GTRecipeBuilder recipeBuilder, int index) {
        CuttingFluid selected = FLUID_TIERS[index];
        long fluidAmount = Math.max(1L, (long)recipeBuilder.duration * recipeBuilder.EUt() / (long)selected.divisor());
        recipeBuilder.inputFluids(new FluidIngredient[]{FastFluidIngredient.of((long)fluidAmount, (Fluid[])new Fluid[]{selected.fluid()})});
    }

    private static void addUpgradedCuttingFluid(GTRecipeBuilder recipeBuilder, int originalIndex, int index, int originalDuration, long originalEUt, double reductionFactor) {
        CuttingFluid selected = FLUID_TIERS[index];
        long fluidAmount = (long)Math.max(1.0, (double)((long)originalDuration * originalEUt) * reductionFactor / (double)FLUID_TIERS[originalIndex].divisor());
        recipeBuilder.inputFluids(new FluidIngredient[]{FastFluidIngredient.of((long)fluidAmount, (Fluid[])new Fluid[]{selected.fluid()})});
        recipeBuilder.save();
    }

    private record CuttingFluid(Fluid fluid, int divisor) {
    }
}

