/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.trait;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gtocore.common.machine.multiblock.part.RadiationHatchPartMachine;
import com.gtocore.data.IdleReason;
import com.gtolib.api.machine.feature.multiblock.IMultiblockTraitHolder;
import com.gtolib.api.machine.trait.MultiblockTrait;
import com.gtolib.api.recipe.Recipe;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class RadioactivityTrait
extends MultiblockTrait {
    @Persisted
    private int recipeRadioactivity;
    private final Set<RadiationHatchPartMachine> radiationHatchPartMachines = new ReferenceOpenHashSet();

    public RadioactivityTrait(IMultiblockTraitHolder machine) {
        super(machine);
    }

    public void onPartScan(IMultiPart part) {
        if (part instanceof RadiationHatchPartMachine) {
            RadiationHatchPartMachine radiationHatchPartMachine = (RadiationHatchPartMachine)part;
            this.radiationHatchPartMachines.add(radiationHatchPartMachine);
        }
    }

    public void onStructureInvalid() {
        this.radiationHatchPartMachines.clear();
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.recipe.radioactivity", (Object[])new Object[]{this.getRecipeRadioactivity()}));
    }

    public Recipe modifyRecipe(@NotNull Recipe recipe) {
        this.recipeRadioactivity = recipe.data.m_128451_("radioactivity");
        if (this.recipeRadioactivity > 0 && this.outside()) {
            MetaMachine metaMachine = this.machine;
            if (metaMachine instanceof IRecipeLogicMachine) {
                IRecipeLogicMachine recipeLogicMachine = (IRecipeLogicMachine)metaMachine;
                IdleReason.setIdleReason((IRecipeLogicMachine)recipeLogicMachine, (com.gtolib.api.recipe.IdleReason)IdleReason.RADIATION);
            }
            return null;
        }
        return recipe;
    }

    public void afterWorking() {
        this.recipeRadioactivity = 0;
        super.afterWorking();
    }

    protected int getRecipeRadioactivity() {
        int radioactivity = 0;
        for (RadiationHatchPartMachine partMachine : this.radiationHatchPartMachines) {
            radioactivity += partMachine.getRadioactivity();
        }
        return radioactivity;
    }

    private boolean outside() {
        int radioactivity = this.getRecipeRadioactivity();
        return radioactivity > this.recipeRadioactivity + 5 || radioactivity < this.recipeRadioactivity - 5;
    }
}

