/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.trait;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.FluidVeinWorldEntry;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gtocore.common.machine.multiblock.electric.voidseries.INFFluidDrillMachine;
import com.gtolib.api.machine.impl.DrillingControlCenterMachine;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.gtolib.api.machine.trait.IFluidDrillLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public final class INFFluidDrillLogic
extends RecipeLogic
implements IFluidDrillLogic,
IEnhancedRecipeLogic {
    public static final int MAX_PROGRESS = 20;
    private DrillingControlCenterMachine cache;
    @Nullable
    private Fluid veinFluid;
    private static final int parallel = 1;

    public INFFluidDrillLogic(INFFluidDrillMachine machine) {
        super((IRecipeLogicMachine)machine);
    }

    public INFFluidDrillMachine getMachine() {
        return (INFFluidDrillMachine)super.getMachine();
    }

    public void findAndHandleRecipe() {
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            Recipe match;
            ServerLevel serverLevel = (ServerLevel)level;
            this.lastRecipe = null;
            BedrockFluidVeinSavedData data = BedrockFluidVeinSavedData.getOrCreate((ServerLevel)serverLevel);
            if (this.veinFluid == null) {
                this.veinFluid = data.getFluidInChunk(this.getChunkX(), this.getChunkZ());
                if (this.veinFluid == null) {
                    if (this.subscription != null) {
                        this.subscription.unsubscribe();
                        this.subscription = null;
                    }
                    return;
                }
            }
            if ((match = this.getFluidDrillRecipe()) != null && RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)match) && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)match)) {
                this.setupRecipe((GTRecipe)match);
            }
        }
    }

    @Nullable
    private Recipe getFluidDrillRecipe() {
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.veinFluid != null) {
                BedrockFluidVeinSavedData data = BedrockFluidVeinSavedData.getOrCreate((ServerLevel)serverLevel);
                Recipe recipe = this.gtolib$getRecipeBuilder().outputFluids(new FluidStack(this.veinFluid, this.getFluidToProduce(data.getFluidVeinWorldEntry(this.getChunkX(), this.getChunkZ())))).duration(20).EUt((long)((double)GTValues.VA[this.getMachine().getEnergyTier()] * Math.pow(1.0, 1.2))).buildRawRecipe();
                if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)recipe) && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)recipe)) {
                    return recipe;
                }
            }
        }
        return null;
    }

    public int getFluidToProduce() {
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.veinFluid != null) {
                BedrockFluidVeinSavedData data = BedrockFluidVeinSavedData.getOrCreate((ServerLevel)serverLevel);
                return this.getFluidToProduce(data.getFluidVeinWorldEntry(this.getChunkX(), this.getChunkZ()));
            }
        }
        return 0;
    }

    private int getFluidToProduce(FluidVeinWorldEntry entry) {
        BedrockFluidDefinition definition = entry.getDefinition();
        if (definition != null) {
            DrillingControlCenterMachine machine;
            int depletedYield = definition.getDepletedYield();
            int regularYield = entry.getFluidYield();
            int remainingOperations = entry.getOperationsRemaining();
            int produced = Math.max(depletedYield, regularYield * remainingOperations / 100000);
            produced *= this.getMachine().getBasis();
            if (this.isOverclocked()) {
                produced = produced * 3 / 2;
            }
            if ((machine = (DrillingControlCenterMachine)this.getNetMachine()) != null) {
                produced = (int)((double)produced * machine.getMultiplier());
            }
            return produced;
        }
        return 0;
    }

    public void onRecipeFinish() {
        Recipe match;
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            this.handleRecipeIO(this.lastRecipe, IO.OUT);
        }
        if ((match = this.getFluidDrillRecipe()) != null && RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)match) && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)match)) {
            this.setupRecipe((GTRecipe)match);
            return;
        }
        this.setStatus(0);
        this.progress = 0;
        this.duration = 0;
    }

    private boolean isOverclocked() {
        return this.getMachine().getEnergyTier() > this.getMachine().getTier();
    }

    private int getChunkX() {
        return SectionPos.m_123171_((int)this.getMachine().getPos().m_123341_());
    }

    private int getChunkZ() {
        return SectionPos.m_123171_((int)this.getMachine().getPos().m_123343_());
    }

    public DrillingControlCenterMachine getNetMachineCache() {
        return this.cache;
    }

    public void setNetMachineCache(DrillingControlCenterMachine cache) {
        this.cache = cache;
    }

    public void onMachineUnLoad() {
        super.onMachineUnLoad();
        this.cache = null;
    }

    @Nullable
    public Fluid getVeinFluid() {
        return this.veinFluid;
    }
}

