/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.tesseract;

import com.lowdragmc.lowdraglib.syncdata.payload.ObjectTypedPayload;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TesseractDirectedTarget(GlobalPos pos, Direction face, int order) implements Comparable<TesseractDirectedTarget>
{
    public static final Codec<TesseractDirectedTarget> CODEC = RecordCodecBuilder.create(i -> i.group((App)GlobalPos.f_122633_.fieldOf("pos").forGetter(TesseractDirectedTarget::pos), (App)Direction.f_175356_.fieldOf("face").forGetter(TesseractDirectedTarget::face), (App)Codec.INT.fieldOf("order").forGetter(TesseractDirectedTarget::order)).apply((Applicative)i, TesseractDirectedTarget::new));
    public static final Codec<List<TesseractDirectedTarget>> LIST_CODEC = new ListCodec(CODEC);
    public static final Comparator<TesseractDirectedTarget> SORTER = Comparator.comparingInt(pf -> {
        if (pf.order() < 0) {
            return Integer.MAX_VALUE + pf.order();
        }
        return pf.order();
    });

    @Override
    public int compareTo(@NotNull TesseractDirectedTarget o) {
        return SORTER.compare(this, o);
    }

    public static void writeToBuffer(FriendlyByteBuf buffer, TesseractDirectedTarget tesseractDirectedTarget) {
        buffer.m_236814_(tesseractDirectedTarget.pos());
        buffer.writeShort((int)((short)tesseractDirectedTarget.face().m_122411_()));
        buffer.m_130130_(tesseractDirectedTarget.order());
    }

    public static TesseractDirectedTarget readFromBuffer(FriendlyByteBuf buffer) {
        GlobalPos pos = buffer.m_236872_();
        Direction face = Direction.m_122376_((int)buffer.readShort());
        int order = buffer.m_130242_();
        return new TesseractDirectedTarget(pos, face, order);
    }

    public static class Payload
    extends ObjectTypedPayload<TesseractDirectedTarget> {
        @Nullable
        public Tag serializeNBT() {
            return (Tag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((TesseractDirectedTarget)this.getPayload())).result().orElse(new CompoundTag());
        }

        public void deserializeNBT(Tag tag) {
            TesseractDirectedTarget result = CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).result().orElse(null);
            this.setPayload(result);
        }

        public void writePayload(FriendlyByteBuf buf) {
            TesseractDirectedTarget.writeToBuffer(buf, (TesseractDirectedTarget)this.getPayload());
        }

        public void readPayload(FriendlyByteBuf buf) {
            TesseractDirectedTarget result = TesseractDirectedTarget.readFromBuffer(buf);
            this.setPayload(result);
        }
    }
}

