/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.tesseract;

import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.gregtechceu.gtceu.api.transfer.fluid.FluidHandlerList;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.api.transfer.item.ItemHandlerList;
import com.gregtechceu.gtceu.utils.LazyOptionalUtil;
import com.gtocore.common.machine.tesseract.ITesseractMarkerInteractable;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMultiTesseract
extends IMachineFeature,
ITesseractMarkerInteractable {
    @Nullable
    default public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.isCalled()) {
            return null;
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            this.getItemHandlers().clear();
            int size = this.getTotalBlockEntities();
            for (int i = 0; i < size; ++i) {
                BlockEntity c = this.getBlockEntity(i);
                if (c == null) continue;
                this.setCalled(true);
                IItemHandler h = (IItemHandler)LazyOptionalUtil.get((LazyOptional)c.getCapability(ForgeCapabilities.ITEM_HANDLER, this.getSideForBlockEntity(i, side)));
                this.setCalled(false);
                if (h == null) continue;
                this.getItemHandlers().add(h);
            }
            int s = this.getItemHandlers().size();
            if (s > 0) {
                ItemHandlerList finalResult;
                CoverBehavior cover;
                ItemHandlerList result;
                Object object = result = s > 1 ? new ItemHandlerList(this.getItemHandlers().toArray(new IItemHandler[0])) : this.getItemHandlers().getFirst();
                if (side != null && (cover = this.self().getCoverContainer().getCoverAtSide(side)) != null && result instanceof IItemHandlerModifiable) {
                    IItemHandlerModifiable modifiable = (IItemHandlerModifiable)result;
                    result = cover.getItemHandlerCap(modifiable);
                }
                return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of((NonNullSupplier)((finalResult = result) == null ? null : () -> IMultiTesseract.lambda$getCapability$0((IItemHandler)finalResult))));
            }
        } else if (cap == ForgeCapabilities.FLUID_HANDLER) {
            this.getFluidHandlers().clear();
            int size = this.getTotalBlockEntities();
            for (int i = 0; i < size; ++i) {
                BlockEntity c = this.getBlockEntity(i);
                if (c == null) continue;
                this.setCalled(true);
                IFluidHandler h = (IFluidHandler)LazyOptionalUtil.get((LazyOptional)c.getCapability(ForgeCapabilities.FLUID_HANDLER, this.getSideForBlockEntity(i, side)));
                this.setCalled(false);
                if (h == null) continue;
                this.getFluidHandlers().add(h);
            }
            int s = this.getFluidHandlers().size();
            if (s > 0) {
                FluidHandlerList finalResult;
                CoverBehavior cover;
                FluidHandlerList result;
                Object object = result = s > 1 ? new FluidHandlerList(this.getFluidHandlers().toArray(new IFluidHandler[0])) : this.getFluidHandlers().getFirst();
                if (side != null && (cover = this.self().getCoverContainer().getCoverAtSide(side)) != null && result instanceof IFluidHandlerModifiable) {
                    IFluidHandlerModifiable modifiable = (IFluidHandlerModifiable)result;
                    result = cover.getFluidHandlerCap(modifiable);
                }
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of((NonNullSupplier)((finalResult = result) == null ? null : () -> IMultiTesseract.lambda$getCapability$1((IFluidHandler)finalResult))));
            }
        }
        return null;
    }

    public List<IItemHandler> getItemHandlers();

    public List<IFluidHandler> getFluidHandlers();

    public boolean isCalled();

    public void setCalled(boolean var1);

    @Nullable
    public BlockEntity getBlockEntity(int var1);

    public int getTotalBlockEntities();

    default public Direction getSideForBlockEntity(int i, @Nullable Direction side) {
        return side;
    }

    private static /* synthetic */ IFluidHandler lambda$getCapability$1(IFluidHandler finalResult) {
        return finalResult;
    }

    private static /* synthetic */ IItemHandler lambda$getCapability$0(IItemHandler finalResult) {
        return finalResult;
    }
}

