/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.tesseract;

import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.client.renderer.RenderHelper;
import com.gtocore.common.item.TesseractTargetMarker;
import com.gtocore.common.machine.tesseract.AdvancedTesseractMachine;
import com.gtocore.common.machine.tesseract.DirectedTesseractMachine;
import com.gtocore.common.machine.tesseract.TesseractDirectedTarget;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientHandler {
    private static final float HUE_RED = 0.0f;
    private static final float HUE_PURPLE = 0.8333f;

    private static float lerpHue(float percent) {
        return 0.0f + percent * 0.8333f;
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        ItemStack item = Minecraft.m_91087_().f_91074_.m_21205_();
        if (TesseractTargetMarker.isTesseractTargetMarker(item)) {
            List<TesseractDirectedTarget> faces2 = TesseractTargetMarker.getAllPatternFaces(item);
            ClientHandler.onRenderDirected(event, faces2);
        }
        if (!DirectedTesseractMachine.HIGHLIGHTS.isEmpty()) {
            DirectedTesseractMachine.HIGHLIGHTS.elementSet().forEach(faces -> ClientHandler.onRenderDirected(event, List.copyOf(faces)));
        }
        if (!AdvancedTesseractMachine.HIGHLIGHTS.isEmpty()) {
            AdvancedTesseractMachine.HIGHLIGHTS.elementSet().forEach(faces -> ClientHandler.onRenderBlocks(event, List.copyOf(faces)));
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        DirectedTesseractMachine.HIGHLIGHTS.elementSet().forEach(arg_0 -> DirectedTesseractMachine.HIGHLIGHTS.remove(arg_0));
        AdvancedTesseractMachine.HIGHLIGHTS.elementSet().forEach(arg_0 -> AdvancedTesseractMachine.HIGHLIGHTS.remove(arg_0));
    }

    public static void onRenderDirected(RenderLevelStageEvent event, List<TesseractDirectedTarget> faces) {
        if (faces.isEmpty()) {
            return;
        }
        Level level = GTUtil.getClientLevel();
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        Vec3 pos = event.getCamera().m_90583_();
        poseStack.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            int totalLength = faces.size() * 2;
            for (TesseractDirectedTarget face : faces) {
                if (face.pos().m_122640_() != level.m_46472_()) continue;
                int order = face.order();
                float percent = order < 0 ? (float)(totalLength + order) / ((float)totalLength * 2.0f) : (float)order / ((float)totalLength * 2.0f);
                Color color = Color.getHSBColor(ClientHandler.lerpHue(percent), 1.0f, 1.0f);
                double faceMinX = (double)face.pos().m_122646_().m_123341_() + (face.face() == Direction.EAST ? 1.0 : 0.0);
                double faceMinY = (double)face.pos().m_122646_().m_123342_() + (face.face() == Direction.UP ? 1.0 : 0.0);
                double faceMinZ = (double)face.pos().m_122646_().m_123343_() + (face.face() == Direction.SOUTH ? 1.0 : 0.0);
                double faceMaxX = faceMinX + (face.face().m_122434_() == Direction.Axis.X ? 0.0 : 1.0);
                double faceMaxY = faceMinY + (face.face().m_122434_() == Direction.Axis.Y ? 0.0 : 1.0);
                double faceMaxZ = faceMinZ + (face.face().m_122434_() == Direction.Axis.Z ? 0.0 : 1.0);
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.disableCull();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                poseStack.m_85836_();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder buffer = tesselator.m_85915_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                RenderSystem.setShader(GameRenderer::m_172811_);
                RenderBufferUtils.renderCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)((float)faceMinX), (float)((float)faceMinY), (float)((float)faceMinZ), (float)((float)faceMaxX), (float)((float)faceMaxY), (float)((float)faceMaxZ), (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.16f, (boolean)false);
                tesselator.m_85914_();
                buffer.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
                RenderSystem.setShader(GameRenderer::m_172757_);
                RenderSystem.lineWidth((float)6.0f);
                RenderBufferUtils.drawCubeFrame((PoseStack)poseStack, (VertexConsumer)buffer, (float)((float)faceMinX), (float)((float)faceMinY), (float)((float)faceMinZ), (float)((float)faceMaxX), (float)((float)faceMaxY), (float)((float)faceMaxZ), (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.4f);
                tesselator.m_85914_();
                poseStack.m_85849_();
                poseStack.m_85836_();
                poseStack.m_85837_((faceMinX + faceMaxX) / 2.0, (faceMinY + faceMaxY) / 2.0, (faceMinZ + faceMaxZ) / 2.0);
                poseStack.m_85841_(-0.03f, -0.03f, -0.03f);
                poseStack.m_252781_(event.getCamera().m_253121_());
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                Font font = Minecraft.m_91087_().f_91062_;
                String string = String.valueOf(order);
                float f = (float)(-font.m_92895_(String.valueOf(order))) / 2.0f;
                Objects.requireNonNull(font);
                font.m_271703_(string, f, (float)(-9) / 2.0f, color.getRGB(), false, matrix4f, (MultiBufferSource)event.getLevelRenderer().f_109464_.m_110104_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                String string2 = String.valueOf(order);
                float f2 = (float)(-font.m_92895_(String.valueOf(order))) / 2.0f;
                Objects.requireNonNull(font);
                font.m_271703_(string2, f2, (float)(-9) / 2.0f, color.getRGB(), false, matrix4f, (MultiBufferSource)event.getLevelRenderer().f_109464_.m_110104_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                poseStack.m_85849_();
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
            }
        }
        poseStack.m_85849_();
    }

    public static void onRenderBlocks(RenderLevelStageEvent event, List<Long> packedPositions) {
        if (packedPositions.isEmpty()) {
            return;
        }
        Level level = GTUtil.getClientLevel();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            for (int i = 0; i < packedPositions.size(); ++i) {
                BlockPos blockPos = BlockPos.m_122022_((long)packedPositions.get(i));
                if (!level.m_46749_(blockPos)) continue;
                int order = i + 1;
                Color color = Color.getHSBColor(ClientHandler.lerpHue((float)order / (float)(packedPositions.size() * 2)), 1.0f, 1.0f);
                RenderHelper.highlightBlock(event.getCamera(), poseStack, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, blockPos, blockPos);
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.disableCull();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                poseStack.m_85836_();
                Vec3 pos = event.getCamera().m_90583_();
                poseStack.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
                poseStack.m_85837_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
                poseStack.m_85841_(-0.03f, -0.03f, -0.03f);
                poseStack.m_252781_(event.getCamera().m_253121_());
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                Font font = Minecraft.m_91087_().f_91062_;
                String string = String.valueOf(order);
                float f = (float)(-font.m_92895_(String.valueOf(order))) / 2.0f;
                Objects.requireNonNull(font);
                font.m_271703_(string, f, (float)(-9) / 2.0f, color.getRGB(), false, matrix4f, (MultiBufferSource)event.getLevelRenderer().f_109464_.m_110104_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                String string2 = String.valueOf(order);
                float f2 = (float)(-font.m_92895_(String.valueOf(order))) / 2.0f;
                Objects.requireNonNull(font);
                font.m_271703_(string2, f2, (float)(-9) / 2.0f, color.getRGB(), false, matrix4f, (MultiBufferSource)event.getLevelRenderer().f_109464_.m_110104_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                poseStack.m_85849_();
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
            }
            poseStack.m_85849_();
        }
    }
}

