/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.tesseract;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.helpers.patternprovider.PatternProviderTarget;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfiguratorButton;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.machine.tesseract.IMultiTesseract;
import com.gtocore.common.machine.tesseract.TesseractDirectedTarget;
import com.gtolib.api.ae2.IPatternProviderLogic;
import com.gtolib.api.ae2.PatternProviderTargetCache;
import com.gtolib.api.ae2.machine.ICustomCraftingMachine;
import com.gtolib.api.player.IEnhancedPlayer;
import com.gtolib.utils.holder.BooleanHolder;
import com.gtolib.utils.holder.ObjectHolder;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class AdvancedTesseractMachine
extends MetaMachine
implements IFancyUIMachine,
IMachineLife,
ICustomCraftingMachine,
IMultiTesseract {
    public static final Multiset<ImmutableList<Long>> HIGHLIGHTS = HashMultiset.create();
    private final WeakReference<BlockEntity>[] blockEntityReference = new WeakReference[20];
    @Persisted
    @DescSynced
    public final List<BlockPos> poss = new ArrayList<BlockPos>(20);
    @Persisted
    protected NotifiableItemStackHandler inventory;
    @Persisted
    private boolean roundRobin;
    private final List<IItemHandler> itemHandlers = new ArrayList<IItemHandler>(20);
    private final List<IFluidHandler> fluidHandlers = new ArrayList<IFluidHandler>(20);
    private boolean called;

    public AdvancedTesseractMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.inventory = new NotifiableItemStackHandler((MetaMachine)this, 20, IO.NONE, IO.NONE);
        this.inventory.storage.setOnContentsChangedAndfreeze(() -> {
            this.called = false;
            this.poss.clear();
            for (int i = 0; i < 20; ++i) {
                BlockPos pos;
                CompoundTag posTags;
                this.blockEntityReference[i] = null;
                ItemStack card = this.inventory.storage.getStackInSlot(i);
                if (card.m_41619_() || (posTags = card.m_41783_()) == null || !posTags.m_128441_("x") || !posTags.m_128441_("y") || !posTags.m_128441_("z") || (pos = new BlockPos(posTags.m_128451_("x"), posTags.m_128451_("y"), posTags.m_128451_("z"))).equals((Object)this.getPos()) || this.poss.contains(pos)) continue;
                this.poss.add(pos);
            }
        });
    }

    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!super.onScrewdriverClick(playerIn, hand, gridSide, hitResult).m_19080_()) {
            this.roundRobin = !this.roundRobin;
            playerIn.m_5661_((Component)Component.m_237115_((String)(this.roundRobin ? "tooltip.ad_astra.distribution_mode.round_robin" : "tooltip.ad_astra.distribution_mode.sequential")), true);
            return InteractionResult.m_19078_((boolean)playerIn.m_9236_().f_46443_);
        }
        return InteractionResult.SUCCESS;
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new IFancyConfiguratorButton.Toggle((IGuiTexture)GuiTextures.LIGHT_ON, (IGuiTexture)GuiTextures.LIGHT_ON, () -> false, (clickData, pressed) -> {
            if (clickData.isRemote && this.getLevel() != null) {
                HIGHLIGHTS.add((Object)((ImmutableList)this.poss.stream().map(BlockPos::m_121878_).collect(ImmutableList.toImmutableList())), 200);
            }
        }).setTooltipsSupplier(pressed -> Collections.singletonList(Component.m_237115_((String)"gui.gtceu.machine.tesseract.highlight_targets")))});
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 106, 88);
        WidgetGroup container = new WidgetGroup(4, 4, 98, 80);
        int index = 0;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 5; ++x) {
                container.addWidget((Widget)new SlotWidget((IItemHandlerModifiable)this.inventory.storage, index++, 4 + x * 18, 4 + y * 18, true, true).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
            }
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        IItemHandlerModifiable m;
        Object object;
        LazyOptional cap = this.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
        IItemHandlerModifiable iItemHandlerModifiable = cap != null ? ((object = cap.orElse(null)) instanceof IItemHandlerModifiable ? (m = (IItemHandlerModifiable)object) : null) : null;
        return iItemHandlerModifiable;
    }

    @Nullable
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        IFluidHandlerModifiable m;
        Object object;
        LazyOptional cap = this.getCapability(ForgeCapabilities.FLUID_HANDLER, side);
        IFluidHandlerModifiable iFluidHandlerModifiable = cap != null ? ((object = cap.orElse(null)) instanceof IFluidHandlerModifiable ? (m = (IFluidHandlerModifiable)object) : null) : null;
        return iFluidHandlerModifiable;
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(int i) {
        return this.getBlockEntity(this.poss.get(i), i);
    }

    @Override
    public int getTotalBlockEntities() {
        return this.poss.size();
    }

    @Nullable
    public BlockEntity getBlockEntity(@Nullable BlockPos pos, int i) {
        if (pos == null) {
            return null;
        }
        WeakReference<BlockEntity> reference = this.blockEntityReference[i];
        if (reference == null) {
            BlockEntity be = this.getLevel().m_7702_(pos);
            if (be != null) {
                this.blockEntityReference[i] = new WeakReference<BlockEntity>(be);
                return be;
            }
            this.poss.set(i, null);
        } else {
            BlockEntity blockEntity = (BlockEntity)reference.get();
            if (blockEntity == null || blockEntity.m_58901_()) {
                blockEntity = this.getLevel().m_7702_(pos);
                if (blockEntity != null) {
                    this.blockEntityReference[i] = new WeakReference<BlockEntity>(blockEntity);
                    return blockEntity;
                }
                this.poss.set(i, null);
            } else {
                return blockEntity;
            }
        }
        return null;
    }

    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.inventory.storage);
    }

    public boolean customPush() {
        return this.roundRobin;
    }

    public IPatternProviderLogic.PushResult pushPattern(IPatternProviderLogic logic, IActionSource actionSource, BooleanHolder success, ICustomCraftingMachine.Operate operate, Set<AEKey> patternInputs, IPatternDetails patternDetails, ObjectHolder<KeyCounter[]> inputHolder, Supplier<IPatternProviderLogic.PushResult> pushPatternSuccess, BooleanSupplier canPush, Direction direction, Direction adjBeSide) {
        int size = this.poss.size();
        ArrayList<PatternProviderTarget> targets = new ArrayList<PatternProviderTarget>(size);
        for (int i = 0; i < size; ++i) {
            PatternProviderTarget target;
            BlockPos targetPos = this.poss.get(i);
            if (targetPos == null || (target = PatternProviderTargetCache.find((BlockEntity)this.getBlockEntity(targetPos, i), (IPatternProviderLogic)logic, (Direction)adjBeSide, (IActionSource)actionSource, (long)targetPos.m_121878_())) == null) continue;
            targets.add(target);
        }
        int count = 1000;
        while (count > 0) {
            --count;
            boolean done = true;
            for (PatternProviderTarget target : targets) {
                if (target.containsPatternInput(patternInputs)) continue;
                IPatternProviderLogic.PushResult result = operate.pushTarget(patternDetails, inputHolder, pushPatternSuccess, canPush, direction, target, false);
                if (result.success()) {
                    success.value = true;
                }
                if (result.needBreak()) {
                    return result;
                }
                if (result != IPatternProviderLogic.PushResult.SUCCESS) continue;
                done = false;
            }
            if (!done) continue;
            break;
        }
        return IPatternProviderLogic.PushResult.NOWHERE_TO_PUSH;
    }

    @Override
    public boolean onMarkerInteract(Player player, List<TesseractDirectedTarget> targets) {
        if (targets.isEmpty()) {
            return false;
        }
        if (this.getLevel() == null || this.getLevel().m_5776_()) {
            return true;
        }
        int availableCards = Arrays.stream(this.inventory.storage.stacks).filter(i -> !i.m_41619_()).toArray().length;
        this.inventory.storage.clear();
        Iterator<TesseractDirectedTarget> iterator = targets.iterator();
        int i2 = 0;
        while (iterator.hasNext()) {
            long cardNum;
            IStorageService meStorage;
            TesseractDirectedTarget target = iterator.next();
            if (i2 >= 20) break;
            BlockPos pos = target.pos().m_122646_();
            if (pos.equals((Object)this.getPos())) {
                iterator.remove();
                continue;
            }
            ItemStack card = ItemStack.f_41583_;
            if (availableCards > 0) {
                --availableCards;
                card = GTOItems.COORDINATE_CARD.m_5456_().m_7968_();
            }
            if (card.m_41619_()) {
                int idx = player.m_150109_().m_36030_(GTOItems.COORDINATE_CARD.m_5456_().m_7968_());
                card = idx < 0 ? ItemStack.f_41583_ : player.m_150109_().m_7407_(idx, 1);
            }
            if (card.m_41619_() && (meStorage = IEnhancedPlayer.getMEStorageService((ServerPlayer)((ServerPlayer)player))) != null && (cardNum = meStorage.getInventory().extract((AEKey)AEItemKey.of((ItemLike)GTOItems.COORDINATE_CARD.m_5456_()), 1L, Actionable.MODULATE, IActionSource.ofPlayer((Player)player))) > 0L) {
                card = GTOItems.COORDINATE_CARD.m_5456_().m_7968_();
            }
            if (card.m_41619_()) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.gtceu.machine.tesseract.write_targets_fail"), true);
                return true;
            }
            CompoundTag posTags = card.m_41784_();
            posTags.m_128405_("x", pos.m_123341_());
            posTags.m_128405_("y", pos.m_123342_());
            posTags.m_128405_("z", pos.m_123343_());
            this.inventory.storage.setStackInSlot(i2, card);
            ++i2;
        }
        if (availableCards > 0) {
            while (availableCards > 0) {
                Block.m_49840_((Level)this.getLevel(), (BlockPos)this.getPos(), (ItemStack)GTOItems.COORDINATE_CARD.m_5456_().m_7968_());
                --availableCards;
            }
        }
        player.m_5661_((Component)Component.m_237115_((String)"gui.gtceu.machine.tesseract.write_targets_success"), true);
        return true;
    }

    @Override
    @Generated
    public List<IItemHandler> getItemHandlers() {
        return this.itemHandlers;
    }

    @Override
    @Generated
    public List<IFluidHandler> getFluidHandlers() {
        return this.fluidHandlers;
    }

    @Override
    @Generated
    public boolean isCalled() {
        return this.called;
    }

    @Override
    @Generated
    public void setCalled(boolean called) {
        this.called = called;
    }
}

