/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.water;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.machine.multiblock.part.SensorPartMachine;
import com.gtocore.common.machine.multiblock.water.WaterPurificationPlantMachine;
import com.gtocore.common.machine.multiblock.water.WaterPurificationUnitMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ExtremeTemperatureFluctuationPurificationUnitMachine
extends WaterPurificationUnitMachine {
    private static final Fluid STEAM = GTOMaterials.SupercriticalSteam.getFluid();
    private static final Fluid HELIUM = GTMaterials.Helium.getFluid();
    private static final Fluid HELIUM_LIQUID = GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID);
    private static final Fluid HELIUM_PLASMA = GTMaterials.Helium.getFluid(FluidStorageKeys.PLASMA);
    @Persisted
    private int heat = 298;
    @Persisted
    private int chance = 1;
    @Persisted
    private long inputCount;
    @Persisted
    private boolean cycle;
    private final List<SensorPartMachine> sensorMachine = new ArrayList<SensorPartMachine>();

    public ExtremeTemperatureFluctuationPurificationUnitMachine(MetaMachineBlockEntity holder) {
        super(holder, 16L);
    }

    public void onPartScan(IMultiPart part) {
        super.onPartScan(part);
        if (part instanceof SensorPartMachine) {
            SensorPartMachine sensorPartMachine = (SensorPartMachine)part;
            this.sensorMachine.add(sensorPartMachine);
        }
    }

    @Override
    public void onStructureFormed() {
        this.sensorMachine.clear();
        super.onStructureFormed();
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.sensorMachine.clear();
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        if (this.getRecipeLogic().isWorking()) {
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.fusion_reactor.heat", (Object[])new Object[]{this.heat}));
            textList.add((Component)Component.m_237110_((String)"gtceu.jei.ore_vein_diagram.chance", (Object[])new Object[]{this.chance}));
        }
    }

    public void afterWorking() {
        this.sensorMachine.forEach(s -> s.update(this.heat));
        super.afterWorking();
    }

    public boolean onWorking() {
        if (!super.onWorking()) {
            return false;
        }
        if (this.getOffsetTimer() % 20 == 0) {
            int helium_plasma;
            long[] a2 = this.getFluidAmount(new Fluid[]{HELIUM_LIQUID, HELIUM_PLASMA});
            int helium_liquid = (int)Math.min(100L, a2[0]);
            if (this.inputFluid(HELIUM_LIQUID, helium_liquid)) {
                this.heat = Math.max(4, this.heat - (int)((double)helium_liquid * (4.0 + Math.random() * 2.0)));
                this.outputFluid(HELIUM, helium_liquid);
            }
            if (this.inputFluid(HELIUM_PLASMA, helium_plasma = (int)Math.min(10L, a2[1]))) {
                this.heat += (int)((double)helium_plasma * (80.0 + Math.random() * 40.0));
                this.outputFluid(HELIUM, helium_plasma);
            }
            if (this.heat > 12500) {
                this.heat = 298;
                this.outputFluid(STEAM, this.inputCount * 9L);
                return false;
            }
            if (this.heat > 10000) {
                this.cycle = true;
            }
            if (this.cycle && this.heat < 10) {
                this.cycle = false;
                this.chance += 33;
            }
            this.sensorMachine.forEach(s -> s.update(this.heat));
        }
        return true;
    }

    public void onRecipeFinish() {
        super.onRecipeFinish();
        if (Math.random() * 100.0 <= (double)this.chance) {
            this.outputFluid(WaterPurificationPlantMachine.GradePurifiedWater5, this.inputCount * 9L / 10L);
        }
    }

    @Override
    long before() {
        this.eut = 0L;
        this.heat = 298;
        this.chance = 1;
        this.cycle = false;
        this.inputCount = Math.min(this.parallel(), this.getFluidAmount(new Fluid[]{WaterPurificationPlantMachine.GradePurifiedWater4})[0]);
        if (this.inputCount > 0L) {
            this.recipe = this.getRecipeBuilder().duration(2400).inputFluids(WaterPurificationPlantMachine.GradePurifiedWater4, this.inputCount).buildRawRecipe();
            if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)this.recipe)) {
                this.calculateVoltage(this.inputCount);
            }
        }
        this.sensorMachine.forEach(s -> s.update(this.heat));
        return this.eut;
    }
}

