/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.water;

import com.fast.fastcollection.OpenCacheHashSet;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.machine.multiblock.water.WaterPurificationPlantMachine;
import com.gtocore.common.machine.multiblock.water.WaterPurificationUnitMachine;
import com.gtolib.api.machine.feature.multiblock.IFluidRendererMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.MachineUtils;
import com.gtolib.utils.NumberUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ClarifierPurificationUnitMachine
extends WaterPurificationUnitMachine
implements IFluidRendererMachine {
    private static final Logger log = LoggerFactory.getLogger(ClarifierPurificationUnitMachine.class);
    private static final Fluid AIR = GTMaterials.Air.getFluid();
    @Persisted
    private int count;
    @DescSynced
    @RequireRerender
    private final Set<BlockPos> fluidBlockOffsets = new OpenCacheHashSet();
    @DescSynced
    private Fluid cachedFluid;

    public ClarifierPurificationUnitMachine(MetaMachineBlockEntity holder) {
        super(holder, 1L);
    }

    protected boolean beforeWorking(@Nullable Recipe recipe) {
        this.cachedFluid = IFluidRendererMachine.getFluid((GTRecipe)recipe);
        return super.beforeWorking(recipe);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        if (!this.fluidBlockOffsets.isEmpty()) {
            return;
        }
        BlockPos pos = this.getPos();
        Direction facing = this.getFrontFacing();
        for (int i = 0; i < 2; ++i) {
            int j;
            for (j = 1; j < 7; ++j) {
                this.fluidBlockOffsets.add(MachineUtils.getOffsetPos((int)j, (int)i, (Direction)facing, (BlockPos)pos).m_121996_((Vec3i)pos));
            }
            for (j = -4; j < 5; ++j) {
                if (j == 0) continue;
                this.fluidBlockOffsets.add(MachineUtils.getOffsetPos((int)1, (int)i, (int)j, (Direction)facing, (BlockPos)pos).m_121996_((Vec3i)pos));
            }
        }
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.fluidBlockOffsets.clear();
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.count > 100) {
            textList.add((Component)Component.m_237115_((String)"gtceu.top.maintenance_broken").m_130940_(ChatFormatting.YELLOW));
        }
    }

    @Override
    long before() {
        long inputCount;
        this.eut = 0L;
        if (this.count > 100) {
            if (this.inputFluid(AIR, (long)this.count * 10000L) && this.inputFluid((Fluid)Fluids.f_76193_, (200L + (long)GTValues.RNG.m_188503_(100)) * 1000L) && this.outputItem((ItemLike)GTOItems.SCRAP.m_5456_(), this.count / 20)) {
                this.count = 0;
            } else {
                return 0L;
            }
        }
        if ((inputCount = Math.min(this.parallel(), this.getFluidAmount(new Fluid[]{Fluids.f_76193_})[0])) > 0L) {
            long outputCount = inputCount * 9L / 10L;
            RecipeBuilder builder = this.getRecipeBuilder();
            builder.duration(2400).inputFluids((Fluid)Fluids.f_76193_, inputCount);
            if (GTValues.RNG.m_188503_(100) <= this.getChance(outputCount / 10L)) {
                builder.outputFluids(WaterPurificationPlantMachine.GradePurifiedWater1, outputCount);
            } else {
                builder.outputFluids((Fluid)Fluids.f_76193_, outputCount);
            }
            this.recipe = builder.buildRawRecipe();
            if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)this.recipe)) {
                this.count += NumberUtils.chanceOccurrences((int)((int)Math.min(10000L, inputCount / 1000L)), (int)3, (int)800);
                this.calculateVoltage(inputCount);
            }
        }
        return this.eut;
    }

    private int getChance(long count) {
        if (this.inputFluid(WaterPurificationPlantMachine.GradePurifiedWater4, count / 16L)) {
            return 100;
        }
        if (this.inputFluid(WaterPurificationPlantMachine.GradePurifiedWater3, count / 4L)) {
            return 95;
        }
        if (this.inputFluid(WaterPurificationPlantMachine.GradePurifiedWater2, count / 2L)) {
            return 90;
        }
        if (this.inputFluid(WaterPurificationPlantMachine.GradePurifiedWater1, count)) {
            return 85;
        }
        return 70;
    }

    public Set<BlockPos> getFluidBlockOffsets() {
        return this.fluidBlockOffsets;
    }

    public Fluid getCachedFluid() {
        return this.cachedFluid;
    }
}

