/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.water;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ItemBusPartMachine;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.machine.multiblock.water.WaterPurificationPlantMachine;
import com.gtocore.common.machine.multiblock.water.WaterPurificationUnitMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class AbsoluteBaryonicPerfectionPurificationUnitMachine
extends WaterPurificationUnitMachine {
    private static final List<Item> CATALYST = List.of((Item)GTOItems.UP_QUARK_RELEASING_CATALYST.get(), (Item)GTOItems.DOWN_QUARK_RELEASING_CATALYST.get(), (Item)GTOItems.BOTTOM_QUARK_RELEASING_CATALYST.get(), (Item)GTOItems.TOP_QUARK_RELEASING_CATALYST.get(), (Item)GTOItems.STRANGE_QUARK_RELEASING_CATALYST.get(), (Item)GTOItems.CHARM_QUARK_RELEASING_CATALYST.get());
    private static final Fluid QUARK_GLUON = GTOMaterials.QuarkGluon.getFluid(FluidStorageKeys.PLASMA);
    private static final Fluid STABLE_BARYONIC_MATTER = GTOMaterials.StableBaryonicMatter.getFluid();
    @Persisted
    @DescSynced
    private Item catalyst1;
    @Persisted
    @DescSynced
    private Item catalyst2;
    @Persisted
    private long inputCount;
    @Persisted
    private boolean successful;
    @Persisted
    private final List<ItemStack> outputs = new ArrayList<ItemStack>();
    private final List<ItemBusPartMachine> busMachines = new ArrayList<ItemBusPartMachine>();

    public AbsoluteBaryonicPerfectionPurificationUnitMachine(MetaMachineBlockEntity holder) {
        super(holder, 128L);
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        if (this.getRecipeLogic().isWorking()) {
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.absolute_baryonic_perfection_purification_unit.items", (Object[])new Object[]{this.catalyst1.m_41466_(), this.catalyst2.m_41466_()}));
            textList.add((Component)Component.m_237110_((String)"gtceu.jei.ore_vein_diagram.chance", (Object[])new Object[]{this.successful ? 100 : 0}));
        }
    }

    public void onPartScan(IMultiPart part) {
        ItemBusPartMachine itemBusPart;
        IO io;
        super.onPartScan(part);
        if (part instanceof ItemBusPartMachine && ((io = (itemBusPart = (ItemBusPartMachine)part).getInventory().getHandlerIO()) == IO.IN || io == IO.BOTH)) {
            this.busMachines.add(itemBusPart);
        }
    }

    @Override
    public void onStructureFormed() {
        this.busMachines.clear();
        super.onStructureFormed();
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.busMachines.clear();
    }

    public boolean onWorking() {
        if (!super.onWorking()) {
            return false;
        }
        if (this.getOffsetTimer() % 20 == 0) {
            boolean successful = false;
            for (ItemBusPartMachine bus : this.busMachines) {
                NotifiableItemStackHandler inv = bus.getInventory();
                int slots = inv.getSlots();
                for (int i = 0; i < slots; ++i) {
                    ItemStack stack1;
                    ItemStack stack = inv.getStackInSlot(i);
                    if (!CATALYST.contains(stack.m_41720_()) || !this.inputFluid(QUARK_GLUON, (long)stack.m_41613_() * 144L)) continue;
                    if (i < slots - 1 && stack.m_41720_() == this.catalyst1 && !(stack1 = inv.getStackInSlot(i + 1)).m_41619_() && this.inputFluid(QUARK_GLUON, (long)stack1.m_41613_() * 144L)) {
                        if (stack1.m_41720_() == this.catalyst2) {
                            this.outputFluid(STABLE_BARYONIC_MATTER, 1000L);
                            successful = true;
                            this.successful = true;
                        }
                        inv.setStackInSlot(i + 1, ItemStack.f_41583_);
                        if (!successful) {
                            this.outputs.add(stack1);
                        }
                    }
                    if (!successful) {
                        this.outputs.add(stack);
                    }
                    inv.setStackInSlot(i, ItemStack.f_41583_);
                }
            }
        }
        return true;
    }

    public void onRecipeFinish() {
        super.onRecipeFinish();
        this.outputs.forEach(xva$0 -> this.outputItem(new ItemStack[]{xva$0}));
        this.outputs.clear();
        if (this.successful) {
            this.outputFluid(WaterPurificationPlantMachine.GradePurifiedWater8, this.inputCount * 9L / 10L);
        }
    }

    @Override
    long before() {
        this.eut = 0L;
        this.successful = false;
        this.inputCount = Math.min(this.parallel(), this.getFluidAmount(new Fluid[]{WaterPurificationPlantMachine.GradePurifiedWater7})[0]);
        if (this.inputCount > 0L) {
            this.recipe = this.getRecipeBuilder().duration(2400).inputFluids(WaterPurificationPlantMachine.GradePurifiedWater7, this.inputCount).buildRawRecipe();
            if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)this.recipe)) {
                int b2;
                int a2 = GTValues.RNG.m_188503_(6);
                while ((b2 = GTValues.RNG.m_188503_(6)) == a2) {
                }
                this.catalyst1 = CATALYST.get(a2);
                this.catalyst2 = CATALYST.get(b2);
                this.calculateVoltage(this.inputCount);
            }
        }
        return this.eut;
    }
}

