/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.storage;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IEnergyInfoProvider;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.client.hud.Configurator;
import com.gtocore.common.block.WirelessEnergyUnitBlock;
import com.gtolib.api.capability.IExtendWirelessEnergyContainerHolder;
import com.gtolib.api.machine.feature.multiblock.ITierCasingMachine;
import com.gtolib.api.machine.multiblock.NoRecipeLogicMultiblockMachine;
import com.gtolib.api.machine.trait.TierCasingTrait;
import com.gtolib.api.wireless.ExtendWirelessEnergyContainer;
import com.gtolib.utils.FunctionContainer;
import com.hepdd.gtmthings.api.misc.WirelessEnergyContainer;
import com.hepdd.gtmthings.utils.BigIntegerUtils;
import com.hepdd.gtmthings.utils.TeamUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WirelessEnergySubstationMachine
extends NoRecipeLogicMultiblockMachine
implements IExtendWirelessEnergyContainerHolder,
ITierCasingMachine,
IEnergyInfoProvider {
    private WirelessEnergyContainer WirelessEnergyContainerCache;
    private final TierCasingTrait tierCasingTrait;
    private final Multimap<Integer, BlockPos> wirelessEnergyUnitPositions = Multimaps.newMultimap((Map)new Int2ObjectOpenHashMap(), ObjectOpenHashSet::new);
    @Persisted
    private ResourceLocation dimension;

    public WirelessEnergySubstationMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.tierCasingTrait = new TierCasingTrait((ITierCasingMachine)this, new String[]{"g_b"});
    }

    private void loadContainer() {
        if (this.isRemote()) {
            return;
        }
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return;
        }
        int tier = this.getCasingTier("g_b");
        FunctionContainer functionContainer = (FunctionContainer)this.getMultiblockState().getMatchContext().get((Object)"wirelessEnergyUnit");
        int loss = 0;
        int i = 0;
        BigInteger capacity = BigInteger.ZERO;
        if (functionContainer != null) {
            ArrayList blocks = (ArrayList)functionContainer.getValue();
            for (WirelessEnergyUnitBlock.BlockData block : blocks) {
                if (block.block() == null) {
                    this.wirelessEnergyUnitPositions.put((Object)0, (Object)block.pos());
                    continue;
                }
                if (block.block().getTier() <= tier) {
                    ++i;
                    capacity = capacity.add(block.block().getCapacity());
                    loss += block.block().getLoss();
                }
                this.wirelessEnergyUnitPositions.put((Object)block.block().getTier(), (Object)block.pos());
            }
            blocks.clear();
        }
        container.setLoss(i == 0 ? 0 : loss / i);
        if (i > 2) {
            container.setCapacity(capacity.multiply(BigInteger.valueOf(i)).divide(BigInteger.valueOf(2L)));
        } else {
            container.setCapacity(capacity);
        }
        this.dimension = level.m_46472_().m_135782_();
        container.setDimension(this.dimension, true);
    }

    private void unloadContainer() {
        if (this.isRemote()) {
            return;
        }
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.wirelessEnergyUnitPositions.clear();
        ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return;
        }
        container.setCapacity(BigInteger.ZERO);
        container.setLoss(0);
        container.setDimension(level.m_46472_().m_135782_(), false);
    }

    public void onStructureInvalid() {
        this.unloadContainer();
        super.onStructureInvalid();
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.loadContainer();
    }

    public void onLoad() {
        super.onLoad();
        if (this.getLevel() instanceof ServerLevel) {
            ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
            if (container == null) {
                return;
            }
            if (this.dimension != null) {
                container.setDimension(this.dimension, true);
            }
            if (this.isFormed()) {
                this.loadContainer();
            }
        }
    }

    public void onUnload() {
        this.unloadContainer();
        super.onUnload();
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        if (this.getUUID() == null) {
            return;
        }
        ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return;
        }
        textList.add((Component)Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.0", (Object[])new Object[]{TeamUtil.GetName((Level)this.getLevel(), (UUID)this.getUUID())}).m_130940_(ChatFormatting.AQUA));
        BigInteger storage = container.getStorage();
        BigInteger capacity = container.getCapacity();
        ChatFormatting color = this.getStorageColor(capacity, storage);
        MutableComponent valueComponent = Component.m_237113_((String)FormattingUtil.formatNumbers((Object)storage)).m_130940_(color).m_7220_((Component)Component.m_237113_((String)(" / " + FormattingUtil.formatNumbers((Object)capacity))).m_130940_(ChatFormatting.WHITE));
        textList.add((Component)Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.1", (Object[])new Object[]{valueComponent}).m_130940_(ChatFormatting.GRAY));
        textList.add((Component)Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.2", (Object[])new Object[]{FormattingUtil.formatNumbers((long)container.getRate()), container.getRate() / GTValues.VEX[GTUtil.getFloorTierByVoltage((long)container.getRate())], Component.m_237113_((String)GTValues.VNF[GTUtil.getFloorTierByVoltage((long)container.getRate())])}).m_130940_(ChatFormatting.GRAY));
        textList.add((Component)Component.m_237110_((String)"gtceu.machine.fluid_drilling_rig.depletion", (Object[])new Object[]{(double)container.getLoss() / 10.0}));
        int casingTier = this.getCasingTier("g_b");
        this.wirelessEnergyUnitPositions.keySet().stream().sorted().forEach(tier -> {
            WirelessEnergyUnitBlock block = WirelessEnergyUnitBlock.get(tier);
            if (block != null) {
                MutableComponent name = block.m_49954_();
                textList.add((Component)Component.m_237113_((String)" - ").m_7220_((Component)name).m_7220_((Component)Component.m_237113_((String)(" x" + this.wirelessEnergyUnitPositions.get(tier).size())).m_130940_(tier > casingTier ? ChatFormatting.RED : ChatFormatting.GREEN)));
            }
        });
    }

    @NotNull
    private ChatFormatting getStorageColor(BigInteger capacity, BigInteger storage) {
        BigDecimal percentage;
        double ratio;
        ChatFormatting color = capacity.signum() == 0 ? (storage.signum() == 1 ? ChatFormatting.GOLD : ChatFormatting.GRAY) : ((ratio = (percentage = new BigDecimal(storage).divide(new BigDecimal(capacity), 4, RoundingMode.HALF_UP)).doubleValue()) < 0.1 ? ChatFormatting.RED : (ratio < 0.5 ? ChatFormatting.YELLOW : ChatFormatting.GREEN));
        return color;
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        IFancyConfigurator[] iFancyConfiguratorArray = new IFancyConfigurator[1];
        Configurator c = new Configurator((IGuiTexture)GuiTextures.LIGHT_ON, (IGuiTexture)GuiTextures.LIGHT_OFF);
        iFancyConfiguratorArray[0] = c;
        configuratorPanel.attachConfigurators(iFancyConfiguratorArray);
        if (this.isRemote()) {
            c.setHudInstance("wireless_energy_hud");
        }
    }

    public Object2IntMap<String> getCasingTiers() {
        return this.tierCasingTrait.getCasingTiers();
    }

    public IEnergyInfoProvider.EnergyInfo getEnergyInfo() {
        ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return new IEnergyInfoProvider.EnergyInfo(BigInteger.ZERO, BigInteger.ZERO);
        }
        return new IEnergyInfoProvider.EnergyInfo(container.getCapacity(), container.getStorage());
    }

    public boolean supportsBigIntEnergyValues() {
        return true;
    }

    @Nullable
    public UUID getUUID() {
        return this.getOwnerUUID();
    }

    public void setWirelessEnergyContainerCache(WirelessEnergyContainer WirelessEnergyContainerCache) {
        this.WirelessEnergyContainerCache = WirelessEnergyContainerCache;
    }

    public WirelessEnergyContainer getWirelessEnergyContainerCache() {
        return this.WirelessEnergyContainerCache;
    }

    public long getInputPerSec() {
        ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return 0L;
        }
        long input = BigIntegerUtils.getLongValue((BigInteger)container.getEnergyStat().getAvgEnergy().toBigInteger());
        return input > 0L ? input : 0L;
    }

    public long getOutputPerSec() {
        ExtendWirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return 0L;
        }
        long output = BigIntegerUtils.getLongValue((BigInteger)container.getEnergyStat().getAvgEnergy().toBigInteger().negate());
        return output > 0L ? output : 0L;
    }

    public int substituteBlocks(WirelessEnergyUnitBlock block, int count, ServerPlayer player) {
        if (this.getLevel() == null || this.wirelessEnergyUnitPositions.isEmpty() || count <= 0) {
            return 0;
        }
        ArrayList<WirelessEnergyUnitBlock.BlockData> candidates = new ArrayList<WirelessEnergyUnitBlock.BlockData>();
        int tier = block.getTier();
        for (int t = 1; t < tier; ++t) {
            Collection positionsForTier = this.wirelessEnergyUnitPositions.get((Object)t);
            for (BlockPos pos : positionsForTier) {
                if (pos == null) continue;
                candidates.add(new WirelessEnergyUnitBlock.BlockData(WirelessEnergyUnitBlock.get(t), pos));
            }
        }
        if (candidates.isEmpty()) {
            return 0;
        }
        candidates.sort(Comparator.comparingInt(data -> data.pos().m_123342_()).thenComparingInt(data -> data.pos().m_123341_()).thenComparingInt(data -> data.pos().m_123343_()));
        int numToReplace = Math.min(count, candidates.size());
        List toReplace = candidates.subList(0, numToReplace);
        int successfulCount = 0;
        for (WirelessEnergyUnitBlock.BlockData data2 : toReplace) {
            BlockPos pos = data2.pos();
            WirelessEnergyUnitBlock originBlockDrop = data2.block();
            if (!this.getLevel().m_7731_(pos, block.m_49966_(), 11)) continue;
            ++successfulCount;
            if (originBlockDrop == null || player.m_150109_().m_36054_(originBlockDrop.m_5456_().m_7968_())) continue;
            player.m_36176_(originBlockDrop.m_5456_().m_7968_(), false);
        }
        if (successfulCount > 0) {
            this.requestCheck();
        }
        return successfulCount;
    }
}

