/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.steam;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gtocore.common.data.GTOBlocks;
import com.gtolib.api.annotation.Scanned;
import com.gtolib.api.annotation.dynamic.DynamicInitialValue;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.machine.feature.IEnhancedRecipeLogicMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

@Scanned
public class LargeSteamSolarBoilerMachine
extends WorkableMultiblockMachine
implements IExplosionMachine,
IDisplayUIMachine,
IEnhancedRecipeLogicMachine {
    @DynamicInitialValue(key="gtocore.machine.large_steam_solar_boiler", typeKey="multiplier", easyValue="30", normalValue="18", expertValue="12", cn="\u57fa\u7840\u84b8\u6c7d\u4ea7\u7387 : %s / t", en="Basic steam production : %s / t")
    private static int basicSteamProduction = 10;
    private static final int MAX_LR_DIST = 62;
    private static final int MAX_B_DIST = 125;
    private static final int MIN_LR_DIST = 1;
    private static final int MIN_B_DIST = 3;
    private static final int STEAM_GENERATION_INTERVAL = 20;
    private int lDist;
    private int rDist;
    private int bDist;
    private int sunlit;
    private int steamGenerated;
    private int timing;
    private boolean formed;

    public LargeSteamSolarBoilerMachine(MetaMachineBlockEntity holder) {
        super(holder, new Object[0]);
    }

    private void updateStructureDimensions() {
        int newRDist;
        Level world = this.getLevel();
        if (world == null) {
            this.resetStructure();
            return;
        }
        Direction front = this.getFrontFacing();
        Direction back = front.m_122424_();
        Direction left = front.m_122428_();
        Direction right = left.m_122424_();
        int newBDist = LargeSteamSolarBoilerMachine.calculateDistance(world, this.getPos(), back, 125);
        int newLDist = LargeSteamSolarBoilerMachine.calculateDistance(world, this.getPos().m_121945_(back), left, 62);
        if (this.validateStructure(world, front, newLDist, newRDist = LargeSteamSolarBoilerMachine.calculateDistance(world, this.getPos().m_121945_(back), right, 62), newBDist)) {
            this.lDist = newLDist;
            this.rDist = newRDist;
            this.bDist = newBDist;
            this.formed = true;
        } else {
            this.resetStructure();
        }
    }

    private static int calculateDistance(Level world, BlockPos startPos, Direction direction, int maxDistance) {
        int distance = 0;
        BlockPos.MutableBlockPos pos = startPos.m_122032_();
        int i = 1;
        while (i <= maxDistance) {
            pos.m_122173_(direction);
            if (!LargeSteamSolarBoilerMachine.isBlockSolar(world, (BlockPos)pos)) break;
            distance = i++;
        }
        return distance;
    }

    private boolean validateStructure(Level world, Direction front, int lDist, int rDist, int bDist) {
        if (lDist < 1 || rDist < 1 || bDist < 3 || lDist > 62 || rDist > 62 || bDist > 125) {
            return false;
        }
        Direction back = front.m_122424_();
        Direction left = front.m_122428_();
        Direction right = left.m_122424_();
        BlockPos startPos = this.getPos();
        for (int b2 = 1; b2 <= bDist; ++b2) {
            BlockPos backPos = startPos.m_5484_(back, b2);
            for (int l = 1; l <= lDist; ++l) {
                if (LargeSteamSolarBoilerMachine.isBlockSolar(world, backPos.m_5484_(left, l))) continue;
                return false;
            }
            for (int r = 1; r <= rDist; ++r) {
                if (LargeSteamSolarBoilerMachine.isBlockSolar(world, backPos.m_5484_(right, r))) continue;
                return false;
            }
        }
        return true;
    }

    private void resetStructure() {
        this.bDist = 0;
        this.rDist = 0;
        this.lDist = 0;
        this.formed = false;
    }

    private static boolean isBlockSolar(@NotNull Level world, @NotNull BlockPos pos) {
        return world.m_8055_(pos).m_60713_((Block)GTOBlocks.SOLAR_HEAT_COLLECTOR_PIPE_CASING.get());
    }

    @NotNull
    public BlockPattern getPattern() {
        if (this.getLevel() != null) {
            this.updateStructureDimensions();
        }
        int safeLDist = this.formed ? this.lDist : 1;
        int safeRDist = this.formed ? this.rDist : 1;
        int safeBDist = this.formed ? this.bDist : 3;
        int totalWidth = safeLDist + safeRDist + 3;
        String boundaryRow = "a".repeat(totalWidth);
        String middleRow = "a" + "b".repeat(totalWidth - 2) + "a";
        String controllerRow = "a".repeat(safeLDist + 1) + "~" + "a".repeat(safeRDist + 1);
        return FactoryBlockPattern.start((RelativeDirection)RelativeDirection.LEFT, (RelativeDirection)RelativeDirection.UP, (RelativeDirection)RelativeDirection.FRONT).aisle(new String[]{boundaryRow}).aisle(new String[]{middleRow}).setRepeatable(safeBDist).aisle(new String[]{controllerRow}).where('a', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.STEEL_HULL.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.EXPORT_FLUIDS})).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_FLUIDS}))).where('b', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.SOLAR_HEAT_COLLECTOR_PIPE_CASING.get()})).where('~', Predicates.controller((MachineDefinition)this.getDefinition())).build();
    }

    public boolean keepSubscribing() {
        return true;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }

    private Recipe getRecipe() {
        Level level = this.getLevel();
        if (level != null && this.isFormed()) {
            if (this.timing == 0) {
                this.sunlit = this.calculateSunlit(level);
                this.timing = 5;
            } else {
                --this.timing;
            }
            if (this.sunlit > 0) {
                return this.createNextRecipe();
            }
        }
        return null;
    }

    private int calculateSunlit(Level level) {
        if (!this.isAppropriateDimensionAndTime(level, this.getPos())) {
            return 0;
        }
        int count = 0;
        Direction front = this.getFrontFacing();
        Direction back = front.m_122424_();
        Direction left = front.m_122428_();
        Direction right = left.m_122424_();
        BlockPos pos = this.getPos();
        for (int i = 1; i <= this.bDist; ++i) {
            int j;
            if (LargeSteamSolarBoilerMachine.hasClearSky(level, pos.m_5484_(back, i))) {
                ++count;
            }
            for (j = 1; j <= this.lDist; ++j) {
                if (!LargeSteamSolarBoilerMachine.hasClearSky(level, pos.m_5484_(back, i).m_5484_(left, j))) continue;
                ++count;
            }
            for (j = 1; j <= this.rDist; ++j) {
                if (!LargeSteamSolarBoilerMachine.hasClearSky(level, pos.m_5484_(back, i).m_5484_(right, j))) continue;
                ++count;
            }
        }
        return count;
    }

    private boolean isAppropriateDimensionAndTime(Level world, BlockPos pos) {
        if (GTODimensions.isVoid((ResourceLocation)world.m_46472_().m_135782_())) {
            return true;
        }
        if (!world.m_46461_()) {
            this.getEnhancedRecipeLogic().gtolib$setIdleReason((Component)Component.m_237115_((String)"gtceu.recipe_logic.condition_fails").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"recipe.condition.daytime.day.tooltip")));
            return false;
        }
        return true;
    }

    private static boolean hasClearSky(Level world, BlockPos pos) {
        BlockPos checkPos = pos.m_7494_();
        if (!world.m_45527_(checkPos)) {
            return false;
        }
        Biome biome = (Biome)world.m_204166_(checkPos).m_203334_();
        boolean hasPrecipitation = world.m_46471_() && (biome.m_198906_(checkPos) || biome.m_198904_(checkPos));
        return !hasPrecipitation;
    }

    private Recipe createNextRecipe() {
        int steamAmount = basicSteamProduction * this.sunlit * 20;
        int waterAmount = (int)Math.ceil((double)steamAmount / (double)ConfigHolder.INSTANCE.machines.largeBoilers.steamPerWater);
        if (waterAmount <= 0 || steamAmount <= 0) {
            return null;
        }
        this.steamGenerated = steamAmount;
        return this.getRecipeBuilder().inputFluids((Fluid)Fluids.f_76193_, (long)waterAmount).outputFluids(GTMaterials.Steam.getFluid(), (long)steamAmount).duration(20).buildRawRecipe();
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.isFormed()) {
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.large_steam_solar_boiler.size", (Object[])new Object[]{this.lDist + this.rDist + 3, this.bDist + 2}));
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.large_steam_solar_boiler.heat_collector_pipe", (Object[])new Object[]{this.sunlit}));
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.large_steam_solar_boiler.steam_production", (Object[])new Object[]{this.steamGenerated}));
        } else {
            textList.add((Component)Component.m_237115_((String)"gtceu.top.invalid_structure"));
        }
    }
}

