/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.steam;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ItemBusPartMachine;
import com.gtocore.common.machine.multiblock.steam.BaseSteamMultiblockMachine;
import com.gtolib.api.annotation.Scanned;
import com.gtolib.api.annotation.dynamic.DynamicInitialValue;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.utils.ItemUtils;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Scanned
public final class LargeSteamCircuitAssemblerMachine
extends BaseSteamMultiblockMachine {
    @Persisted
    private boolean isMultiMode = true;
    @DynamicInitialValue(key="gtceu.machine.multiblock.steam.large_circuit_assembler.max_parallel", typeKey="max_parallel", en="Max Parallels", cn="\u6700\u5927\u5e76\u884c\u6570", easyValue="8", normalValue="4", expertValue="4")
    private static int MAX_PARALLELS = 4;
    @DynamicInitialValue(key="gtceu.machine.multiblock.steam.large_circuit_assembler.reduction_duration", typeKey="multiplier", easyValue="2", normalValue="4", expertValue="6", cn="\u589e\u4ea7\u6a21\u5f0f\u8017\u65f6\u4e3a\u666e\u901a\u7684 : %s \u500d", cnComment="\u66f4\u591a\u7684\u65f6\u95f4\uff0c\u66f4\u9ad8\u7684\u4ea7\u51fa\uff0c\u4e00\u62a5\u6362\u4e00\u62a5\u8fd9\u5f88\u5408\u7406", en="Multiply Mode, Recipe Duration: x %s", enComment="More time, higher output, this is reasonable")
    private static int RECIPE_DURATION_MULTIPLY = 4;
    @DynamicInitialValue(key="gtceu.machine.multiblock.steam.large_circuit_assembler.steam_cost", typeKey="multiplier", easyValue="2", normalValue="4", expertValue="6", cn="\u589e\u4ea7\u6a21\u5f0f\u84b8\u6c7d\u6d88\u8017\u4e3a\u666e\u901a\u7684 : %s \u500d", en="Multiply Mode Steam Cost: x %s")
    private static int COST_STEAM_MULTIPLY = 4;
    @DynamicInitialValue(key="gtceu.machine.multiblock.steam.large_circuit_assembler.multiply", typeKey="multiplier", easyValue="4", normalValue="2", expertValue="2", cn="\u589e\u4ea7\u6a21\u5f0f\u500d\u7387\u4e3a\u666e\u901a\u7684 : %s \u500d", en="Multiply Mode Multiply Output: x %s")
    private static int PRODUCT_MULTIPLY = 4;
    @DynamicInitialValue(key="gtceu.machine.multiblock.steam.large_circuit_assembler.engraving_needed_amount", typeKey="amount", cn="\u8680\u523b\u7535\u8def\u6240\u9700\u6570\u91cf", cnComment="\u6267\u884c\u76f8\u5e94\u7535\u8def\u7ec4\u88c5\u914d\u65b9\u524d\uff0c\u9700\u8981\u8680\u523b\u6b64\u7535\u8def\u6240\u9700\u7684\u7269\u54c1\u6570\u91cf", en="Engraving Circuit Needed Amount", enComment="The amount of items needed to engrave the circuit before executing the corresponding circuit assembly recipe\n", easyValue="8", normalValue="16", expertValue="32")
    private static int Engraving_needed_amount = 16;
    @Persisted
    private Item item;
    @Persisted
    private int count;
    @RegisterLanguage(cn="\u589e\u4ea7\u6a21\u5f0f : ", en="Is Multiply Mode Enabled : ")
    private static final String IS_MULTIPLY = "gtocore.machine.large_steam_circuit_assembler.is_multiply";

    @Override
    boolean oc() {
        return true;
    }

    public LargeSteamCircuitAssemblerMachine(MetaMachineBlockEntity holder) {
        super(holder, MAX_PARALLELS, 128, 1.0);
    }

    @Override
    @Nullable
    protected GTRecipe getRealRecipe(GTRecipe recipe) {
        if (this.count < Engraving_needed_amount) {
            return null;
        }
        Content content = (Content)((List)recipe.outputs.get(ItemRecipeCapability.CAP)).get(0);
        if (ItemUtils.getFirstSized((Ingredient)((Ingredient)ItemRecipeCapability.CAP.of(content.getContent()))).m_41720_() == this.item) {
            if (this.isMultiMode) {
                recipe.outputs.put(ItemRecipeCapability.CAP, List.of(content.copy((RecipeCapability)ItemRecipeCapability.CAP, ContentModifier.multiplier((double)PRODUCT_MULTIPLY))));
                recipe = super.getRealRecipe(recipe);
                if (recipe != null) {
                    recipe.duration *= RECIPE_DURATION_MULTIPLY;
                    ((Recipe)recipe).eut = recipe.getInputEUt() * (long)COST_STEAM_MULTIPLY;
                }
                return recipe;
            }
            return super.getRealRecipe(recipe);
        }
        return null;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.isFormed()) {
            textList.add(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"gtocore.machine.large_steam_circuit_assembler.engrave_circuit"), (String)"engraveCircuit"));
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.large_steam_circuit_assembler.circuit", (Object[])new Object[]{this.item == null ? "null" : Component.m_237115_((String)this.item.m_5524_())}));
            if (this.item != null && this.count < Engraving_needed_amount) {
                textList.add((Component)Component.m_237110_((String)"gui.ae2.Missing", (Object[])new Object[]{Engraving_needed_amount - this.count}));
            }
            if (this.isMultiMode) {
                textList.add((Component)Component.m_237110_((String)IS_MULTIPLY, (Object[])new Object[]{true}).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"gtocore.machine.on"), (String)"toggleMultiMode")));
            }
            if (!this.isMultiMode) {
                textList.add((Component)Component.m_237110_((String)IS_MULTIPLY, (Object[])new Object[]{false}).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"gtocore.machine.off"), (String)"toggleMultiMode")));
            }
        }
    }

    @Override
    public void handleDisplayClick(String componentData, ClickData clickData) {
        super.handleDisplayClick(componentData, clickData);
        if (!clickData.isRemote && "toggleMultiMode".equals(componentData)) {
            boolean bl = this.isMultiMode = !this.isMultiMode;
        }
        if (!clickData.isRemote && "engraveCircuit".equals(componentData)) {
            for (IMultiPart part : this.getParts()) {
                ItemBusPartMachine bus;
                NotifiableItemStackHandler inv;
                IO io;
                if (!(part instanceof ItemBusPartMachine) || (io = (inv = (bus = (ItemBusPartMachine)part).getInventory()).getHandlerIO()) != IO.IN && io != IO.BOTH) continue;
                for (int i = 0; i < inv.getSlots(); ++i) {
                    ItemStack stack = inv.getStackInSlot(i);
                    for (TagKey tagKey : stack.m_204131_().toList()) {
                        if (!tagKey.f_203868_().toString().contains("gtceu:circuits/")) continue;
                        int c = stack.m_41613_();
                        if (stack.m_41720_() == this.item) {
                            c = Math.min(Engraving_needed_amount - this.count, c);
                            this.count += c;
                        } else {
                            this.count = c = Math.min(Engraving_needed_amount, c);
                        }
                        this.item = stack.m_41720_();
                        inv.extractItemInternal(i, c, false);
                        if (this.count < Engraving_needed_amount) continue;
                        return;
                    }
                }
            }
        }
    }
}

