/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae.slots;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.fast.recipesearch.IntLongMap;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlot;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlotList;
import com.gregtechceu.gtceu.utils.function.ObjectLongConsumer;
import com.gregtechceu.gtceu.utils.function.ObjectLongPredicate;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAEFluidSlot;
import com.gtolib.api.ae2.stacks.IAEFluidKey;
import com.gtolib.api.recipe.RecipeType;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class ExportOnlyAEFluidList
extends NotifiableFluidTank
implements IConfigurableSlotList {
    @Persisted
    final ExportOnlyAEFluidSlot[] inventory;

    public ExportOnlyAEFluidList(MetaMachine machine, int slots) {
        this(machine, slots, ExportOnlyAEFluidSlot::new);
    }

    ExportOnlyAEFluidList(MetaMachine machine, int slots, Supplier<ExportOnlyAEFluidSlot> slotFactory) {
        super(machine, slots, 0, IO.IN, IO.NONE);
        this.inventory = new ExportOnlyAEFluidSlot[slots];
        for (int i = 0; i < slots; ++i) {
            this.inventory[i] = slotFactory.get();
            this.storages[i] = new FluidStorageDelegate(this.inventory[i]);
            this.inventory[i].setOnContentsChanged(() -> ((ExportOnlyAEFluidList)this).onContentsChanged());
        }
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (ExportOnlyAEFluidSlot i : this.inventory) {
                GenericStack stock;
                if (i.config == null || (stock = i.stock) == null || stock.amount() == 0L) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.inventory[tank].getFluid();
    }

    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
    }

    public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, boolean simulate) {
        if (io == IO.IN) {
            boolean changed = false;
            Iterator<FluidIngredient> it = left.iterator();
            block0: while (it.hasNext()) {
                FluidIngredient ingredient = it.next();
                if (ingredient.isEmpty()) {
                    it.remove();
                    continue;
                }
                long a2 = FastFluidIngredient.getAmount((FluidIngredient)ingredient);
                if (a2 < 1L) {
                    it.remove();
                    continue;
                }
                for (ExportOnlyAEFluidSlot i : this.inventory) {
                    long drained;
                    AEFluidKey fluidKey;
                    long amount;
                    GenericStack stored = i.stock;
                    if (stored == null || (amount = stored.amount()) == 0L) continue;
                    AEKey aEKey = stored.what();
                    if (aEKey instanceof AEFluidKey && FastFluidIngredient.testAeKay((FluidIngredient)ingredient, (AEFluidKey)(fluidKey = (AEFluidKey)aEKey)) && (drained = i.drain(a2, simulate, false)) > 0L) {
                        changed = true;
                        FastFluidIngredient.setAmount((FluidIngredient)ingredient, (long)(a2 -= drained));
                    }
                    if (a2 > 0L) continue;
                    it.remove();
                    continue block0;
                }
            }
            if (!simulate && changed) {
                this.onContentsChanged();
            }
        }
        return left.isEmpty() ? null : left;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    public boolean supportsFill(int tank) {
        return false;
    }

    public FluidStack drainInternal(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack totalDrained = null;
        for (ExportOnlyAEFluidSlot tank : this.inventory) {
            if (totalDrained == null || totalDrained.isEmpty()) {
                totalDrained = tank.drain(maxDrain, action);
                if (totalDrained.isEmpty()) {
                    totalDrained = null;
                } else {
                    maxDrain -= totalDrained.getAmount();
                }
            } else {
                FluidStack copy = totalDrained.copy();
                copy.setAmount(maxDrain);
                FluidStack drain = tank.drain(copy, action);
                totalDrained.grow(drain.getAmount());
                maxDrain -= drain.getAmount();
            }
            if (maxDrain <= 0) break;
        }
        return totalDrained == null ? FluidStack.EMPTY : totalDrained;
    }

    public boolean forEachFluids(ObjectLongPredicate<FluidStack> function) {
        for (ExportOnlyAEFluidSlot i : this.inventory) {
            GenericStack stock;
            if (i.config == null || (stock = i.stock) == null || stock.amount() == 0L || !function.test((Object)i.getReadOnlyStack(), stock.amount())) continue;
            return true;
        }
        return false;
    }

    public void fastForEachFluids(ObjectLongConsumer<FluidStack> function) {
        for (ExportOnlyAEFluidSlot i : this.inventory) {
            GenericStack stock;
            if (i.config == null || (stock = i.stock) == null || stock.amount() == 0L) continue;
            function.accept((Object)i.getReadOnlyStack(), stock.amount());
        }
    }

    public IntLongMap getIngredientMap(@NotNull GTRecipeType type) {
        if (this.changed) {
            this.changed = false;
            this.intIngredientMap.clear();
            boolean specialConverter = ((RecipeType)type).specialConverter;
            for (ExportOnlyAEFluidSlot i : this.inventory) {
                AEKey aEKey;
                GenericStack stock;
                if (i.config == null || (stock = i.stock) == null || stock.amount() == 0L || !((aEKey = stock.what()) instanceof AEFluidKey)) continue;
                AEFluidKey fluidKey = (AEFluidKey)aEKey;
                if (specialConverter) {
                    type.convertFluid(i.getReadOnlyStack(), stock.amount(), this.intIngredientMap);
                    continue;
                }
                ((IAEFluidKey)fluidKey).gtolib$convert(stock.amount(), this.intIngredientMap);
            }
        }
        return this.intIngredientMap;
    }

    public IConfigurableSlot getConfigurableSlot(int index) {
        return this.inventory[index];
    }

    public int getConfigurableSlots() {
        return this.inventory.length;
    }

    public boolean isAutoPull() {
        return false;
    }

    public boolean isStocking() {
        return false;
    }

    @Generated
    public ExportOnlyAEFluidSlot[] getInventory() {
        return this.inventory;
    }

    private static class FluidStorageDelegate
    extends CustomFluidTank {
        private final ExportOnlyAEFluidSlot fluid;

        FluidStorageDelegate(ExportOnlyAEFluidSlot fluid) {
            super(Integer.MAX_VALUE);
            this.fluid = fluid;
        }

        @NotNull
        public FluidStack getFluid() {
            return this.fluid.getFluid();
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.fluid.drain(maxDrain, action);
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.fluid.drain(resource, action);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public boolean supportsFill(int tank) {
            return false;
        }
    }
}

