/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyMap;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfiguratorButton;
import com.gregtechceu.gtceu.api.gui.widget.LongInputWidget;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.integration.ae2.machine.feature.IGridConnectedMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.GridNodeHolder;
import com.gtocore.api.data.Algae;
import com.gtolib.api.ae2.stacks.IKeyCounter;
import com.gtolib.api.ae2.storage.BigCellDataStorage;
import com.gtolib.api.ae2.storage.CellDataStorage;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.part.AmountConfigurationPartMachine;
import com.hepdd.gtmthings.utils.BigIntegerUtils;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.network.chat.Component;

@DataGeneratorScanned
public abstract class StorageAccessPartMachine
extends AmountConfigurationPartMachine
implements IMachineLife,
MEStorage,
IGridConnectedMachine,
IStorageProvider {
    boolean observe;
    int counter;
    boolean check;
    boolean dirty = false;
    @Persisted
    double capacity;
    @Persisted
    boolean isInfinite;
    @DescSynced
    boolean isOnline;
    @Persisted
    public UUID uuid;
    @Persisted
    private final GridNodeHolder nodeHolder = new GridNodeHolder((IGridConnectedMachine)this);
    private final ConditionalSubscriptionHandler tickSubs;
    @RegisterLanguage(cn="\u4eceME\u5b58\u50a8\u5668\u5bfc\u51fa", en="Export from ME Storage")
    private static final String LANG_EXPORT = "gtocore.machine.part.ae.storage_access.export";
    @RegisterLanguage(cn="\u5bfc\u5165\u5230ME\u5b58\u50a8\u5668", en="Import to ME Storage")
    private static final String LANG_IMPORT = "gtocore.machine.part.ae.storage_access.import";
    @RegisterLanguage(cn="\u5bfc\u5165/\u5bfc\u51fa\u901f\u7387\u8bbe\u7f6e", en="Import/Export Rate Setting")
    private static final String LANG_RATE_SETTING = "gtocore.machine.part.ae.storage_access.rate_setting";

    public static StorageAccessPartMachine create(MetaMachineBlockEntity holder) {
        return new LONG(holder);
    }

    public static StorageAccessPartMachine createBig(MetaMachineBlockEntity holder) {
        return new Big(holder);
    }

    public static StorageAccessPartMachine createIO(MetaMachineBlockEntity holder) {
        return new IO(holder);
    }

    public static StorageAccessPartMachine createAlgae(MetaMachineBlockEntity holder) {
        return new AlgaeAccessHatch(holder);
    }

    StorageAccessPartMachine(MetaMachineBlockEntity holder) {
        super(holder, 4, -1000000L, 1000000L);
        this.getMainNode().addService(IStorageProvider.class, (IGridNodeService)this);
        this.tickSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::tickUpdate, 0, () -> true);
        this.current = 0L;
    }

    public Widget createUIWidget() {
        return ((WidgetGroup)super.createUIWidget()).addWidget((Widget)new LabelWidget(24, -16, () -> "gui.ae2.Priority"));
    }

    public void onLoad() {
        super.onLoad();
        this.tickSubs.initialize(this.getLevel());
    }

    public void onUnload() {
        super.onUnload();
        this.tickSubs.unsubscribe();
    }

    protected long getCurrent() {
        return this.current;
    }

    protected void onAmountChange(long amount) {
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    abstract void tickUpdate();

    public abstract void setUUID(UUID var1);

    public abstract int getTypes();

    public abstract double getBytes();

    public void mountInventories(IStorageMounts storageMounts) {
        if (this.uuid == null) {
            return;
        }
        storageMounts.mount((MEStorage)this, (int)this.current);
    }

    public Component getDescription() {
        return this.getDefinition().asItem().m_41466_();
    }

    public IManagedGridNode getMainNode() {
        return this.nodeHolder.getMainNode();
    }

    public void setOnline(boolean isOnline) {
        this.isOnline = isOnline;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    @Generated
    public void setObserve(boolean observe) {
        this.observe = observe;
    }

    @Generated
    public void setCheck(boolean check) {
        this.check = check;
    }

    @Generated
    public void setCapacity(double capacity) {
        this.capacity = capacity;
    }

    @Generated
    public double getCapacity() {
        return this.capacity;
    }

    @Generated
    public void setInfinite(boolean isInfinite) {
        this.isInfinite = isInfinite;
    }

    @Generated
    public boolean isInfinite() {
        return this.isInfinite;
    }

    private static class LONG
    extends StorageAccessPartMachine {
        private CellDataStorage dataStorage;

        private LONG(MetaMachineBlockEntity holder) {
            super(holder);
        }

        @Override
        public void setUUID(UUID uuid) {
            this.uuid = uuid;
            this.dataStorage = null;
            IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
        }

        @Override
        public int getTypes() {
            if (this.dataStorage == null || this.dataStorage.getStoredMap() == null) {
                return 0;
            }
            return this.dataStorage.getStoredMap().size();
        }

        @Override
        public double getBytes() {
            if (this.dataStorage == null) {
                return 0.0;
            }
            return this.dataStorage.getBytes();
        }

        @Override
        void tickUpdate() {
            if (this.dirty) {
                this.dirty = false;
                this.getCellStorage().setDirty();
            }
            if (this.uuid == null || this.capacity == 0.0 || !this.isOnline) {
                return;
            }
            if (!this.check) {
                ++this.counter;
                if (this.counter > 600) {
                    this.counter = 0;
                    this.capacity = 0.0;
                    this.setUUID(null);
                    this.isInfinite = false;
                }
            }
            if (this.observe) {
                this.observe = false;
                CellDataStorage storage = this.getCellStorage();
                double totalAmount = 0.0;
                ObjectIterator it = this.getCellStoredMap().reference2LongEntrySet().fastIterator();
                while (it.hasNext()) {
                    Reference2LongMap.Entry entry = (Reference2LongMap.Entry)it.next();
                    totalAmount += (double)entry.getLongValue() / (double)((AEKey)entry.getKey()).getType().getAmountPerByte();
                }
                storage.setBytes(totalAmount);
            } else if (!this.isInfinite && this.getOffsetTimer() % 20 == 7) {
                this.observe = true;
            }
        }

        private CellDataStorage getCellStorage() {
            if (this.dataStorage != null) {
                return this.dataStorage;
            }
            if (this.uuid == null || this.isRemote()) {
                return CellDataStorage.EMPTY;
            }
            this.dataStorage = CellDataStorage.get((UUID)this.uuid);
            return this.dataStorage;
        }

        private AEKeyMap<AEKey> getCellStoredMap() {
            CellDataStorage data = this.getCellStorage();
            AEKeyMap map = data.getStoredMap();
            if (map == null) {
                map = new AEKeyMap();
                data.setStoredMap(map);
            }
            return map;
        }

        public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
            return this.isInfinite || this.capacity > this.getCellStorage().getBytes();
        }

        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (amount == 0L || this.uuid == null) {
                return 0L;
            }
            CellDataStorage data = this.getCellStorage();
            if (data == CellDataStorage.EMPTY) {
                return 0L;
            }
            if (!this.isInfinite) {
                amount = (long)Math.min(this.capacity - data.getBytes(), (double)amount);
            }
            if (amount < 1L) {
                return 0L;
            }
            if (mode == Actionable.MODULATE) {
                this.getCellStoredMap().addTo((Object)what, amount);
                this.dirty = true;
            }
            return amount;
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            AEKeyMap<AEKey> map = this.getCellStoredMap();
            long currentAmount = map.getLong((Object)what);
            if (currentAmount > 0L) {
                if (amount >= currentAmount) {
                    if (mode == Actionable.MODULATE) {
                        map.remove((Object)what, currentAmount);
                        this.dirty = true;
                    }
                    return currentAmount;
                }
                if (mode == Actionable.MODULATE) {
                    map.put((Object)what, currentAmount - amount);
                    this.dirty = true;
                }
                return amount;
            }
            return 0L;
        }

        public void getAvailableStacks(KeyCounter out) {
            CellDataStorage data = this.getCellStorage();
            if (data == CellDataStorage.EMPTY) {
                return;
            }
            AEKeyMap map = data.getStoredMap();
            if (map == null) {
                return;
            }
            IKeyCounter.addAll((KeyCounter)out, (int)map.size(), m -> map.reference2LongEntrySet().fastForEach(e -> m.addTo((Object)((AEKey)e.getKey()), e.getLongValue())));
        }

        public KeyCounter getAvailableStacks() {
            CellDataStorage data = this.getCellStorage();
            KeyCounter keyCounter = data.getKeyCounter();
            if (keyCounter == null) {
                keyCounter = new KeyCounter();
                data.setKeyCounter(keyCounter);
            } else {
                keyCounter.clear();
            }
            this.getAvailableStacks(keyCounter);
            keyCounter.removeEmptySubmaps();
            return keyCounter;
        }
    }

    public static final class Big
    extends StorageAccessPartMachine {
        private BigCellDataStorage dataStorage;

        private Big(MetaMachineBlockEntity holder) {
            super(holder);
        }

        @Override
        public void setUUID(UUID uuid) {
            this.uuid = uuid;
            this.dataStorage = null;
            IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
        }

        @Override
        public int getTypes() {
            if (this.dataStorage == null || this.dataStorage.getStoredMap() == null) {
                return 0;
            }
            return this.dataStorage.getStoredMap().size();
        }

        @Override
        public double getBytes() {
            if (this.dataStorage == null) {
                return 0.0;
            }
            return this.dataStorage.getBytes();
        }

        @Override
        void tickUpdate() {
            if (this.dirty) {
                this.dirty = false;
                this.getCellStorage().setDirty();
            }
            if (this.uuid == null || this.capacity == 0.0 || !this.isOnline) {
                return;
            }
            if (!this.check) {
                ++this.counter;
                if (this.counter > 600) {
                    this.counter = 0;
                    this.capacity = 0.0;
                    this.setUUID(null);
                    this.isInfinite = false;
                }
            }
            if (this.observe) {
                this.observe = false;
                BigCellDataStorage data = this.getCellStorage();
                if (data == BigCellDataStorage.EMPTY) {
                    return;
                }
                Reference2ReferenceOpenHashMap map = data.getStoredMap();
                if (map == null) {
                    return;
                }
                double totalAmount = 0.0;
                ObjectIterator it = map.reference2ReferenceEntrySet().fastIterator();
                while (it.hasNext()) {
                    Reference2ReferenceMap.Entry entry = (Reference2ReferenceMap.Entry)it.next();
                    totalAmount += ((BigInteger)entry.getValue()).doubleValue() / (double)((AEKey)entry.getKey()).getType().getAmountPerByte();
                }
                data.setBytes(totalAmount);
            } else if (!this.isInfinite && this.getOffsetTimer() % 20 == 7) {
                this.observe = true;
            }
        }

        public BigCellDataStorage getCellStorage() {
            if (this.dataStorage != null) {
                return this.dataStorage;
            }
            if (this.uuid == null || this.isRemote()) {
                return BigCellDataStorage.EMPTY;
            }
            this.dataStorage = BigCellDataStorage.get((UUID)this.uuid);
            return this.dataStorage;
        }

        private Reference2ReferenceOpenHashMap<AEKey, BigInteger> getCellStoredMap() {
            BigCellDataStorage data = this.getCellStorage();
            Reference2ReferenceOpenHashMap map = data.getStoredMap();
            if (map == null) {
                map = new Reference2ReferenceOpenHashMap();
                data.setStoredMap(map);
            }
            return map;
        }

        public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
            return this.isInfinite || this.capacity > this.getCellStorage().getBytes();
        }

        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (amount == 0L || this.uuid == null) {
                return 0L;
            }
            BigCellDataStorage data = this.getCellStorage();
            if (data == BigCellDataStorage.EMPTY) {
                return 0L;
            }
            if (!this.isInfinite) {
                amount = (long)Math.min(this.capacity - data.getBytes(), (double)amount);
            }
            if (amount < 1L) {
                return 0L;
            }
            if (mode == Actionable.MODULATE) {
                long finalAmount = amount;
                this.getCellStoredMap().compute((Object)what, (k, v) -> {
                    if (v == null) {
                        return BigInteger.valueOf(finalAmount);
                    }
                    return v.add(BigInteger.valueOf(finalAmount));
                });
                this.dirty = true;
            }
            return amount;
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            BigCellDataStorage data = this.getCellStorage();
            if (data == BigCellDataStorage.EMPTY) {
                return 0L;
            }
            Reference2ReferenceOpenHashMap map = data.getStoredMap();
            if (map == null) {
                return 0L;
            }
            BigInteger o = (BigInteger)map.get((Object)what);
            if (o == null) {
                return 0L;
            }
            if (o.signum() > 0) {
                BigInteger extractAmount = BigInteger.valueOf(amount);
                if (o.compareTo(extractAmount) < 1) {
                    if (mode == Actionable.MODULATE) {
                        map.remove((Object)what);
                        this.dirty = true;
                    }
                    return o.longValue();
                }
                if (mode == Actionable.MODULATE) {
                    map.put((Object)what, (Object)o.subtract(extractAmount));
                    this.dirty = true;
                }
                return amount;
            }
            return 0L;
        }

        public void getAvailableStacks(KeyCounter out) {
            BigCellDataStorage data = this.getCellStorage();
            if (data == BigCellDataStorage.EMPTY) {
                return;
            }
            Reference2ReferenceOpenHashMap map = data.getStoredMap();
            if (map == null) {
                return;
            }
            IKeyCounter.addAll((KeyCounter)out, (int)map.size(), m -> map.reference2ReferenceEntrySet().fastForEach(e -> m.addTo((Object)((AEKey)e.getKey()), BigIntegerUtils.getLongValue((BigInteger)((BigInteger)e.getValue())))));
        }

        public KeyCounter getAvailableStacks() {
            BigCellDataStorage data = this.getCellStorage();
            KeyCounter keyCounter = data.getKeyCounter();
            if (keyCounter == null) {
                keyCounter = new KeyCounter();
                data.setKeyCounter(keyCounter);
            } else {
                keyCounter.clear();
            }
            this.getAvailableStacks(keyCounter);
            keyCounter.removeEmptySubmaps();
            return keyCounter;
        }
    }

    private static class IO
    extends LONG
    implements IControllable {
        @Persisted
        private boolean isWorkingEnabled;
        @Persisted
        private boolean export;
        @Persisted
        private long rate = 0x2000000L;
        private final IActionSource mySrc = IActionSource.ofMachine((IActionHost)this);
        IFancyConfiguratorButton.Toggle toggle;

        private IO(MetaMachineBlockEntity holder) {
            super(holder);
        }

        @Override
        public Widget createUIWidget() {
            LongInputWidget longInput = new LongInputWidget(() -> this.rate, v -> {
                this.rate = v;
            });
            longInput.setMax((Number)Long.MAX_VALUE);
            longInput.setMin((Number)0L);
            return new WidgetGroup(0, 0, 100, 20).addWidget((Widget)longInput).addWidget((Widget)new LabelWidget(24, -16, () -> StorageAccessPartMachine.LANG_RATE_SETTING));
        }

        public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
            super.attachConfigurators(configuratorPanel);
            IFancyConfigurator[] iFancyConfiguratorArray = new IFancyConfigurator[1];
            this.toggle = new IFancyConfiguratorButton.Toggle((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy().getSubTexture(0.0, 0.0, 1.0, 0.5)}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy().getSubTexture(0.0, 0.5, 1.0, 0.5)}), () -> this.export, (cd, b2) -> {
                this.export = b2;
            });
            iFancyConfiguratorArray[0] = this.toggle;
            configuratorPanel.attachConfigurators(iFancyConfiguratorArray);
            if (this.isRemote()) {
                this.toggle.setTooltipsSupplier(export -> Collections.singletonList(export != false ? Component.m_237115_((String)StorageAccessPartMachine.LANG_EXPORT) : Component.m_237115_((String)StorageAccessPartMachine.LANG_IMPORT)));
            }
        }

        public boolean isWorkingEnabled() {
            return this.isWorkingEnabled;
        }

        public void setWorkingEnabled(boolean isWorkingAllowed) {
            this.isWorkingEnabled = isWorkingAllowed;
        }

        @Override
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            return this.export && this.isWorkingEnabled ? 0L : super.insert(what, amount, mode, source);
        }

        @Override
        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            return !this.export && this.isWorkingEnabled ? 0L : super.extract(what, amount, mode, source);
        }

        @Override
        void tickUpdate() {
            super.tickUpdate();
            if (!this.getMainNode().isActive() || !this.isWorkingEnabled) {
                return;
            }
            if (this.controllers.isEmpty() || Arrays.stream(this.getController().getParts()).anyMatch(p -> p instanceof StorageAccessPartMachine && p != this)) {
                this.isWorkingEnabled = false;
                return;
            }
            IGrid grid = this.getMainNode().getGrid();
            if (grid == null) {
                this.isWorkingEnabled = false;
                return;
            }
            this.transferContents(grid);
        }

        private void transferContents(IGrid grid) {
            boolean didStuff;
            MEStorage destination;
            KeyCounter srcList;
            IO src;
            MEStorage networkInv = grid.getStorageService().getInventory();
            long itemsToMove = this.rate;
            if (this.export) {
                src = this;
                srcList = this.getAvailableStacks();
                destination = networkInv;
            } else {
                src = networkInv;
                srcList = grid.getStorageService().getCachedInventory();
                destination = this;
            }
            IEnergyService energy = grid.getEnergyService();
            block0: do {
                didStuff = false;
                for (Reference2LongMap.Entry srcEntry : srcList) {
                    AEKey what;
                    long possible;
                    long totalStackSize = srcEntry.getLongValue();
                    if (totalStackSize <= 0L || (possible = destination.insert(what = (AEKey)srcEntry.getKey(), totalStackSize, Actionable.SIMULATE, this.mySrc)) <= 0L) continue;
                    possible = Math.min(possible, itemsToMove * (long)what.getAmountPerOperation());
                    if ((possible = src.extract(what, possible, Actionable.MODULATE, this.mySrc)) <= 0L) continue;
                    long inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)destination, (AEKey)what, (long)possible, (IActionSource)this.mySrc);
                    if (inserted < possible) {
                        src.insert(what, possible - inserted, Actionable.MODULATE, this.mySrc);
                    }
                    if (inserted <= 0L) continue block0;
                    itemsToMove -= Math.max(1L, inserted / (long)what.getAmountPerOperation());
                    didStuff = true;
                    continue block0;
                }
            } while (itemsToMove > 0L && didStuff);
            this.isWorkingEnabled = didStuff;
        }
    }

    public static final class AlgaeAccessHatch
    extends LONG {
        private AlgaeAccessHatch(MetaMachineBlockEntity holder) {
            super(holder);
            this.uuid = UUID.randomUUID();
        }

        @Override
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            AEItemKey i;
            if (!(what instanceof AEItemKey) || !Algae.isAlgae(i = (AEItemKey)what)) {
                return 0L;
            }
            return super.insert(what, amount, mode, source);
        }

        @Override
        public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
            AEItemKey i;
            return what instanceof AEItemKey && Algae.isAlgae(i = (AEItemKey)what) && super.isPreferredStorageFor(what, source);
        }
    }
}

