/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.ProcessingPatternItem;
import com.fast.recipesearch.IntLongMap;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.NumberInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.PhantomFluidWidget;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.list.AEListGridWidget;
import com.gregtechceu.gtceu.utils.collection.FastObjectArrayList;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.machine.multiblock.part.ae.MEPatternBufferPartMachine;
import com.gtocore.common.machine.multiblock.part.ae.MEPatternBufferPartMachineKt;
import com.gtocore.config.GTOConfig;
import com.gtolib.GTOCore;
import com.gtolib.api.ae2.MyPatternDetailsHelper;
import com.gtolib.api.ae2.pattern.IParallelPatternDetails;
import com.gtolib.api.ae2.stacks.IIngredientConvertible;
import com.gtolib.api.ae2.stacks.TagPrefixKey;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.gui.ktflexible.VBoxBuilder;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.utils.holder.ObjectHolder;
import com.hepdd.gtmthings.common.item.VirtualItemProviderBehavior;
import com.hepdd.gtmthings.data.CustomItems;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomSlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.layout.Align;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.Position;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DataGeneratorScanned
public class MEWildcardPatternBufferPartMachine
extends MEPatternBufferPartMachineKt {
    private List<IPatternDetails> cachedPatterns;
    private boolean dirty = true;
    private boolean lock = false;
    private int scannedPatterns = 0;
    @Persisted
    private int patternPriority = 0;
    @Persisted
    private int maxFluidsOutput = 1;
    @Persisted
    private int maxItemsOutput = 1;
    @Persisted
    private final CustomItemStackHandler blacklistedItems;
    @Persisted
    private final ItemStackTransfer blacklistedItemsStorageTransfer;
    @Persisted
    private final CustomFluidTank[] blacklistedFluids;
    private final Int2ReferenceOpenHashMap<Material> blacklistedMaterials = new Int2ReferenceOpenHashMap();
    private static final int left = 22;
    private static final int top = 180;
    private static final int rowSize = 3;
    private static final int colSize = 6;
    private static final int width = 62;
    private static final int height = 42;
    @RegisterLanguage(cn="\u6837\u677f\u4f18\u5148\u7ea7\uff1a", en="Pattern Priority: ")
    private static final String LANG_WILDCARD_PATTERN_BUFFER_PRIORITY = "gtocore.ae.appeng.pattern.priority";
    @RegisterLanguage(cn="\u6b64\u6837\u677f\u603b\u6210\u63d0\u4f9b\u7684\u6837\u677f\u4f18\u5148\u7ea7\u3002\u5408\u6210\u8ba1\u7b97\u5c06\u4f18\u5148\u8003\u8651\u4f18\u5148\u7ea7\u6700\u9ad8\u7684\u6837\u677f\u3002", en="The priority for the patterns offered by this provider. The crafting calculation will prioritize patterns with the highest priority.")
    private static final String LANG_WILDCARD_PATTERN_BUFFER_PRIORITY_DESC = "gtocore.ae.appeng.pattern.priority.desc";
    @RegisterLanguage(cn="\u901a\u914d\u7b26\u6837\u677f\u603b\u6210\u6750\u6599\u9ed1\u540d\u5355", en="Wildcard Pattern Provider Material Blacklist")
    private static final String LANG_WILDCARD_PATTERN_BUFFER_BLACKLIST = "gtocore.ae.appeng.wildcard_pattern_buffer.blacklist";
    @RegisterLanguage(cn="\u6dfb\u52a0\u5230\u9ed1\u540d\u5355\u4e2d\u7684\u6750\u6599\u5c06\u4e0d\u4f1a\u88ab\u901a\u914d\u7b26\u6837\u677f\u603b\u6210\u6240\u4f7f\u7528\u3002", en="Materials added to the blacklist will not be used by the Wildcard Pattern Provider.")
    private static final String LANG_WILDCARD_PATTERN_BUFFER_BLACKLIST_DESC = "gtocore.ae.appeng.wildcard_pattern_buffer.blacklist.desc";
    @RegisterLanguage(cn="\u6700\u5927\u7269\u54c1\u8f93\u51fa\u79cd\u6570\uff1a", en="Max Item Output Types: ")
    private static final String LANG_WILDCARD_PATTERN_BUFFER_MAX_ITEM_OUTPUT_TYPES = "gtocore.ae.appeng.wildcard_pattern_buffer.max_item_output_types";
    @RegisterLanguage(cn="\u81ea\u52a8\u751f\u6210\u7684\u6837\u677f\u4e2d\u4ea7\u7269\u5141\u8bb8\u7684\u6700\u5927\u7269\u54c1\u79cd\u7c7b\u6570\u3002", en="The maximum number of item types allowed in the outputs of auto-generated patterns.")
    private static final String LANG_WILDCARD_PATTERN_BUFFER_MAX_ITEM_OUTPUT_TYPES_DESC = "gtocore.ae.appeng.wildcard_pattern_buffer.max_item_output_types.desc";
    @RegisterLanguage(cn="\u4f8b\u5982\uff0c\u751f\u6210\u7684\u6837\u677f\u4e2d\uff0c\u82e5\u914d\u65b9\u8f93\u51fa\u65e2\u542b\u6709\u7269\u54c1\uff0c\u53c8\u542b\u6709\u6d41\u4f53\uff0c\u5c06\u6b64\u9879\u8bbe\u4e3a0\uff0c\u5219\u4ec5\u5141\u8bb8\u6d41\u4f53\u4f5c\u4e3a\u6837\u677f\u7684\u4ea7\u7269\u3002", en="For example, in generated patterns, if the recipe outputs both items and fluids, setting this to 0 will only allow fluids as outputs of the pattern.")
    private static final String LANG_WILDCARD_PATTERN_BUFFER_MAX_ITEM_OUTPUT_TYPES_EXAMPLE = "gtocore.ae.appeng.wildcard_pattern_buffer.max_item_output_types.example";
    @RegisterLanguage(cn="\u6700\u5927\u6d41\u4f53\u8f93\u51fa\u79cd\u6570\uff1a", en="Max Fluid Output Types: ")
    private static final String LANG_WILDCARD_PATTERN_BUFFER_MAX_FLUID_OUTPUT_TYPES = "gtocore.ae.appeng.wildcard_pattern_buffer.max_fluid_output_types";
    @RegisterLanguage(cn="\u81ea\u52a8\u751f\u6210\u7684\u6837\u677f\u4e2d\u4ea7\u7269\u5141\u8bb8\u7684\u6700\u5927\u6d41\u4f53\u79cd\u7c7b\u6570\u3002", en="The maximum number of fluid types allowed in the outputs of auto-generated patterns.")
    private static final String LANG_WILDCARD_PATTERN_BUFFER_MAX_FLUID_OUTPUT_TYPES_DESC = "gtocore.ae.appeng.wildcard_pattern_buffer.max_fluid_output_types.desc";
    @RegisterLanguage(cn="\u4f8b\u5982\uff0c\u751f\u6210\u7684\u6837\u677f\u4e2d\uff0c\u82e5\u914d\u65b9\u8f93\u51fa\u542b\u6709\u591a\u79cd\u6d41\u4f53\uff0c\u5c06\u6b64\u9879\u8bbe\u4e3a1\uff0c\u5219\u4ec5\u5141\u8bb8\u914d\u65b9\u4e2d\u7684\u7b2c\u4e00\u79cd\u6d41\u4f53\u4f5c\u4e3a\u6837\u677f\u7684\u4ea7\u7269\u3002", en="For example, in generated patterns, if the recipe outputs multiple fluids, setting this to 1 will only allow the first fluid in the recipe as the output of the pattern.")
    private static final String LANG_WILDCARD_PATTERN_BUFFER_MAX_FLUID_OUTPUT_TYPES_EXAMPLE = "gtocore.ae.appeng.wildcard_pattern_buffer.max_fluid_output_types.example";
    @RegisterLanguage(cn="\u5df2\u626b\u63cf\u52a0\u8f7d%s\u79cd\u901a\u914d\u7b26\u6837\u677f\u3002", en="Scanned and loaded %s wildcard patterns.")
    static final String LANG_WILDCARD_PATTERN_BUFFER_LOADED_PATTERNS = "gtocore.ae.appeng.wildcard_pattern_buffer.loaded_patterns";

    public MEWildcardPatternBufferPartMachine(@NotNull MetaMachineBlockEntity holder) {
        super(holder, 1);
        this.blacklistedItems = new CustomItemStackHandler(18);
        this.blacklistedItemsStorageTransfer = new ItemStackTransfer(36);
        this.blacklistedFluids = new CustomFluidTank[18];
        Arrays.setAll(this.blacklistedFluids, i -> new CustomFluidTank(1));
        this.shareInventory.addChangedListener(this::requestPatternUpdate);
        this.circuitInventorySimulated.addChangedListener(this::requestPatternUpdate);
        this.shareTank.addChangedListener(this::requestPatternUpdate);
        ((MEPatternBufferPartMachine.InternalSlot[])this.getInternalInventory())[0].shareTank.addChangedListener(this::requestPatternUpdate);
        Runnable requestPatternUpdateIfUnlocked = () -> {
            if (!((MEPatternBufferPartMachine.InternalSlot[])this.getInternalInventory())[0].isLock()) {
                this.requestPatternUpdate();
            }
        };
        ((MEPatternBufferPartMachine.InternalSlot[])this.getInternalInventory())[0].circuitInventory.addChangedListener(requestPatternUpdateIfUnlocked);
        ((MEPatternBufferPartMachine.InternalSlot[])this.getInternalInventory())[0].shareInventory.addChangedListener(requestPatternUpdateIfUnlocked);
        ((MEPatternBufferPartMachine.InternalSlot[])this.getInternalInventory())[0].setShouldLockRecipe(false);
    }

    @Override
    public boolean patternFilter(ItemStack stack) {
        return stack.m_41720_() instanceof ProcessingPatternItem;
    }

    @Override
    @Nullable
    public IPatternDetails decodePattern(@NotNull ItemStack stack, int index) {
        IPatternDetails pattern = MyPatternDetailsHelper.decodePattern((ItemStack)stack, (BlockEntity)this.holder, (IGrid)this.getGrid());
        if (pattern == null) {
            return null;
        }
        return IParallelPatternDetails.of((IPatternDetails)pattern, (Level)this.getLevel(), (long)1L);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.loadBlacklistData();
    }

    @Override
    public void onPatternChange(int index) {
        super.onPatternChange(index);
        this.requestPatternUpdate();
    }

    public void onChanged() {
        super.onChanged();
    }

    private void requestPatternUpdate() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        this.dirty = true;
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
        this.lock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        try {
            this.lock = true;
            boolean bl = ((MEPatternBufferPartMachine.InternalSlot[])this.getInternalInventory())[0].pushPattern(patternDetails, inputHolder);
            return bl;
        }
        finally {
            this.lock = false;
        }
    }

    private void setMaxFluidsOutput(int integer) {
        int last = this.maxFluidsOutput;
        this.maxFluidsOutput = Math.max(0, integer);
        if (last != this.maxFluidsOutput) {
            this.requestPatternUpdate();
        }
    }

    private void setMaxItemsOutput(int integer) {
        int last = this.maxItemsOutput;
        this.maxItemsOutput = Math.max(0, integer);
        if (last != this.maxItemsOutput) {
            this.requestPatternUpdate();
        }
    }

    private void loadBlacklistData() {
        Material mat;
        int i;
        this.blacklistedMaterials.clear();
        for (i = 0; i < this.blacklistedItems.getSlots(); ++i) {
            ItemStack stack = this.blacklistedItems.getStackInSlot(i);
            if (stack.m_41619_() || (mat = ChemicalHelper.getMaterialStack((ItemStack)stack).material()) == GTMaterials.NULL) continue;
            this.blacklistedMaterials.put(i, (Object)mat);
        }
        while (i < this.blacklistedItems.getSlots() + this.blacklistedFluids.length) {
            CustomFluidTank tank = this.blacklistedFluids[i - this.blacklistedItems.getSlots()];
            if (!tank.isEmpty() && (mat = ChemicalHelper.getMaterial((Fluid)tank.getFluid().getFluid())) != GTMaterials.NULL) {
                this.blacklistedMaterials.put(i, (Object)mat);
            }
            ++i;
        }
        this.requestPatternUpdate();
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    private void rebuildCacheIfNeeded(List<IPatternDetails> patterns) {
        if (this.dirty || this.cachedPatterns == null) {
            this.dirty = false;
            long nanos = System.nanoTime();
            AtomicLong substitutingIngredients = new AtomicLong();
            AtomicLong validatingPatterns = new AtomicLong();
            FastObjectArrayList newPatterns = new FastObjectArrayList();
            ArrayList[] sharedInputs = new ArrayList[patterns.size()];
            ArrayList[] tagPrefixInputs = new ArrayList[patterns.size()];
            ArrayList[] sharedOutputs = new ArrayList[patterns.size()];
            ArrayList[] tagPrefixOutputs = new ArrayList[patterns.size()];
            long startSubstituting = System.nanoTime();
            for (int i = 0; i < patterns.size(); ++i) {
                IPatternDetails p = patterns.get(i);
                if (!(p instanceof AEProcessingPattern)) continue;
                AEProcessingPattern processingPattern = (AEProcessingPattern)p;
                GenericStack[] sparseInput = processingPattern.getSparseInputs();
                ArrayList<GenericStack> sharedInputList = new ArrayList<GenericStack>(sparseInput.length);
                ArrayList<GenericStack> tagPrefixInputList = new ArrayList<GenericStack>(sparseInput.length);
                for (GenericStack stack : sparseInput) {
                    if (stack.what() instanceof TagPrefixKey) {
                        tagPrefixInputList.add(stack);
                        continue;
                    }
                    sharedInputList.add(stack);
                }
                sharedInputs[i] = sharedInputList;
                tagPrefixInputs[i] = tagPrefixInputList;
                GenericStack[] sparseOutput = processingPattern.getSparseOutputs();
                ArrayList<GenericStack> sharedOutputList = new ArrayList<GenericStack>(sparseOutput.length);
                ArrayList<GenericStack> tagPrefixOutputList = new ArrayList<GenericStack>(sparseOutput.length);
                for (GenericStack stack : sparseOutput) {
                    if (stack.what() instanceof TagPrefixKey) {
                        tagPrefixOutputList.add(stack);
                        continue;
                    }
                    sharedOutputList.add(stack);
                }
                sharedOutputs[i] = sharedOutputList;
                tagPrefixOutputs[i] = tagPrefixOutputList;
            }
            substitutingIngredients.addAndGet(System.nanoTime() - startSubstituting);
            ReferenceCollection blacklistSet = this.blacklistedMaterials.values();
            GTCEuAPI.materialManager.getRegisteredMaterials().forEach(material -> {
                if (blacklistSet.contains(material)) {
                    return;
                }
                for (int i = 0; i < patterns.size(); ++i) {
                    IPatternDetails cp = (IPatternDetails)patterns.get(i);
                    if (!(cp instanceof AEProcessingPattern)) continue;
                    ArrayList<GenericStack> input = new ArrayList<GenericStack>(sharedInputs[i]);
                    ArrayList tagPrefixInput = tagPrefixInputs[i];
                    ArrayList<GenericStack> output = new ArrayList<GenericStack>(sharedOutputs[i]);
                    ArrayList tagPrefixOutput = tagPrefixOutputs[i];
                    long startSubstituting1 = System.nanoTime();
                    try {
                        AEKey what;
                        TagPrefixKey tagPrefixKey;
                        GenericStack gs;
                        for (Object stack : tagPrefixInput) {
                            gs = (GenericStack)stack;
                            tagPrefixKey = (TagPrefixKey)gs.what();
                            what = tagPrefixKey.getFromMaterial(material);
                            if (what == null) {
                                return;
                            }
                            input.add(new GenericStack(what, gs.amount()));
                        }
                        for (Object stack : tagPrefixOutput) {
                            gs = (GenericStack)stack;
                            tagPrefixKey = (TagPrefixKey)gs.what();
                            what = tagPrefixKey.getFromMaterial(material);
                            if (what == null) {
                                return;
                            }
                            output.add(new GenericStack(what, gs.amount()));
                        }
                    }
                    finally {
                        substitutingIngredients.addAndGet(System.nanoTime() - startSubstituting1);
                    }
                    long startValidating1 = System.nanoTime();
                    AEProcessingPattern detail = this.validatePattern(input.toArray(new GenericStack[0]), output.toArray(new GenericStack[0]));
                    if (detail != null) {
                        IParallelPatternDetails converted = IParallelPatternDetails.of((IPatternDetails)this.convertPattern((IPatternDetails)detail, 0), (Level)this.getLevel(), (long)1L);
                        newPatterns.add((Object)converted);
                    }
                    validatingPatterns.addAndGet(System.nanoTime() - startValidating1);
                }
            });
            this.cachedPatterns = newPatterns;
            this.scannedPatterns = this.cachedPatterns.size();
            if (GTOConfig.INSTANCE.aeLog) {
                GTOCore.LOGGER.info("MEWildcardPatternBufferPartMachine recalculated patterns: {} patterns in {} ms", (Object)this.scannedPatterns, (Object)((double)(System.nanoTime() - nanos) / 1000000.0));
                GTOCore.LOGGER.info("  substituting ingredients took {} ms ({})%", (Object)((double)substitutingIngredients.get() / 1000000.0), (Object)((double)substitutingIngredients.get() * 100.0 / (double)(System.nanoTime() - nanos)));
                GTOCore.LOGGER.info("  validating patterns took {} ms ({})%", (Object)((double)validatingPatterns.get() / 1000000.0), (Object)((double)validatingPatterns.get() * 100.0 / (double)(System.nanoTime() - nanos)));
            }
        }
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull IPatternDetails> getAvailablePatterns() {
        List<IPatternDetails> patterns = super.getAvailablePatterns();
        if (patterns.isEmpty() && (patterns = this.readInv()).isEmpty()) {
            this.scannedPatterns = 0;
            return patterns;
        }
        this.rebuildCacheIfNeeded(patterns);
        return this.cachedPatterns;
    }

    private List<@NotNull IPatternDetails> readInv() {
        ItemStack pattern = this.getPatternInventory().getStackInSlot(0);
        IPatternDetails details = this.decodePattern(pattern, 0);
        return details == null ? List.of() : List.of(details);
    }

    public static void onMultiblockRecipeTypeChange(MultiblockControllerMachine machine) {
        Arrays.stream(machine.getParts()).filter(MEWildcardPatternBufferPartMachine.class::isInstance).map(MEWildcardPatternBufferPartMachine.class::cast).forEach(MEWildcardPatternBufferPartMachine::requestPatternUpdate);
    }

    private AEProcessingPattern validatePattern(GenericStack[] sparseInput, GenericStack[] sparseOutput) {
        AEProcessingPattern outPattern;
        ObjectHolder valid = new ObjectHolder(null);
        IRecipeCapabilityHolder inputHolder = this.virtual(sparseInput);
        if (this.recipeType == GTORecipeTypes.HATCH_COMBINED) {
            if (!this.getRecipeTypes().isEmpty()) {
                for (GTRecipeType rt : this.getRecipeTypes()) {
                    if (rt.findRecipe(inputHolder, r -> {
                        if (this.checkProb((GTRecipe)r)) {
                            valid.value = (Recipe)r;
                            return true;
                        }
                        return false;
                    })) break;
                }
            }
        } else {
            this.recipeType.findRecipe(inputHolder, r -> {
                if (this.checkProb((GTRecipe)r)) {
                    valid.value = (Recipe)r;
                    return true;
                }
                return false;
            });
        }
        if ((outPattern = MyPatternDetailsHelper.convertFromGTRecipe((Recipe)((Recipe)valid.value), (int)this.maxItemsOutput, (int)this.maxFluidsOutput)) != null) {
            GenericStack[] outSparse = outPattern.getSparseOutputs();
            for (GenericStack reqStack : sparseOutput) {
                boolean found = false;
                for (GenericStack outStack : outSparse) {
                    if (reqStack.what() != outStack.what() || reqStack.amount() > outStack.amount()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return null;
            }
            return outPattern;
        }
        return null;
    }

    private boolean checkProb(GTRecipe recipe) {
        for (Content ingredient : recipe.getInputContents((RecipeCapability)ItemRecipeCapability.CAP)) {
            if (ingredient.chance == 10000 || ingredient.chance == 0) continue;
            return false;
        }
        for (Content ingredient : recipe.getInputContents((RecipeCapability)FluidRecipeCapability.CAP)) {
            if (ingredient.chance == 10000 || ingredient.chance == 0) continue;
            return false;
        }
        return true;
    }

    private IRecipeCapabilityHolder virtual(final GenericStack[] sparseInput) {
        return new IRecipeCapabilityHolder(){

            @NotNull
            public Map<IO, List<RecipeHandlerList>> getCapabilitiesProxy() {
                return Map.of(IO.IN, List.of(new VirtualList(MEWildcardPatternBufferPartMachine.this, sparseInput)));
            }

            @NotNull
            public Map<IO, Map<RecipeCapability<?>, List<IRecipeHandler<?>>>> getCapabilitiesFlat() {
                return Map.of();
            }
        };
    }

    @Override
    public void buildToolBoxContent(@NotNull VBoxBuilder $this$buildToolBoxContent) {
        $this$buildToolBoxContent.hBox(14, s -> {
            s.setPaddingBottom(4);
            return null;
        }, true, b2 -> {
            b2.widget((Widget)new LabelWidget(0, 0, () -> Component.m_237110_((String)LANG_WILDCARD_PATTERN_BUFFER_LOADED_PATTERNS, (Object[])new Object[]{this.scannedPatterns}).getString()));
            return null;
        });
        super.buildToolBoxContent($this$buildToolBoxContent);
    }

    @Override
    @NotNull
    public Widget createUIWidget() {
        WidgetGroup widget2 = new WidgetGroup(0, 0, 196, 220);
        Widget dsl = super.createUIWidget();
        widget2.addWidget(dsl);
        widget2.addWidget(this.createLabeledConfiguratorWidget(0, 120, this::getPatternPriority, this::setPatternPriority, LANG_WILDCARD_PATTERN_BUFFER_PRIORITY, LANG_WILDCARD_PATTERN_BUFFER_PRIORITY_DESC));
        widget2.addWidget(this.createLabeledConfiguratorWidget(64, 120, this::getMaxFluidsOutput, this::setMaxFluidsOutput, LANG_WILDCARD_PATTERN_BUFFER_MAX_FLUID_OUTPUT_TYPES, LANG_WILDCARD_PATTERN_BUFFER_MAX_FLUID_OUTPUT_TYPES_DESC, LANG_WILDCARD_PATTERN_BUFFER_MAX_FLUID_OUTPUT_TYPES_EXAMPLE));
        widget2.addWidget(this.createLabeledConfiguratorWidget(128, 120, this::getMaxItemsOutput, this::setMaxItemsOutput, LANG_WILDCARD_PATTERN_BUFFER_MAX_ITEM_OUTPUT_TYPES, LANG_WILDCARD_PATTERN_BUFFER_MAX_ITEM_OUTPUT_TYPES_DESC, LANG_WILDCARD_PATTERN_BUFFER_MAX_ITEM_OUTPUT_TYPES_EXAMPLE));
        WidgetGroup AlignContainer = new WidgetGroup(0, 160, 178, 20);
        Widget labelWidget1 = new LabelWidget(64, 152, LANG_WILDCARD_PATTERN_BUFFER_BLACKLIST).setAlign(Align.CENTER).setHoverTooltips(new Component[]{Component.m_237115_((String)LANG_WILDCARD_PATTERN_BUFFER_BLACKLIST_DESC)});
        AlignContainer.addWidget(labelWidget1);
        widget2.addWidget((Widget)AlignContainer);
        widget2.addWidget(this.createFluidBlacklistWidget());
        widget2.addWidget(this.createItemBlacklistWidget());
        return widget2;
    }

    private Widget createItemBlacklistWidget() {
        WidgetGroup container = new WidgetGroup(22, 180, 62, 42);
        DraggableScrollableWidgetGroup innner = new DraggableScrollableWidgetGroup(4, 4, 54, 34);
        int index = 0;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 3; ++x) {
                final int finalIndex = index++;
                innner.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)this.blacklistedItemsStorageTransfer, finalIndex, x * 18, y * 18){

                    public ItemStack slotClickPhantom(Slot slot, int mouseButton, ClickType clickTypeIn, ItemStack stackHeld) {
                        ItemStack stack = ItemStack.f_41583_;
                        ItemStack stackSlot = slot.m_7993_();
                        if (!stackSlot.m_41619_()) {
                            stack = stackSlot.m_41777_();
                        }
                        Material materialSlot = ChemicalHelper.getMaterialStack((ItemStack)stackSlot).material();
                        Material materialHeld = ChemicalHelper.getMaterialStack((ItemStack)stackHeld).material();
                        if (materialHeld == GTMaterials.NULL || mouseButton == 2 || mouseButton == 1) {
                            this.fillPhantomSlot(slot, ItemStack.f_41583_);
                            MEWildcardPatternBufferPartMachine.this.blacklistedItems.setStackInSlot(finalIndex, ItemStack.f_41583_);
                            MEWildcardPatternBufferPartMachine.this.loadBlacklistData();
                        } else if (materialSlot == GTMaterials.NULL) {
                            if (!MEWildcardPatternBufferPartMachine.this.blacklistedMaterials.containsValue((Object)materialHeld)) {
                                this.fillPhantomSlot(slot, stackHeld);
                                ItemStack itemStack = stackHeld.m_41777_();
                                itemStack.m_41764_(Integer.MAX_VALUE);
                                MEWildcardPatternBufferPartMachine.this.blacklistedItems.setStackInSlot(finalIndex, itemStack);
                                MEWildcardPatternBufferPartMachine.this.loadBlacklistData();
                            }
                        } else if (materialSlot != materialHeld && !MEWildcardPatternBufferPartMachine.this.blacklistedMaterials.containsValue((Object)materialHeld)) {
                            this.fillPhantomSlot(slot, stackHeld);
                            ItemStack itemStack = stackHeld.m_41777_();
                            itemStack.m_41764_(Integer.MAX_VALUE);
                            MEWildcardPatternBufferPartMachine.this.blacklistedItems.setStackInSlot(finalIndex, itemStack);
                            MEWildcardPatternBufferPartMachine.this.loadBlacklistData();
                        }
                        return stack;
                    }

                    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
                        Position position = this.getPosition();
                        GuiTextures.SLOT.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
                        GuiTextures.CONFIG_ARROW_DARK.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
                        int stackX = position.x + 1;
                        int stackY = position.y + 1;
                        if (this.getHandler() != null) {
                            ItemStack stack = this.getHandler().m_7993_();
                            DrawerHelper.drawItemStack((GuiGraphics)graphics, (ItemStack)stack, (int)stackX, (int)stackY, (int)-1, null);
                        }
                        if (this.mouseOverStock(mouseX, mouseY)) {
                            AEListGridWidget.drawSelectionOverlay((GuiGraphics)graphics, (int)stackX, (int)(stackY + 18), (int)16, (int)16);
                        }
                    }

                    private void fillPhantomSlot(Slot slot, ItemStack stackHeld) {
                        if (stackHeld.m_41619_()) {
                            slot.m_5852_(ItemStack.f_41583_);
                        } else {
                            ItemStack phantomStack = stackHeld.m_41777_();
                            phantomStack.m_41764_(1);
                            slot.m_5852_(phantomStack);
                        }
                    }

                    public boolean areItemsEqual(ItemStack itemStack1, ItemStack itemStack2) {
                        return ItemStack.m_41728_((ItemStack)itemStack1, (ItemStack)itemStack2);
                    }

                    private boolean mouseOverStock(double mouseX, double mouseY) {
                        Position position = this.getPosition();
                        return 2.isMouseOver((int)position.x, (int)(position.y + 18), (int)18, (int)18, (double)mouseX, (double)mouseY);
                    }

                    public List<Component> getFullTooltipTexts() {
                        Material mat;
                        List superText = super.getFullTooltipTexts();
                        if (this.slotReference != null && (mat = ChemicalHelper.getMaterialStack((ItemStack)this.slotReference.m_7993_()).material()) != GTMaterials.NULL) {
                            superText.addFirst(Component.m_237110_((String)"metaitem.tool.tooltip.primary_material", (Object[])new Object[]{mat.getLocalizedName()}));
                        }
                        return superText;
                    }
                }.setClearSlotOnRightClick(false).setChangeListener(this::onChanged));
            }
        }
        container.addWidget((Widget)innner);
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return container;
    }

    private Widget createFluidBlacklistWidget() {
        WidgetGroup container = new WidgetGroup(100, 180, 62, 42);
        DraggableScrollableWidgetGroup inner = new DraggableScrollableWidgetGroup(4, 4, 54, 34);
        int index = 0;
        int shift = this.blacklistedItems.getSlots();
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 3; ++x) {
                int fluidIndex = index++;
                inner.addWidget((Widget)new PhantomFluidWidget(this, (IFluidHandler)this.blacklistedFluids[fluidIndex], fluidIndex, x * 18, y * 18, 18, 18, () -> this.blacklistedFluids[fluidIndex].getFluid(), fluid -> {
                    int shiftedIndex = fluidIndex + shift;
                    if (fluid.isEmpty()) {
                        this.blacklistedFluids[fluidIndex].setFluid(fluid);
                        if (!this.blacklistedMaterials.isEmpty() && this.blacklistedMaterials.containsKey(shiftedIndex)) {
                            this.blacklistedMaterials.remove(shiftedIndex);
                        }
                        this.loadBlacklistData();
                        return;
                    }
                    Material fluidMaterial = ChemicalHelper.getMaterial((Fluid)fluid.getFluid());
                    for (Int2ReferenceMap.Entry entry : this.blacklistedMaterials.int2ReferenceEntrySet()) {
                        int i = entry.getIntKey() - shift;
                        Material f = (Material)entry.getValue();
                        if (i != fluidIndex && f == fluidMaterial) {
                            return;
                        }
                        if (i != fluidIndex || f == fluidMaterial) continue;
                        this.setFluid(fluidIndex, (FluidStack)fluid);
                        return;
                    }
                    this.setFluid(fluidIndex, (FluidStack)fluid);
                }){

                    public List<Component> getFullTooltipTexts() {
                        List superTexts = super.getFullTooltipTexts();
                        Material mat = ChemicalHelper.getMaterial((Fluid)this.getFluid().getFluid());
                        if (mat != GTMaterials.NULL) {
                            superTexts.addFirst(Component.m_237110_((String)"metaitem.tool.tooltip.primary_material", (Object[])new Object[]{mat.getLocalizedName()}));
                        }
                        return superTexts;
                    }
                }.setShowAmount(false).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
            }
        }
        container.addWidget((Widget)inner);
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return container;
    }

    private void setFluid(int index, FluidStack fs) {
        FluidStack newFluid = fs.copy();
        newFluid.setAmount(1);
        this.blacklistedFluids[index].setFluid(newFluid);
        this.loadBlacklistData();
    }

    private Widget createLabeledConfiguratorWidget(int x, int y, Supplier<Integer> getter, Consumer<Integer> setter, String labelLangKey, String ... descLangKey) {
        WidgetGroup priorityGroup = new WidgetGroup(x, y, 60, 40);
        Widget labelWidget = new ImageWidget(0, 0, 60, 12, (IGuiTexture)new TextTexture(Component.m_237115_((String)labelLangKey).getString()).setType(TextTexture.TextType.LEFT_HIDE).setWidth(65)).setHoverTooltips((Component[])Arrays.stream(descLangKey).map(Component::m_237115_).toArray(Component[]::new));
        priorityGroup.addWidget(labelWidget);
        Integer priority = getter.get();
        NumberInputWidget priorityWidget = new IntInputWidget(0, 14, 60, 12, getter, setter).setMin((Number)Integer.MIN_VALUE).setValue((Number)priority);
        priorityGroup.addWidget((Widget)priorityWidget);
        return priorityGroup;
    }

    @Generated
    public int getPatternPriority() {
        return this.patternPriority;
    }

    @Generated
    public void setPatternPriority(int patternPriority) {
        this.patternPriority = patternPriority;
    }

    @Generated
    public int getMaxFluidsOutput() {
        return this.maxFluidsOutput;
    }

    @Generated
    public int getMaxItemsOutput() {
        return this.maxItemsOutput;
    }

    private static class VirtualList
    extends RecipeHandlerList {
        private final GenericStack[] sparseInput;

        private VirtualList(MEWildcardPatternBufferPartMachine buffer, GenericStack[] sparseInput) {
            super(IO.IN, null);
            this.sparseInput = sparseInput;
            MEPatternBufferPartMachine.InternalSlot slot = ((MEPatternBufferPartMachine.InternalSlot[])buffer.getInternalInventory())[0];
            this.addHandlers(new IRecipeHandler[]{slot.circuitInventory, slot.shareInventory, slot.shareTank, buffer.circuitInventorySimulated, buffer.shareInventory, buffer.shareTank});
        }

        public IntLongMap getIngredientMap(@NotNull GTRecipeType type) {
            IntLongMap ings = super.getIngredientMap(type);
            for (GenericStack stack : this.sparseInput) {
                AEItemKey what;
                AEKey key = stack.what();
                if (key instanceof AEItemKey && (what = (AEItemKey)key).getItem() == CustomItems.VIRTUAL_ITEM_PROVIDER.get() && what.getTag() != null && what.getTag().f_128329_.containsKey("n")) {
                    ItemStack virtualItem = VirtualItemProviderBehavior.getVirtualItem((ItemStack)what.getReadOnlyStack());
                    if (virtualItem.m_41619_()) continue;
                    key = AEItemKey.of((ItemStack)virtualItem);
                }
                ((IIngredientConvertible)key).gtolib$convert(Integer.MAX_VALUE, ings);
            }
            return ings;
        }
    }
}

