/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.stacks.AEKey;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.list.AEListGridWidget;
import com.gregtechceu.gtceu.integration.ae2.utils.KeyStorage;
import com.gtocore.common.machine.multiblock.part.ae.MEPartMachine;
import com.gtolib.api.machine.trait.InaccessibleInfiniteTank;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MEOutputHatchPartMachine
extends MEPartMachine {
    @Persisted
    private final KeyStorage internalBuffer = new KeyStorage();
    private final InaccessibleInfiniteTank tank = new InaccessibleInfiniteTank((MetaMachine)this, this.internalBuffer);

    public MEOutputHatchPartMachine(MetaMachineBlockEntity holder) {
        super(holder, IO.OUT);
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.tank.updateAutoOutputSubscription();
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        this.tank.updateAutoOutputSubscription();
    }

    public void onMachineRemoved() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null && !this.internalBuffer.isEmpty()) {
            for (Reference2LongMap.Entry entry : this.internalBuffer) {
                grid.getStorageService().getInventory().insert((AEKey)entry.getKey(), entry.getLongValue(), Actionable.MODULATE, this.getActionSourceField());
            }
        }
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.superAttachConfigurators(configuratorPanel);
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 170, 65);
        group.addWidget((Widget)new LabelWidget(5, 0, () -> this.getOnlineField() ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new LabelWidget(5, 10, "gtceu.gui.waiting_list"));
        group.addWidget((Widget)new AEListGridWidget.Fluid(5, 20, 3, this.internalBuffer));
        return group;
    }
}

