/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.CircuitFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.machine.trait.CircuitHandler;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gtocore.common.machine.multiblock.part.ae.MEPartMachine;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAEItemList;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAEItemSlot;
import com.gtocore.common.machine.multiblock.part.ae.widget.AEItemConfigWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.Position;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MEInputBusPartMachine
extends MEPartMachine
implements IDataStickInteractable {
    private TickableSubscription autoIOSubs;
    @Persisted
    final ExportOnlyAEItemList aeItemHandler = this.createInventory();
    @Persisted
    protected final NotifiableItemStackHandler circuitInventory = CircuitHandler.create((MetaMachine)this);

    public MEInputBusPartMachine(MetaMachineBlockEntity holder) {
        super(holder, IO.IN);
    }

    public void onMachineRemoved() {
        this.flushInventory();
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.updateInventorySubscription();
    }

    ExportOnlyAEItemList createInventory() {
        return new ExportOnlyAEItemList((MetaMachine)this, 16);
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        this.updateInventorySubscription();
    }

    private void autoIO() {
        if (this.updateMEStatus()) {
            this.syncME();
            this.updateInventorySubscription();
        }
    }

    void syncME() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return;
        }
        MEStorage networkInv = grid.getStorageService().getInventory();
        for (ExportOnlyAEItemSlot aeSlot : this.aeItemHandler.getInventory()) {
            long extracted;
            GenericStack reqItem;
            GenericStack exceedItem = aeSlot.exceedStack();
            if (exceedItem != null) {
                long total = exceedItem.amount();
                long inserted = networkInv.insert(exceedItem.what(), exceedItem.amount(), Actionable.MODULATE, this.getActionSourceField());
                if (inserted > 0L) {
                    aeSlot.extractItem(inserted, false, true);
                    continue;
                }
                aeSlot.extractItem(total, false, true);
            }
            if ((reqItem = aeSlot.requestStack()) == null || (extracted = networkInv.extract(reqItem.what(), reqItem.amount(), Actionable.MODULATE, this.getActionSourceField())) == 0L) continue;
            aeSlot.addStack(new GenericStack(reqItem.what(), extracted));
        }
    }

    void updateInventorySubscription() {
        if (this.isWorkingEnabled() && this.getOnlineField()) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO, 40);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    void flushInventory() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            for (ExportOnlyAEItemSlot aeSlot : this.aeItemHandler.getInventory()) {
                GenericStack stock = aeSlot.getStock();
                if (stock == null) continue;
                grid.getStorageService().getInventory().insert(stock.what(), stock.amount(), Actionable.MODULATE, this.getActionSourceField());
            }
        }
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new CircuitFancyConfigurator(this.circuitInventory.storage)});
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(new Position(0, 0));
        group.addWidget((Widget)new LabelWidget(3, 0, () -> this.getOnlineField() ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new AEItemConfigWidget(3, 10, this.aeItemHandler));
        return group;
    }

    public final InteractionResult onDataStickShiftUse(Player player, ItemStack dataStick) {
        if (!this.isRemote()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_(this.getConfigKey(), (Tag)this.writeConfigToTag());
            dataStick.m_41751_(tag);
            dataStick.m_41714_((Component)Component.m_237110_((String)"gtceu.machine.me.import_part.data_stick.name", (Object[])new Object[]{Component.m_237115_((String)this.getDefinition().getDescriptionId())}));
            player.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.me.import_copy_settings"));
        }
        return InteractionResult.SUCCESS;
    }

    public final InteractionResult onDataStickUse(Player player, ItemStack dataStick) {
        CompoundTag tag = dataStick.m_41783_();
        if (tag == null || !tag.m_128441_(this.getConfigKey())) {
            return InteractionResult.PASS;
        }
        if (!this.isRemote()) {
            this.readConfigFromTag(tag.m_128469_(this.getConfigKey()));
            this.updateInventorySubscription();
            player.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.me.import_paste_settings"));
        }
        return InteractionResult.m_19078_((boolean)this.isRemote());
    }

    CompoundTag writeConfigToTag() {
        CompoundTag tag = new CompoundTag();
        CompoundTag configStacks = new CompoundTag();
        tag.m_128379_("DistinctBuses", this.isDistinct());
        if (!this.circuitInventory.storage.getStackInSlot(0).m_41619_()) {
            tag.m_128344_("GhostCircuit", (byte)IntCircuitBehaviour.getCircuitConfiguration((ItemStack)this.circuitInventory.storage.getStackInSlot(0)));
        }
        tag.m_128365_("ConfigStacks", (Tag)configStacks);
        for (int i = 0; i < 16; ++i) {
            ExportOnlyAEItemSlot slot = this.aeItemHandler.getInventory()[i];
            GenericStack config = slot.getConfig();
            if (config == null) continue;
            CompoundTag stackTag = GenericStack.writeTag((GenericStack)config);
            configStacks.m_128365_(Integer.toString(i), (Tag)stackTag);
        }
        return tag;
    }

    void readConfigFromTag(CompoundTag tag) {
        if (tag.m_128441_("DistinctBuses")) {
            this.setDistinct(tag.m_128471_("DistinctBuses"));
        }
        if (tag.m_128441_("GhostCircuit")) {
            this.circuitInventory.setStackInSlot(0, IntCircuitBehaviour.stack((int)tag.m_128445_("GhostCircuit")));
        } else {
            this.circuitInventory.setStackInSlot(0, ItemStack.f_41583_);
        }
        if (tag.m_128441_("ConfigStacks")) {
            CompoundTag configStacks = tag.m_128469_("ConfigStacks");
            for (int i = 0; i < 16; ++i) {
                String key = Integer.toString(i);
                if (configStacks.m_128441_(key)) {
                    CompoundTag configTag = configStacks.m_128469_(key);
                    this.aeItemHandler.getInventory()[i].setConfig(GenericStack.readTag((CompoundTag)configTag));
                    continue;
                }
                this.aeItemHandler.getInventory()[i].setConfig(null);
            }
        }
    }

    private String getConfigKey() {
        return this.getDefinition().getId().m_135815_();
    }
}

