/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.stacks.AEKey;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.list.AEListGridWidget;
import com.gregtechceu.gtceu.integration.ae2.utils.KeyStorage;
import com.gtocore.common.machine.multiblock.part.ae.MEPartMachine;
import com.gtolib.api.machine.trait.InaccessibleInfiniteHandler;
import com.gtolib.api.machine.trait.InaccessibleInfiniteTank;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.Position;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MEDualOutputPartMachine
extends MEPartMachine {
    @Persisted
    private final KeyStorage internalBuffer = new KeyStorage();
    @Persisted
    private final KeyStorage internalTankBuffer;
    private final InaccessibleInfiniteHandler handler = new InaccessibleInfiniteHandler((MetaMachine)this, this.internalBuffer);
    private final InaccessibleInfiniteTank tank;

    public MEDualOutputPartMachine(MetaMachineBlockEntity holder) {
        super(holder, IO.OUT);
        this.internalTankBuffer = new KeyStorage();
        this.tank = new InaccessibleInfiniteTank((MetaMachine)this, this.internalTankBuffer);
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.handler.updateAutoOutputSubscription();
        this.tank.updateAutoOutputSubscription();
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        this.handler.updateAutoOutputSubscription();
        this.tank.updateAutoOutputSubscription();
    }

    public void onMachineRemoved() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            if (!this.internalBuffer.isEmpty()) {
                for (Reference2LongMap.Entry entry : this.internalBuffer) {
                    grid.getStorageService().getInventory().insert((AEKey)entry.getKey(), entry.getLongValue(), Actionable.MODULATE, this.getActionSource());
                }
            }
            if (!this.internalTankBuffer.isEmpty()) {
                for (Reference2LongMap.Entry entry : this.internalTankBuffer) {
                    grid.getStorageService().getInventory().insert((AEKey)entry.getKey(), entry.getLongValue(), Actionable.MODULATE, this.getActionSource());
                }
            }
        }
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.superAttachConfigurators(configuratorPanel);
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(new Position(0, 0));
        group.addWidget((Widget)new LabelWidget(5, 0, () -> this.isOnline() ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new LabelWidget(5, 10, "gtceu.gui.waiting_list"));
        group.addWidget((Widget)new AEListGridWidget.Item(5, 20, 3, this.internalBuffer));
        group.addWidget((Widget)new AEListGridWidget.Fluid(5, 80, 3, this.internalTankBuffer));
        return group;
    }
}

