/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IExhaustVentMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.WorkableMultiblockPartMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SteamVentHatchMachine
extends WorkableMultiblockPartMachine
implements IExhaustVentMachine {
    @Persisted
    private boolean needsVenting;

    public SteamVentHatchMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public boolean isVentingBlocked() {
        BlockState state;
        Level level = this.getLevel();
        Direction ventingSide = this.getVentingDirection();
        BlockPos ventingBlockPos = this.getPos().m_121945_(ventingSide);
        if (level != null && (state = level.m_8055_(ventingBlockPos)).m_60734_() instanceof CarpetBlock) {
            return false;
        }
        return super.isVentingBlocked();
    }

    public void afterWorking(IWorkableMultiController controller) {
        this.needsVenting = true;
        this.checkVenting();
    }

    @NotNull
    public Direction getVentingDirection() {
        return this.getFrontFacing();
    }

    public boolean isNeedsVenting() {
        return this.needsVenting;
    }

    public void markVentingComplete() {
        this.needsVenting = false;
    }

    @Nullable
    public GTRecipe modifyRecipe(IWorkableMultiController controller, GTRecipe recipe) {
        if (this.needsVenting && this.isVentingBlocked()) {
            ((IEnhancedRecipeLogic)controller.getRecipeLogic()).gtolib$setIdleReason((Component)Component.m_237115_((String)"gtceu.recipe_logic.condition_fails").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"recipe.condition.steam_vent.tooltip")));
            return null;
        }
        return recipe;
    }

    public float getVentingDamage() {
        return 24.0f;
    }

    public boolean canShared() {
        return false;
    }

    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return false;
    }

    public void setNeedsVenting(boolean needsVenting) {
        this.needsVenting = needsVenting;
    }
}

