/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.machine.multiblock.part.FluidHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.SteamHatchPartMachine;
import com.gtocore.common.data.GTOMachines;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SteamFluidHatchPartMachine
extends FluidHatchPartMachine {
    private final String autoTooltipKey;

    public SteamFluidHatchPartMachine(MetaMachineBlockEntity holder, IO io) {
        super(holder, 1, io, 8000, 1, new Object[0]);
        this.autoTooltipKey = io == IO.IN ? "gtceu.gui.fluid_auto_input.tooltip" : "gtceu.gui.fluid_auto_output.tooltip";
    }

    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND_STEAM.get(SteamHatchPartMachine.IS_STEEL)}).widget((Widget)new ImageWidget(7, 16, 81, 55, (IGuiTexture)GuiTextures.DISPLAY_STEAM.get(SteamHatchPartMachine.IS_STEEL))).widget((Widget)new ToggleButtonWidget(7, 64, 18, 18, (IGuiTexture)GuiTextures.BUTTON_FLUID_OUTPUT, () -> ((SteamFluidHatchPartMachine)this).isWorkingEnabled(), arg_0 -> ((SteamFluidHatchPartMachine)this).setWorkingEnabled(arg_0)).setShouldUseBaseBackground().setTooltipText(this.autoTooltipKey)).widget((Widget)new LabelWidget(11, 20, "gtceu.gui.fluid_amount")).widget((Widget)new LabelWidget(11, 30, () -> "" + this.tank.getFluidInTank(0).getAmount()).setTextColor(-1).setDropShadow(true)).widget((Widget)new LabelWidget(6, 6, this.getBlockState().m_60734_().m_7705_())).widget((Widget)new TankWidget((IFluidHandler)this.tank.getStorages()[0], 90, 35, true, true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT)).widget((Widget)UITemplate.bindPlayerInventory((Inventory)entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT_STEAM.get(SteamHatchPartMachine.IS_STEEL), (int)7, (int)84, (boolean)true));
    }

    protected NotifiableItemStackHandler createCircuitItemHandler(Object ... args) {
        return NotifiableItemStackHandler.empty((MetaMachine)this);
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.superAttachConfigurators(configuratorPanel);
    }

    public boolean swapIO() {
        MetaMachineBlockEntity newHolder;
        MetaMachine metaMachine;
        BlockPos blockPos = this.getHolder().pos();
        MachineDefinition newDefinition = null;
        if (this.io == IO.IN) {
            newDefinition = GTOMachines.STEAM_FLUID_OUTPUT_HATCH;
        } else if (this.io == IO.OUT) {
            newDefinition = GTOMachines.STEAM_FLUID_INPUT_HATCH;
        }
        if (newDefinition == null) {
            return false;
        }
        BlockState newBlockState = newDefinition.get().m_49966_();
        this.getLevel().m_46597_(blockPos, newBlockState);
        BlockEntity blockEntity = this.getLevel().m_7702_(blockPos);
        if (blockEntity instanceof MetaMachineBlockEntity && (metaMachine = (newHolder = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof FluidHatchPartMachine) {
            FluidHatchPartMachine newMachine = (FluidHatchPartMachine)metaMachine;
            newMachine.setFrontFacing(this.getFrontFacing());
            newMachine.setUpwardsFacing(this.getUpwardsFacing());
            newMachine.setPaintingColor(this.getPaintingColor());
            for (int i = 0; i < this.tank.getTanks(); ++i) {
                newMachine.tank.setFluidInTank(i, this.tank.getFluidInTank(i));
            }
        }
        return true;
    }
}

