/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.FloatInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.TextBoxWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class SensorPartMachine
extends MultiblockPartMachine {
    @Persisted
    @DescSynced
    private float min;
    @Persisted
    @DescSynced
    private float max;
    @Persisted
    private boolean isInverted;
    @Persisted
    private int redstoneSignalOutput;

    public SensorPartMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(Position.ORIGIN, new Size(176, 112));
        group.addWidget((Widget)new TextBoxWidget(35, 28, 65, List.of(LocalizationUtils.format((String)"cover.advanced_energy_detector.min", (Object[])new Object[0]) + ":")));
        group.addWidget((Widget)new TextBoxWidget(35, 74, 65, List.of(LocalizationUtils.format((String)"cover.advanced_energy_detector.max", (Object[])new Object[0]) + ":")));
        group.addWidget((Widget)new FloatInputWidget(80, 26, 85, 18, this::getMin, this::setMin));
        group.addWidget((Widget)new FloatInputWidget(80, 72, 85, 18, this::getMax, this::setMax));
        group.addWidget((Widget)new MyToggleButtonWidget(this));
        return group;
    }

    public void update(float a2) {
        int output = SensorPartMachine.computeRedstoneBetweenValues(a2, this.max, this.min, this.isInverted);
        if (this.redstoneSignalOutput != output) {
            this.redstoneSignalOutput = output;
            this.updateSignal();
        }
    }

    private static int computeRedstoneBetweenValues(float value, float maxValue, float minValue, boolean isInverted) {
        if (value < minValue) {
            return isInverted ? 15 : 0;
        }
        if (value > maxValue) {
            return isInverted ? 15 : 0;
        }
        return (int)Math.ceil(15.0f * (isInverted ? maxValue - value : value - minValue) / (maxValue - minValue));
    }

    public int getOutputSignal(@Nullable Direction side) {
        if (side == this.getFrontFacing().m_122424_()) {
            return this.redstoneSignalOutput;
        }
        return 0;
    }

    public boolean canConnectRedstone(Direction side) {
        return side == this.getFrontFacing();
    }

    public boolean canShared() {
        return false;
    }

    private float getMin() {
        return this.min;
    }

    private float getMax() {
        return this.max;
    }

    private boolean isInverted() {
        return this.isInverted;
    }

    private void setMin(float min) {
        this.min = min;
    }

    private void setMax(float max) {
        this.max = max;
    }

    private void setInverted(boolean isInverted) {
        this.isInverted = isInverted;
    }

    @Generated
    public int getRedstoneSignalOutput() {
        return this.redstoneSignalOutput;
    }

    private class MyToggleButtonWidget
    extends ToggleButtonWidget {
        MyToggleButtonWidget(SensorPartMachine sensorPartMachine) {
            super(8, 8, 20, 20, (IGuiTexture)GuiTextures.INVERT_REDSTONE_BUTTON, sensorPartMachine::isInverted, sensorPartMachine::setInverted);
        }

        public void updateScreen() {
            super.updateScreen();
            this.setHoverTooltips(new String[]{"gtocore.machine.sensor.invert." + (this.isPressed ? "enabled" : "disabled")});
        }
    }
}

